/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/platform/JavaGenericVarianceViolationTypeChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "<init>", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJavaGenericVarianceViolationTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaGenericVarianceViolationTypeChecker.kt\norg/jetbrains/kotlin/resolve/jvm/platform/JavaGenericVarianceViolationTypeChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1863#2,2:92\n*S KotlinDebug\n*F\n+ 1 JavaGenericVarianceViolationTypeChecker.kt\norg/jetbrains/kotlin/resolve/jvm/platform/JavaGenericVarianceViolationTypeChecker\n*L\n75#1:92,2\n*E\n"})
public final class JavaGenericVarianceViolationTypeChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final JavaGenericVarianceViolationTypeChecker INSTANCE = new JavaGenericVarianceViolationTypeChecker();

    private JavaGenericVarianceViolationTypeChecker() {
    }

    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        KotlinType expectedType = kotlinType;
        if (TypeUtils.noExpectedType((KotlinType)expectedType) || ErrorUtils.INSTANCE.containsErrorType(expectedType) || ErrorUtils.INSTANCE.containsUninferredTypeVariable(expectedType)) {
            return;
        }
        if (expectedType.getArguments().isEmpty() || !FlexibleTypesKt.isFlexible((KotlinType)expectedType)) {
            return;
        }
        SimpleType lowerBound = FlexibleTypesKt.asFlexibleType((KotlinType)expectedType).getLowerBound();
        SimpleType upperBound = FlexibleTypesKt.asFlexibleType((KotlinType)expectedType).getUpperBound();
        if (Intrinsics.areEqual((Object)lowerBound.getConstructor(), (Object)upperBound.getConstructor())) {
            return;
        }
        if (expectedType.unwrap() instanceof RawTypeImpl) {
            return;
        }
        KotlinType kotlinType2 = TypeCheckingProcedure.findCorrespondingSupertype((KotlinType)expressionTypeWithSmartCast, (KotlinType)((KotlinType)lowerBound));
        if (kotlinType2 == null) {
            return;
        }
        KotlinType correspondingSubType = kotlinType2;
        boolean bl2 = bl = lowerBound.getArguments().size() == upperBound.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JavaGenericVarianceViolationTypeChecker$checkType$32 = false;
            String $i$a$-assert-JavaGenericVarianceViolationTypeChecker$checkType$32 = "Different arguments count in flexible bounds: (" + lowerBound + '(' + lowerBound.getArguments().size() + ").." + upperBound + '(' + upperBound.getArguments().size() + ')';
            throw new AssertionError((Object)$i$a$-assert-JavaGenericVarianceViolationTypeChecker$checkType$32);
        }
        boolean bl3 = bl = lowerBound.getArguments().size() == correspondingSubType.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JavaGenericVarianceViolationTypeChecker$checkType$42 = false;
            String $i$a$-assert-JavaGenericVarianceViolationTypeChecker$checkType$42 = "Different arguments count in corresponding subtype and supertype: (" + lowerBound + '(' + lowerBound.getArguments().size() + ").." + correspondingSubType + '(' + correspondingSubType.getArguments().size() + ')';
            throw new AssertionError((Object)$i$a$-assert-JavaGenericVarianceViolationTypeChecker$checkType$42);
        }
        List list = lowerBound.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        List lowerParameters = list;
        List list2 = upperBound.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
        List upperParameters = list2;
        List lowerArguments = lowerBound.getArguments();
        Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)correspondingSubType.getArguments());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl4 = false;
            TypeProjection lowerArgument = (TypeProjection)lowerArguments.get(index);
            if (((TypeParameterDescriptor)lowerParameters.get(index)).getVariance() != Variance.INVARIANT || ((TypeParameterDescriptor)upperParameters.get(index)).getVariance() != Variance.OUT_VARIANCE || lowerArgument.getProjectionKind() == Variance.OUT_VARIANCE || KotlinTypeChecker.DEFAULT.equalTypes(((TypeProjection)correspondingSubType.getArguments().get(index)).getType(), lowerArgument.getType())) continue;
            c.trace.report((Diagnostic)ErrorsJvm.JAVA_TYPE_MISMATCH.on((PsiElement)expression, (Object)expressionTypeWithSmartCast, (Object)expectedType));
        }
    }
}

