/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40;

import com.intellij.maven.server.m40.utils.Maven40TransferListenerAdapter;
import com.intellij.maven.server.m40.utils.Maven40WorkspaceMapReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.repository.internal.MavenSessionBuilderSupplier;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;

public class IdeaMavenSessionBuilderSupplier
extends MavenSessionBuilderSupplier {
    private final MavenWorkspaceMap myWorkspaceMap;
    private final MavenServerConsoleIndicatorImpl myIndicator;
    private final Path myLocalRepoPath;
    private final Map<String, String> mySystemProperties;
    private final Map<String, String> myUserProperties;

    public IdeaMavenSessionBuilderSupplier(RepositorySystem repositorySystem, MavenWorkspaceMap map, MavenServerConsoleIndicatorImpl indicator, @NotNull MavenExecutionRequest request) {
        if (request == null) {
            IdeaMavenSessionBuilderSupplier.$$$reportNull$$$0(0);
        }
        super(repositorySystem);
        this.mySystemProperties = new HashMap<String, String>();
        this.myUserProperties = new HashMap<String, String>();
        this.myWorkspaceMap = map;
        this.myIndicator = indicator;
        this.myLocalRepoPath = request.getLocalRepositoryPath().toPath();
        IdeaMavenSessionBuilderSupplier.putAll(request.getSystemProperties(), this.mySystemProperties);
        IdeaMavenSessionBuilderSupplier.putAll(request.getUserProperties(), this.myUserProperties);
    }

    private static void putAll(Properties from, Map<String, String> to) {
        from.stringPropertyNames().forEach(n -> to.put((String)n, from.getProperty((String)n)));
    }

    protected void configureSessionBuilder(RepositorySystemSession.SessionBuilder session) {
        super.configureSessionBuilder(session);
        session.setWorkspaceReader((WorkspaceReader)new Maven40WorkspaceMapReader(this.myWorkspaceMap)).setTransferListener((TransferListener)new Maven40TransferListenerAdapter(this.myIndicator)).setConfigProperty("aether.conflictResolver.verbose", (Object)true).setConfigProperty("aether.dependencyManager.verbose", (Object)true).setSystemProperties(this.mySystemProperties).setUserProperties(this.myUserProperties).withLocalRepositories(new LocalRepository[]{new LocalRepository(this.myLocalRepoPath)}).setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(1, 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/maven/server/m40/IdeaMavenSessionBuilderSupplier", "<init>"));
    }
}

