/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public final class CompactDataInput
implements DataInput {
    private final InputStream in;
    private final byte[] readBuffer = IOUtil.allocReadWriteUTFBuffer();

    public CompactDataInput(InputStream in) {
        this.in = in;
    }

    @Override
    public void readFully(byte @NotNull [] b2) throws IOException {
        if (b2 == null) {
            CompactDataInput.$$$reportNull$$$0(0);
        }
        this.readFully(b2, 0, b2.length);
    }

    @Override
    public void readFully(byte @NotNull [] b2, int off, int len) throws IOException {
        int count2;
        if (b2 == null) {
            CompactDataInput.$$$reportNull$$$0(1);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n2 = 0; n2 < len; n2 += count2) {
            count2 = this.in.read(b2, off + n2, len - n2);
            if (count2 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        int total;
        int cur;
        for (total = 0; total < n2 && (cur = (int)this.in.skip(n2 - total)) > 0; total += cur) {
        }
        return total;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public int readInt() throws IOException {
        return DataInputOutputUtil.readINT(this);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)(this.readBuffer[7] & 0xFF);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("readLine is not implemented!");
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        String string2 = IOUtil.readUTFFast(this.readBuffer, this);
        if (string2 == null) {
            CompactDataInput.$$$reportNull$$$0(2);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/CompactDataInput";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/CompactDataInput";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readUTF";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFully";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

