/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface IndexStorage<Key, Value>
extends Flushable,
Closeable {
    public void addValue(Key var1, int var2, Value var3) throws StorageException;

    public void removeAllValues(@NotNull Key var1, int var2) throws StorageException;

    default public void updateValue(Key key, int inputId, Value newValue) throws StorageException {
        this.removeAllValues(key, inputId);
        this.addValue(key, inputId, newValue);
    }

    public void clear() throws StorageException;

    @NotNull
    public ValueContainer<Value> read(Key var1) throws StorageException;

    public void clearCaches();

    @Override
    public void flush() throws IOException;

    public boolean isDirty();

    @Override
    public void close() throws IOException;

    @ApiStatus.Internal
    public boolean isClosed();
}

