/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributes
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(TextAttributes.class);
    private static final AttributesFlyweight DEFAULT_FLYWEIGHT = AttributesFlyweight.create(null, null, 0, null, EffectType.BOXED, Collections.emptyMap(), null);
    public static final TextAttributes ERASE_MARKER = new TextAttributes(){

        @Override
        public String toString() {
            return "[ERASE_MARKER]";
        }
    };
    @NotNull
    private AttributesFlyweight attrs;

    @Contract(value="!null, !null -> !null")
    public static TextAttributes merge(@Nullable TextAttributes under, @Nullable TextAttributes above) {
        if (under == null) {
            return above;
        }
        if (above == null) {
            return under;
        }
        TextAttributes attrs = under.clone();
        if (above.getBackgroundColor() != null) {
            attrs.setBackgroundColor(above.getBackgroundColor());
        }
        if (above.getForegroundColor() != null) {
            attrs.setForegroundColor(above.getForegroundColor());
        }
        attrs.setFontType(above.getFontType() | under.getFontType());
        TextAttributesEffectsBuilder.create(under).coverWith(above).applyTo(attrs);
        return attrs;
    }

    public TextAttributes() {
        this(DEFAULT_FLYWEIGHT);
    }

    private TextAttributes(@NotNull AttributesFlyweight attributesFlyweight) {
        if (attributesFlyweight == null) {
            TextAttributes.$$$reportNull$$$0(0);
        }
        this.attrs = attributesFlyweight;
    }

    public TextAttributes(@NotNull Element element) {
        if (element == null) {
            TextAttributes.$$$reportNull$$$0(1);
        }
        this.readExternal(element);
    }

    @ApiStatus.Internal
    public TextAttributes(@NotNull DataInput in) throws IOException {
        if (in == null) {
            TextAttributes.$$$reportNull$$$0(2);
        }
        this.readExternal(in);
    }

    public TextAttributes(@Nullable Color foregroundColor, @Nullable Color backgroundColor, @Nullable Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.setAttributes(foregroundColor, backgroundColor, effectColor, null, effectType, fontType);
    }

    public void copyFrom(@NotNull TextAttributes other) {
        if (other == null) {
            TextAttributes.$$$reportNull$$$0(3);
        }
        this.attrs = other.attrs;
    }

    public void setAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, Color errorStripeColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.attrs = AttributesFlyweight.create(foregroundColor, backgroundColor, fontType, effectColor, effectType, Collections.emptyMap(), errorStripeColor);
    }

    public boolean isEmpty() {
        return this.getForegroundColor() == null && this.getBackgroundColor() == null && this.getEffectColor() == null && this.getFontType() == 0;
    }

    @NotNull
    public AttributesFlyweight getFlyweight() {
        AttributesFlyweight attributesFlyweight = this.attrs;
        if (attributesFlyweight == null) {
            TextAttributes.$$$reportNull$$$0(4);
        }
        return attributesFlyweight;
    }

    @NotNull
    public static TextAttributes fromFlyweight(@NotNull AttributesFlyweight flyweight) {
        if (flyweight == null) {
            TextAttributes.$$$reportNull$$$0(5);
        }
        return new TextAttributes(flyweight);
    }

    public Color getForegroundColor() {
        return this.attrs.getForeground();
    }

    public void setForegroundColor(Color color) {
        this.attrs = this.attrs.withForeground(color);
    }

    public Color getBackgroundColor() {
        return this.attrs.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.attrs = this.attrs.withBackground(color);
    }

    public Color getEffectColor() {
        return this.attrs.getEffectColor();
    }

    public void setEffectColor(Color color) {
        this.attrs = this.attrs.withEffectColor(color);
    }

    public Color getErrorStripeColor() {
        return this.attrs.getErrorStripeColor();
    }

    public void setErrorStripeColor(Color color) {
        this.attrs = this.attrs.withErrorStripeColor(color);
    }

    @ApiStatus.Experimental
    public boolean hasEffects() {
        return this.attrs.hasEffects();
    }

    @ApiStatus.Experimental
    public void setAdditionalEffects(@NotNull @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> effectsMap) {
        if (effectsMap == null) {
            TextAttributes.$$$reportNull$$$0(6);
        }
        this.attrs = this.attrs.withAdditionalEffects(effectsMap);
    }

    @ApiStatus.Experimental
    public void withAdditionalEffect(@NotNull EffectType effectType, @NotNull Color color) {
        if (effectType == null) {
            TextAttributes.$$$reportNull$$$0(7);
        }
        if (color == null) {
            TextAttributes.$$$reportNull$$$0(8);
        }
        TextAttributesEffectsBuilder.create(this).coverWith(effectType, color).applyTo(this);
    }

    @Nullable
    public EffectType getEffectType() {
        return this.attrs.getEffectType();
    }

    @ApiStatus.Experimental
    public void forEachAdditionalEffect(@NotNull BiConsumer<? super EffectType, ? super Color> consumer2) {
        if (consumer2 == null) {
            TextAttributes.$$$reportNull$$$0(9);
        }
        this.attrs.getAdditionalEffects().forEach(consumer2);
    }

    @ApiStatus.Experimental
    public void forEachEffect(@NotNull BiConsumer<? super EffectType, ? super Color> consumer2) {
        if (consumer2 == null) {
            TextAttributes.$$$reportNull$$$0(10);
        }
        this.attrs.getAllEffects().forEach(consumer2);
    }

    public void setEffectType(EffectType effectType) {
        this.attrs = this.attrs.withEffectType(effectType);
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.attrs.getFontType();
    }

    public void setFontType(@JdkConstants.FontStyle int type2) {
        if (type2 < 0 || type2 > 3) {
            LOG.error("Wrong font type: " + type2);
            type2 = 0;
        }
        this.attrs = this.attrs.withFontType(type2);
    }

    public TextAttributes clone() {
        return new TextAttributes(this.attrs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        return Objects.equals(this.attrs, ((TextAttributes)obj).attrs);
    }

    public int hashCode() {
        return this.attrs.hashCode();
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            TextAttributes.$$$reportNull$$$0(11);
        }
        this.attrs = AttributesFlyweight.create(element);
    }

    @ApiStatus.Internal
    public void readExternal(@NotNull DataInput in) throws IOException {
        if (in == null) {
            TextAttributes.$$$reportNull$$$0(12);
        }
        this.attrs = AttributesFlyweight.create(in);
    }

    public void writeExternal(Element element) {
        this.attrs.writeExternal(element);
    }

    @ApiStatus.Internal
    public void writeExternal(@NotNull DataOutput out) throws IOException {
        if (out == null) {
            TextAttributes.$$$reportNull$$$0(13);
        }
        this.attrs.writeExternal(out);
    }

    public String toString() {
        return "[" + this.getForegroundColor() + "," + this.getBackgroundColor() + "," + this.getFontType() + "," + (Object)((Object)this.getEffectType()) + "," + this.getEffectColor() + "," + this.attrs.getAdditionalEffects() + "," + this.getErrorStripeColor() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesFlyweight";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/TextAttributes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flyweight";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectsMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlyweight";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromFlyweight";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalEffects";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withAdditionalEffect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEachAdditionalEffect";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forEachEffect";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

