/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.relevance;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.CoreUtilsKt;
import com.intellij.ml.inline.completion.impl.relevance.RelevanceChecker;
import com.intellij.ml.inline.completion.impl.relevance.RelevanceModelResponse;
import com.intellij.ml.inline.completion.impl.relevance.ScorePredictor;
import com.intellij.openapi.util.Version;
import com.intellij.platform.ml.LevelSignature;
import com.intellij.platform.ml.Tier;
import com.intellij.platform.ml.environment.Environment;
import com.intellij.platform.ml.feature.Feature;
import com.intellij.platform.ml.feature.FeatureSelector;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BY\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00120\u0010\u0006\u001a,\u0012(\u0012&\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t0\bj\u0002`\u000b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fB1\b\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0014JD\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00072,\u0010#\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\t0\u0016j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\t`\u0018H\u0016R.\u0010\u0015\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/intellij/ml/inline/completion/impl/relevance/ThresholdChecker;", "Lcom/intellij/ml/inline/completion/impl/relevance/RelevanceChecker;", "threshold", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "sessionTiers", "", "Lcom/intellij/platform/ml/LevelSignature;", "", "Lcom/intellij/platform/ml/Tier;", "Lcom/intellij/platform/ml/LevelTiers;", "language", "Lcom/intellij/lang/Language;", "randomPassProbability", "(DLcom/intellij/internal/ml/DecisionFunction;Ljava/util/List;Lcom/intellij/lang/Language;D)V", "scorePredictor", "Lcom/intellij/ml/inline/completion/impl/relevance/ScorePredictor;", "version", "Lcom/intellij/openapi/util/Version;", "(Lcom/intellij/ml/inline/completion/impl/relevance/ScorePredictor;Lcom/intellij/openapi/util/Version;Lcom/intellij/lang/Language;DD)V", "knownFeatures", "", "Lcom/intellij/platform/ml/feature/FeatureSelector;", "Lcom/intellij/platform/ml/PerTier;", "getKnownFeatures", "()Ljava/util/Map;", "getLanguage", "()Lcom/intellij/lang/Language;", "getVersion", "()Lcom/intellij/openapi/util/Version;", "predict", "Lcom/intellij/ml/inline/completion/impl/relevance/RelevanceModelResponse;", "callParameters", "Lcom/intellij/platform/ml/environment/Environment;", "features", "Lcom/intellij/platform/ml/feature/Feature;", "intellij.ml.inline.completion"})
@SourceDebugExtension(value={"SMAP\nCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Checkers.kt\ncom/intellij/ml/inline/completion/impl/relevance/ThresholdChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class ThresholdChecker
implements RelevanceChecker {
    @NotNull
    private final ScorePredictor scorePredictor;
    @Nullable
    private final Version version;
    @NotNull
    private final Language language;
    private final double threshold;
    private final double randomPassProbability;
    @NotNull
    private final Map<Tier<?>, FeatureSelector> knownFeatures;

    private ThresholdChecker(ScorePredictor scorePredictor, Version version, Language language, double threshold2, double randomPassProbability) {
        this.scorePredictor = scorePredictor;
        this.version = version;
        this.language = language;
        this.threshold = threshold2;
        this.randomPassProbability = randomPassProbability;
        this.knownFeatures = this.scorePredictor.getKnownFeatures();
    }

    @Nullable
    public Version getVersion() {
        return this.version;
    }

    @NotNull
    public Language getLanguage() {
        return this.language;
    }

    /*
     * WARNING - void declaration
     */
    public ThresholdChecker(double threshold2, @NotNull DecisionFunction decisionFunction, @NotNull List<LevelSignature<Set<Tier<?>>, Set<Tier<?>>>> sessionTiers, @NotNull Language language, double randomPassProbability) {
        Version version;
        Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
        Intrinsics.checkNotNullParameter(sessionTiers, (String)"sessionTiers");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        ThresholdChecker thresholdChecker = this;
        ScorePredictor scorePredictor = new ScorePredictor(decisionFunction, sessionTiers);
        String string = decisionFunction.version();
        if (string != null) {
            void it;
            String string2 = string;
            ScorePredictor scorePredictor2 = scorePredictor;
            ThresholdChecker thresholdChecker2 = thresholdChecker;
            boolean bl = false;
            Version version2 = Version.parseVersion((String)it);
            thresholdChecker = thresholdChecker2;
            scorePredictor = scorePredictor2;
            version = version2;
        } else {
            version = null;
        }
        thresholdChecker(scorePredictor, version, language, threshold2, randomPassProbability);
    }

    @NotNull
    public Map<Tier<?>, FeatureSelector> getKnownFeatures() {
        return this.knownFeatures;
    }

    @NotNull
    public RelevanceModelResponse predict(@NotNull List<? extends Environment> callParameters, @NotNull Map<Tier<?>, ? extends Set<? extends Feature>> features) {
        Intrinsics.checkNotNullParameter(callParameters, (String)"callParameters");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        double estimatedScore = this.scorePredictor.predict(callParameters, features);
        RelevanceModelResponse.Decision decision = CoreUtilsKt.randomPass(this.randomPassProbability) ? RelevanceModelResponse.Decision.RANDOM_PASS : (estimatedScore >= this.threshold ? RelevanceModelResponse.Decision.PASS : RelevanceModelResponse.Decision.SKIP);
        return new RelevanceModelResponse(estimatedScore, decision);
    }
}

