/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.html.PreviewEncodingUtil;
import org.intellij.plugins.markdown.ui.preview.html.links.IntelliJImageGeneratingProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder;", "", "html", "", "baseFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectRoot", "fileSchemeResourceProcessor", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "document", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "actuallyProcessImageNode", "", "node", "Lorg/jsoup/nodes/Node;", "closeTag", "encodeArgument", "argument", "ensureCorrectTag", "name", "generateDomBuildCalls", "generateRenderClosure", "openTag", "preprocessNode", "shouldPreprocessImageNode", "", "textElement", "getter", "Lkotlin/Function0;", "traverse", "intellij.markdown"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIncrementalDOMBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalDOMBuilder.kt\norg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,166:1\n23#2:167\n*S KotlinDebug\n*F\n+ 1 IncrementalDOMBuilder.kt\norg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder\n*L\n112#1:167\n*E\n"})
public final class IncrementalDOMBuilder {
    @Nullable
    private final VirtualFile baseFile;
    @Nullable
    private final VirtualFile projectRoot;
    @Nullable
    private final ResourceProvider fileSchemeResourceProcessor;
    private final Document document;
    @NotNull
    private final StringBuilder builder;

    public IncrementalDOMBuilder(@NotNull String html2, @Nullable VirtualFile baseFile, @Nullable VirtualFile projectRoot2, @Nullable ResourceProvider fileSchemeResourceProcessor) {
        Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
        this.baseFile = baseFile;
        this.projectRoot = projectRoot2;
        this.fileSchemeResourceProcessor = fileSchemeResourceProcessor;
        this.document = Jsoup.parse((String)html2);
        this.builder = new StringBuilder();
    }

    public /* synthetic */ IncrementalDOMBuilder(String string, VirtualFile virtualFile, VirtualFile virtualFile2, ResourceProvider resourceProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            resourceProvider = null;
        }
        this(string, virtualFile, virtualFile2, resourceProvider);
    }

    @NotNull
    public final String generateRenderClosure() {
        return "\n      () => {\n        const o = (tag, ...attrs) => IncrementalDOM.elementOpen(tag, null, null, ...attrs.map(decodeURIComponent));\n        const t = content => IncrementalDOM.text(decodeURIComponent(content));\n        const c = IncrementalDOM.elementClose;\n        " + this.generateDomBuildCalls() + "\n      }\n    ";
    }

    @NotNull
    public final String generateDomBuildCalls() {
        Element element2 = this.document.body();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"body(...)");
        this.traverse((Node)element2);
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String ensureCorrectTag(String name) {
        return Intrinsics.areEqual((Object)name, (Object)"body") ? "div" : name;
    }

    private final String encodeArgument(String argument) {
        return PreviewEncodingUtil.INSTANCE.encodeUrl(argument);
    }

    private final void openTag(Node node) {
        StringBuilder $this$openTag_u24lambda_u240 = this.builder;
        boolean bl = false;
        $this$openTag_u24lambda_u240.append("o('");
        String string = node.nodeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeName(...)");
        $this$openTag_u24lambda_u240.append(this.ensureCorrectTag(string));
        $this$openTag_u24lambda_u240.append("'");
        for (Attribute attribute : node.attributes()) {
            $this$openTag_u24lambda_u240.append(",'");
            $this$openTag_u24lambda_u240.append(attribute.getKey());
            $this$openTag_u24lambda_u240.append('\'');
            String value = attribute.getValue();
            if (value == null) continue;
            $this$openTag_u24lambda_u240.append(",'");
            $this$openTag_u24lambda_u240.append(this.encodeArgument(value));
            $this$openTag_u24lambda_u240.append("'");
        }
        $this$openTag_u24lambda_u240.append(");");
    }

    private final void closeTag(Node node) {
        StringBuilder $this$closeTag_u24lambda_u241 = this.builder;
        boolean bl = false;
        $this$closeTag_u24lambda_u241.append("c('");
        String string = node.nodeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeName(...)");
        $this$closeTag_u24lambda_u241.append(this.ensureCorrectTag(string));
        $this$closeTag_u24lambda_u241.append("');");
    }

    private final void textElement(Function0<String> getter) {
        StringBuilder $this$textElement_u24lambda_u242 = this.builder;
        boolean bl = false;
        $this$textElement_u24lambda_u242.append("t(`");
        $this$textElement_u24lambda_u242.append(this.encodeArgument((String)getter.invoke()));
        $this$textElement_u24lambda_u242.append("`);");
    }

    private final Node preprocessNode(Node node) {
        if (this.baseFile != null && this.projectRoot != null && this.shouldPreprocessImageNode(node)) {
            try {
                this.actuallyProcessImageNode(node, this.baseFile, this.projectRoot);
            }
            catch (Throwable exception) {
                String originalUrlValue = node.attr("src");
                IncrementalDOMBuilder $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IncrementalDOMBuilder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to process image node\nbasePath: " + this.baseFile + "\noriginalUrl: " + originalUrlValue, exception);
            }
        }
        return node;
    }

    private final void actuallyProcessImageNode(Node node, VirtualFile baseFile, VirtualFile projectRoot2) {
        String path;
        String string = path = node.attr("src");
        Intrinsics.checkNotNull((Object)string);
        boolean hasFileHost = StringsKt.startsWith$default((String)string, (String)"file:/", (boolean)false, (int)2, null);
        if (hasFileHost && !node.hasAttr("from-extension")) {
            return;
        }
        if (!hasFileHost) {
            Object resolved;
            path = URLDecoder.decode(path, Charset.defaultCharset());
            if (SystemInfo.isWindows) {
                path = StringUtil.replace((String)path, (String)"\\", (String)"/");
            }
            string = path;
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.startsWith$default((CharSequence)string, (char)'/', (boolean)false, (int)2, null)) {
                VirtualFile virtualFile = baseFile.findFileByRelativePath(path);
                if (virtualFile == null) {
                    return;
                }
                resolved = virtualFile;
                String string2 = VfsUtilCore.getRelativePath((VirtualFile)resolved, (VirtualFile)projectRoot2);
                if (string2 == null) {
                    string2 = path = path;
                }
            }
            if (SystemInfo.isWindows) {
                resolved = path;
                Intrinsics.checkNotNull((Object)resolved);
                if (StringsKt.startsWith$default((String)resolved, (String)"/", (boolean)false, (int)2, null)) {
                    resolved = path;
                    Intrinsics.checkNotNull((Object)resolved);
                    String string3 = resolved;
                    resolved = new char[1];
                    resolved[0] = 47;
                    path = StringsKt.trimStart((String)string3, (char[])resolved);
                }
            }
            path = FileUtil.toSystemIndependentName((String)path);
        }
        if (this.fileSchemeResourceProcessor != null) {
            String string4 = path;
            Intrinsics.checkNotNull((Object)string4);
            String processed = PreviewStaticServer.Companion.getStaticUrl(this.fileSchemeResourceProcessor, string4);
            node.attr("data-original-src", path);
            node.attr("src", processed);
        }
    }

    private final boolean shouldPreprocessImageNode(Node node) {
        return Intrinsics.areEqual((Object)node.nodeName(), (Object)"img") && !node.hasAttr(IntelliJImageGeneratingProvider.Companion.getIgnorePathProcessingAttributeName());
    }

    private final void traverse(Node node) {
        ProgressManager.checkCanceled();
        Node node2 = node;
        if (node2 instanceof TextNode) {
            this.textElement((Function0<String>)((Function0)new Function0<String>(node){
                final /* synthetic */ Node $node;
                {
                    this.$node = $node;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = ((TextNode)this.$node).getWholeText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWholeText(...)");
                    return string;
                }
            }));
        } else if (node2 instanceof DataNode) {
            this.textElement((Function0<String>)((Function0)new Function0<String>(node){
                final /* synthetic */ Node $node;
                {
                    this.$node = $node;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = ((DataNode)this.$node).getWholeData();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWholeData(...)");
                    return string;
                }
            }));
        } else if (!(node2 instanceof Comment)) {
            Node preprocessed = this.preprocessNode(node);
            this.openTag(preprocessed);
            for (Node child2 : preprocessed.childNodes()) {
                Intrinsics.checkNotNull((Object)child2);
                this.traverse(child2);
            }
            this.closeTag(preprocessed);
        }
    }
}

