/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references.paths;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.references.paths.MarkdownUnresolvedFileReferenceInspection;
import org.intellij.plugins.markdown.lang.references.paths.github.GithubWikiLocalFileReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/MarkdownUnresolvedFileReferenceInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkReference", "", "element", "Lcom/intellij/psi/PsiElement;", "isValidRange", "reference", "Lcom/intellij/psi/PsiReference;", "shouldSkip", "intellij.markdown"})
@ApiStatus.Internal
public final class MarkdownUnresolvedFileReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MarkdownElementVisitor(this, holder){
            final /* synthetic */ MarkdownUnresolvedFileReferenceInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitLinkDestination(@NotNull MarkdownLinkDestination linkDestination) {
                Intrinsics.checkNotNullParameter((Object)linkDestination, (String)"linkDestination");
                MarkdownUnresolvedFileReferenceInspection.access$checkReference(this.this$0, (PsiElement)linkDestination, this.$holder);
            }
        };
    }

    private final void checkReference(PsiElement element2, ProblemsHolder holder) {
        PsiReference[] psiReferenceArray = element2.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Sequence references = ArraysKt.asSequence((Object[])psiReferenceArray);
        Sequence fileReferences2 = SequencesKt.filter((Sequence)references, (Function1)checkReference.fileReferences.1.INSTANCE);
        Sequence unresolvedReferences2 = SequencesKt.filter((Sequence)fileReferences2, (Function1)((Function1)new Function1<PsiReference, Boolean>(this){
            final /* synthetic */ MarkdownUnresolvedFileReferenceInspection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PsiReference it) {
                Intrinsics.checkNotNull((Object)it);
                return !MarkdownUnresolvedFileReferenceInspection.access$shouldSkip(this.this$0, it) && MarkdownUnresolvedFileReferenceInspection.access$isValidRange(this.this$0, it) && it.resolve() == null;
            }
        }));
        for (PsiReference reference : unresolvedReferences2) {
            holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    private final boolean isValidRange(PsiReference reference) {
        TextRange elementRange = reference.getElement().getTextRange();
        return reference.getRangeInElement().getEndOffset() <= elementRange.getEndOffset() - elementRange.getStartOffset();
    }

    private final boolean shouldSkip(PsiReference reference) {
        return reference instanceof GithubWikiLocalFileReference;
    }

    public static final /* synthetic */ void access$checkReference(MarkdownUnresolvedFileReferenceInspection $this, PsiElement element2, ProblemsHolder holder) {
        $this.checkReference(element2, holder);
    }

    public static final /* synthetic */ boolean access$shouldSkip(MarkdownUnresolvedFileReferenceInspection $this, PsiReference reference) {
        return $this.shouldSkip(reference);
    }

    public static final /* synthetic */ boolean access$isValidRange(MarkdownUnresolvedFileReferenceInspection $this, PsiReference reference) {
        return $this.isValidRange(reference);
    }
}

