/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.TableBuildingUtilsKt;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableShiftEnterHandler$actuallyFindRow$;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableShiftEnterHandler$findElement$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0006\b\u0000\u0010\u0016\u0018\u00012\u0006\u0010\u0017\u001a\u00020\u000eH\u0082\b\u00a2\u0006\u0002\u0010\u0018J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableShiftEnterHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "actuallyExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "actuallyFindRow", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "caretOffset", "", "executeWriteAction", "", "findElement", "T", "element", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "findRow", "document", "Lcom/intellij/openapi/editor/Document;", "isEnabledForCaret", "isProbablyAtTheEndOfTableRow", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownTableShiftEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownTableShiftEnterHandler.kt\norg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableShiftEnterHandler\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n77#1:109\n78#1:111\n77#1:113\n78#1:115\n7#2,6:101\n473#3:107\n473#3:108\n473#3:110\n473#3:114\n1#4:112\n*S KotlinDebug\n*F\n+ 1 MarkdownTableShiftEnterHandler.kt\norg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableShiftEnterHandler\n*L\n83#1:109\n83#1:111\n84#1:113\n84#1:115\n55#1:101,6\n77#1:107\n78#1:108\n83#1:110\n84#1:114\n*E\n"})
public final class MarkdownTableShiftEnterHandler
extends EditorWriteActionHandler {
    @Nullable
    private final EditorActionHandler baseHandler;

    public MarkdownTableShiftEnterHandler(@Nullable EditorActionHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        EditorActionHandler editorActionHandler = this.baseHandler;
        return editorActionHandler != null ? editorActionHandler.isEnabled(editor2, caret, dataContext) : false;
    }

    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (this.actuallyExecute(editor2, caret, dataContext)) break block1;
            EditorActionHandler editorActionHandler = this.baseHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(editor2, caret, dataContext);
            }
        }
    }

    private final boolean actuallyExecute(Editor editor2, Caret caret, DataContext dataContext) {
        Caret currentCaret;
        int caretOffset;
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (!((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getInsertNewTableRowOnShiftEnter()) {
            return false;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Caret caret2 = caret;
        if (caret2 == null) {
            Caret caret3 = editor2.getCaretModel().getCurrentCaret();
            caret2 = caret3;
            Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"getCurrentCaret(...)");
        }
        if (!TableUtils.isProbablyInsideTableCell(document2, caretOffset = (currentCaret = caret2).getOffset()) && !this.isProbablyAtTheEndOfTableRow(document2, caretOffset) || editor2.getCaretModel().getCaretCount() != 1) {
            return false;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = documentManager.getPsiFile(document2);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        PsiElement psiElement = this.findRow(file, document2, caretOffset);
        if (psiElement == null) {
            return false;
        }
        PsiElement row = psiElement;
        MarkdownTable markdownTable = TableUtils.findTable(row);
        if (markdownTable == null) {
            return false;
        }
        MarkdownTable table = markdownTable;
        String string = TableBuildingUtilsKt.buildEmptyRow$default(table, null, 1, null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String emptyRow = string;
        Project project$iv = table.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(emptyRow, document2, caretOffset, currentCaret){
            final /* synthetic */ String $emptyRow$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ int $caretOffset$inlined;
            final /* synthetic */ Caret $currentCaret$inlined;
            {
                this.$emptyRow$inlined = string;
                this.$document$inlined = document;
                this.$caretOffset$inlined = n;
                this.$currentCaret$inlined = caret;
            }

            public final void run() {
                boolean bl = false;
                String content2 = "\n" + this.$emptyRow$inlined;
                int line = this.$document$inlined.getLineNumber(this.$caretOffset$inlined);
                int lineEndOffset = this.$document$inlined.getLineEndOffset(line);
                this.$document$inlined.insertString(lineEndOffset, (CharSequence)content2);
                this.$currentCaret$inlined.moveToOffset(this.$document$inlined.getLineEndOffset(line + 1));
            }
        }, name$iv, groupId$iv);
        return true;
    }

    private final PsiElement findRow(PsiFile file, Document document, int caretOffset) {
        PsiElement actual = this.actuallyFindRow(file, caretOffset);
        if (actual != null) {
            return actual;
        }
        if (caretOffset == 0 || document.getLineNumber(caretOffset) != document.getLineNumber(caretOffset - 1)) {
            return null;
        }
        return this.actuallyFindRow(file, caretOffset - 1);
    }

    private final /* synthetic */ <T> T findElement(PsiElement element2) {
        boolean $i$f$findElement = false;
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Intrinsics.needClassReification();
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findElement$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Object sibling = SequencesKt.firstOrNull((Sequence)sequence);
        Object object = sibling;
        if (object == null) {
            $this$filterIsInstance$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            $i$f$filterIsInstance = false;
            Intrinsics.needClassReification();
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findElement$$inlined$filterIsInstance$2.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            object = SequencesKt.firstOrNull((Sequence)sequence2);
        }
        return (T)object;
    }

    private final PsiElement actuallyFindRow(PsiFile file, int caretOffset) {
        PsiElement psiElement;
        Object primary;
        Object object;
        PsiElement psiElement2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElementAtOffset(...)");
        PsiElement element2 = psiElement2;
        Object this_$iv = this;
        boolean $i$f$findElement = false;
        Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)actuallyFindRow$$inlined$findElement$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Object sibling$iv = SequencesKt.firstOrNull((Sequence)sequence);
        Object object2 = sibling$iv;
        if (object2 == null) {
            $this$filterIsInstance$iv$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)actuallyFindRow$$inlined$findElement$2.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            object2 = SequencesKt.firstOrNull((Sequence)sequence2);
        }
        MarkdownTableRow markdownTableRow = (MarkdownTableRow)object2;
        if (markdownTableRow != null) {
            Object it = this_$iv = markdownTableRow;
            boolean bl = false;
            object = !TableUtils.INSTANCE.isHeaderRow((MarkdownTableRow)it) ? this_$iv : null;
        } else {
            object = null;
        }
        Object object3 = primary = object;
        if (object3 != null) {
            psiElement = (PsiElement)object3;
        } else {
            MarkdownTableShiftEnterHandler this_$iv2 = this;
            boolean $i$f$findElement2 = false;
            Sequence $this$filterIsInstance$iv$iv2 = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
            boolean $i$f$filterIsInstance2 = false;
            Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv2, (Function1)actuallyFindRow$$inlined$findElement$3.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Object sibling$iv2 = SequencesKt.firstOrNull((Sequence)sequence3);
            Object object4 = sibling$iv2;
            if (object4 == null) {
                $this$filterIsInstance$iv$iv2 = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
                $i$f$filterIsInstance2 = false;
                Sequence sequence4 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv2, (Function1)actuallyFindRow$$inlined$findElement$4.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence4, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                object4 = SequencesKt.firstOrNull((Sequence)sequence4);
            }
            psiElement = (PsiElement)object4;
        }
        return psiElement;
    }

    private final boolean isProbablyAtTheEndOfTableRow(Document document, int caretOffset) {
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text2 = charSequence;
        int line = document.getLineNumber(caretOffset);
        int lineEndOffset = document.getLineEndOffset(line);
        for (int offset = caretOffset; offset < lineEndOffset; ++offset) {
            char c = text2.charAt(offset);
            if (c == ' ' ? true : c == '\t') continue;
            return false;
        }
        return true;
    }
}

