/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.analysis;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.coverage.analysis.CoverageInfoCollector;
import com.intellij.coverage.analysis.JavaCoverageClassesAnnotator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/coverage/analysis/JavaCoverageReportEnumerator;", "", "()V", "collectSourceRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "collectSummaryInReport", "", "bundle", "Lcom/intellij/coverage/CoverageSuitesBundle;", "collector", "Lcom/intellij/coverage/analysis/CoverageInfoCollector;", "intellij.java.coverage"})
@SourceDebugExtension(value={"SMAP\nJavaCoverageReportEnumerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCoverageReportEnumerator.kt\ncom/intellij/coverage/analysis/JavaCoverageReportEnumerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,51:1\n1549#2:52\n1620#2,3:53\n1477#2:56\n1502#2,3:57\n1505#2,3:67\n1238#2,2:72\n1549#2:74\n1620#2,3:75\n1271#2,2:78\n1285#2,4:80\n1241#2:84\n372#3,7:60\n453#3:70\n403#3:71\n372#3,7:86\n372#3,7:93\n215#4:85\n216#4:100\n*S KotlinDebug\n*F\n+ 1 JavaCoverageReportEnumerator.kt\ncom/intellij/coverage/analysis/JavaCoverageReportEnumerator\n*L\n22#1:52\n22#1:53,3\n22#1:56\n22#1:57,3\n22#1:67,3\n25#1:72,2\n25#1:74\n25#1:75,3\n25#1:78,2\n25#1:80,4\n25#1:84\n22#1:60,7\n25#1:70\n25#1:71\n30#1:86,7\n31#1:93,7\n26#1:85\n26#1:100\n*E\n"})
public final class JavaCoverageReportEnumerator {
    @NotNull
    public static final JavaCoverageReportEnumerator INSTANCE = new JavaCoverageReportEnumerator();

    private JavaCoverageReportEnumerator() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void collectSummaryInReport(@NotNull CoverageSuitesBundle bundle, @NotNull Project project, @NotNull CoverageInfoCollector collector) {
        void $this$forEach$iv;
        Object it$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Object $this$mapValues$iv;
        Object key$iv$iv;
        Map.Entry vmName;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        ProjectData projectData = bundle.getCoverageData();
        if (projectData == null) {
            return;
        }
        ProjectData projectData2 = projectData;
        PackageAnnotator packageAnnotator = new PackageAnnotator(bundle, project, projectData2);
        HashMap flattenPackages = new HashMap();
        HashMap flattenDirectories = new HashMap();
        Collection collection = projectData2.getClassesCollection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getClassesCollection(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassData classData = (ClassData)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            String fqn2 = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)AnalysisUtils.fqnToInternalName(fqn2), (String)"fqnToInternalName(...)");
            key$iv$iv = AnalysisUtils.getSourceToplevelFQName((String)((Object)vmName));
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateWith$iv;
            String p0;
            Object object4;
            void $this$mapTo$iv$iv2;
            vmName = (Map.Entry)element$iv$iv$iv;
            key$iv$iv = destination$iv$iv;
            boolean bl = false;
            Map.Entry $i$f$getOrPut = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = key$iv$iv;
            boolean bl3 = false;
            List names = (List)$i$f$getOrPut.getValue();
            Iterable $this$map$iv2 = names;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                String string = (String)item$iv$iv;
                object4 = destination$iv$iv2;
                boolean bl4 = false;
                object4.add(StringUtil.getShortName((String)p0));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                p0 = (String)element$iv$iv;
                Object t = element$iv$iv;
                object4 = result$iv;
                boolean bl5 = false;
                Object v = null;
                object4.put(t, v);
            }
            Map map = result$iv;
            object.put(k, map);
        }
        $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Object object5;
            Object object6;
            PackageAnnotator.PackageCoverageInfo answer$iv;
            Map $this$getOrPut$iv;
            String packageVMName;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            String topLevelName = (String)entry.getKey();
            Map simpleNames = (Map)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)AnalysisUtils.fqnToInternalName(StringUtil.getPackageName((String)topLevelName)), (String)"fqnToInternalName(...)");
            PackageAnnotator.Result result = packageAnnotator.visitFiles(topLevelName, simpleNames, packageVMName);
            if (result == null) continue;
            it$iv$iv = result;
            Intrinsics.checkNotNull((Object)it$iv$iv);
            PackageAnnotator.Result result2 = it$iv$iv;
            collector.addClass(topLevelName, result2.info);
            it$iv$iv = flattenPackages;
            String string = AnalysisUtils.internalNameToFqn(packageVMName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"internalNameToFqn(...)");
            String key$iv = string;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl6 = false;
                answer$iv = new PackageAnnotator.PackageCoverageInfo();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object6 = answer$iv;
            } else {
                object6 = value$iv;
            }
            ((PackageAnnotator.PackageCoverageInfo)object6).append(result2.info);
            $this$getOrPut$iv = flattenDirectories;
            VirtualFile virtualFile = result2.directory;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"directory");
            key$iv = virtualFile;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl7 = false;
                answer$iv = new PackageAnnotator.PackageCoverageInfo();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object5 = answer$iv;
            } else {
                object5 = value$iv;
            }
            ((PackageAnnotator.PackageCoverageInfo)object5).append(result2.info);
        }
        JavaCoverageClassesAnnotator.annotatePackages(flattenPackages, collector);
        JavaCoverageClassesAnnotator.annotateDirectories(flattenDirectories, collector, INSTANCE.collectSourceRoots(project));
    }

    private final Set<VirtualFile> collectSourceRoots(Project project) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (Module module : ModuleManager.Companion.getInstance(project).getModules()) {
            ContentEntry[] contentEntries;
            Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)module).getContentEntries(), (String)"getContentEntries(...)");
            for (ContentEntry contentEntry : contentEntries) {
                SourceFolder[] sourceFolderArray;
                Intrinsics.checkNotNullExpressionValue((Object)contentEntry.getSourceFolders(), (String)"getSourceFolders(...)");
                for (SourceFolder folder : sourceFolderArray) {
                    VirtualFile file;
                    if (folder.getFile() == null) continue;
                    result.add(file);
                }
            }
        }
        return result;
    }
}

