/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.util.IntCollectionUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a$\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000b*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a$\u0010\u0016\u001a\u0004\u0018\u00010\t*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\u0016\u001a\u0004\u0018\u00010\t*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0015\u00a8\u0006\u001b"}, d2={"containsAll", "", "Lcom/intellij/vcs/log/data/DataPack;", "commits", "", "Lcom/intellij/vcs/log/CommitId;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "exclusiveCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "ref", "Lcom/intellij/vcs/log/VcsRef;", "refsModel", "Lcom/intellij/vcs/log/data/RefsModel;", "findBranch", "name", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isBranchHead", "commitId", "", "subgraphDifference", "withRef", "withoutRef", "withRefIndex", "withoutRefIndex", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nDataPackUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPackUtil.kt\ncom/intellij/vcs/log/util/DataPackUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1549#2:66\n1620#2,3:67\n1726#2,3:70\n1747#2,3:73\n*S KotlinDebug\n*F\n+ 1 DataPackUtil.kt\ncom/intellij/vcs/log/util/DataPackUtilKt\n*L\n44#1:66\n44#1:67,3\n50#1:70,3\n65#1:73,3\n*E\n"})
public final class DataPackUtilKt {
    @Nullable
    public static final VcsRef findBranch(@NotNull RefsModel $this$findBranch, @NotNull String name, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)$this$findBranch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return VcsLogUtil.findBranch($this$findBranch, root, name);
    }

    @Nullable
    public static final VcsRef findBranch(@NotNull DataPack $this$findBranch, @NotNull String name, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)$this$findBranch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        RefsModel refsModel = $this$findBranch.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
        return DataPackUtilKt.findBranch(refsModel, name, root);
    }

    @Nullable
    public static final IntSet subgraphDifference(@NotNull DataPack $this$subgraphDifference, @NotNull VcsRef withRef, @NotNull VcsRef withoutRef, @NotNull VcsLogStorage storage) {
        Intrinsics.checkNotNullParameter((Object)$this$subgraphDifference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)withRef, (String)"withRef");
        Intrinsics.checkNotNullParameter((Object)withoutRef, (String)"withoutRef");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (!Intrinsics.areEqual((Object)withoutRef.getRoot(), (Object)withRef.getRoot())) {
            return null;
        }
        Hash hash = withRef.getCommitHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
        VirtualFile virtualFile = withRef.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        int withRefIndex = storage.getCommitIndex(hash, virtualFile);
        Hash hash2 = withoutRef.getCommitHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"getCommitHash(...)");
        VirtualFile virtualFile2 = withoutRef.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
        int withoutRefIndex = storage.getCommitIndex(hash2, virtualFile2);
        return DataPackUtilKt.subgraphDifference($this$subgraphDifference, withRefIndex, withoutRefIndex);
    }

    @Nullable
    public static final IntSet subgraphDifference(@NotNull DataPack $this$subgraphDifference, int withRefIndex, int withoutRefIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$subgraphDifference, (String)"<this>");
        if (withRefIndex == withoutRefIndex) {
            return (IntSet)new IntOpenHashSet();
        }
        PermanentGraph<Integer> permanentGraph = $this$subgraphDifference.getPermanentGraph();
        PermanentGraphInfo permanentGraphInfo = permanentGraph instanceof PermanentGraphInfo ? (PermanentGraphInfo)permanentGraph : null;
        if (permanentGraphInfo == null) {
            return null;
        }
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        int withRefNode = permanentGraphInfo2.getPermanentCommitsInfo().getNodeId(withRefIndex);
        int withoutRefNode = permanentGraphInfo2.getPermanentCommitsInfo().getNodeId(withoutRefIndex);
        if (withRefNode < 0 || withoutRefNode < 0) {
            return null;
        }
        LinearGraph linearGraph = permanentGraphInfo2.getLinearGraph();
        Intrinsics.checkNotNullExpressionValue((Object)linearGraph, (String)"getLinearGraph(...)");
        IntSet withRefNodeIds = GraphUtilKt.subgraphDifference(linearGraph, withRefNode, withoutRefNode);
        return IntCollectionUtil.map2IntSet((Collection)withRefNodeIds, arg_0 -> DataPackUtilKt.subgraphDifference$lambda$0((Function1)new Function1<Integer, Integer>((PermanentGraphInfo<Integer>)permanentGraphInfo2){
            final /* synthetic */ PermanentGraphInfo<Integer> $permanentGraphInfo;
            {
                this.$permanentGraphInfo = $permanentGraphInfo;
                super(1);
            }

            @NotNull
            public final Integer invoke(Integer it) {
                PermanentCommitsInfo<Integer> permanentCommitsInfo = this.$permanentGraphInfo.getPermanentCommitsInfo();
                Intrinsics.checkNotNull((Object)it);
                Integer n = permanentCommitsInfo.getCommitId(it);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getCommitId(...)");
                return n;
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsAll(@NotNull DataPack $this$containsAll, @NotNull Collection<CommitId> commits2, @NotNull VcsLogStorage storage) {
        boolean bl;
        PermanentGraph<Integer> $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$containsAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Iterable $this$map$iv = commits2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CommitId commitId2 = (CommitId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Hash hash = it.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
            VirtualFile virtualFile = it.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            collection.add(storage.getCommitIndex(hash, virtualFile));
        }
        List commitIds = (List)destination$iv$iv;
        $this$mapTo$iv$iv = $this$containsAll.getPermanentGraph();
        if (!($this$mapTo$iv$iv instanceof PermanentGraphInfo)) return false;
        PermanentGraphInfo permanentGraphInfo = (PermanentGraphInfo)$this$mapTo$iv$iv;
        if (permanentGraphInfo == null) {
            return false;
        }
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        if (permanentGraphInfo2.getPermanentCommitsInfo() instanceof PermanentCommitsInfoImpl) {
            PermanentCommitsInfo permanentCommitsInfo = permanentGraphInfo2.getPermanentCommitsInfo();
            Intrinsics.checkNotNull(permanentCommitsInfo, (String)"null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl<kotlin.Int>");
            return ((PermanentCommitsInfoImpl)permanentCommitsInfo).containsAll(commitIds);
        }
        Set<Integer> nodeIds = permanentGraphInfo2.getPermanentCommitsInfo().convertToNodeIds(commitIds);
        if (nodeIds.size() != commits2.size()) return false;
        Iterable $this$all$iv = nodeIds;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            int it = ((Number)element$iv).intValue();
            boolean bl3 = false;
            if (it < 0) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @Nullable
    public static final IntSet exclusiveCommits(@NotNull DataPack $this$exclusiveCommits, @NotNull VcsRef ref, @NotNull RefsModel refsModel, @NotNull VcsLogStorage storage) {
        Intrinsics.checkNotNullParameter((Object)$this$exclusiveCommits, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)refsModel, (String)"refsModel");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Hash hash = ref.getCommitHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
        VirtualFile virtualFile = ref.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        int refIndex = storage.getCommitIndex(hash, virtualFile);
        PermanentGraph<Integer> permanentGraph = $this$exclusiveCommits.getPermanentGraph();
        PermanentGraphInfo permanentGraphInfo = permanentGraph instanceof PermanentGraphInfo ? (PermanentGraphInfo)permanentGraph : null;
        if (permanentGraphInfo == null) {
            return null;
        }
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        int refNode = permanentGraphInfo2.getPermanentCommitsInfo().getNodeId(refIndex);
        if (refNode < 0) {
            return null;
        }
        LinearGraph linearGraph = permanentGraphInfo2.getLinearGraph();
        Intrinsics.checkNotNullExpressionValue((Object)linearGraph, (String)"getLinearGraph(...)");
        IntSet exclusiveNodes2 = GraphUtilKt.exclusiveNodes(linearGraph, refNode, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(refsModel, (PermanentGraphInfo<Integer>)permanentGraphInfo2){
            final /* synthetic */ RefsModel $refsModel;
            final /* synthetic */ PermanentGraphInfo<Integer> $permanentGraphInfo;
            {
                this.$refsModel = $refsModel;
                this.$permanentGraphInfo = $permanentGraphInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(int node) {
                Integer n = this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(node);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getCommitId(...)");
                return DataPackUtilKt.access$isBranchHead(this.$refsModel, ((Number)n).intValue());
            }
        }));
        return IntCollectionUtil.map2IntSet((Collection)exclusiveNodes2, arg_0 -> DataPackUtilKt.exclusiveCommits$lambda$3((Function1)new Function1<Integer, Integer>((PermanentGraphInfo<Integer>)permanentGraphInfo2){
            final /* synthetic */ PermanentGraphInfo<Integer> $permanentGraphInfo;
            {
                this.$permanentGraphInfo = $permanentGraphInfo;
                super(1);
            }

            @NotNull
            public final Integer invoke(Integer it) {
                PermanentCommitsInfo<Integer> permanentCommitsInfo = this.$permanentGraphInfo.getPermanentCommitsInfo();
                Intrinsics.checkNotNull((Object)it);
                Integer n = permanentCommitsInfo.getCommitId(it);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getCommitId(...)");
                return n;
            }
        }, arg_0));
    }

    private static final boolean isBranchHead(RefsModel $this$isBranchHead, int commitId2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$isBranchHead.refsToCommit(commitId2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VcsRef it = (VcsRef)element$iv;
                    boolean bl2 = false;
                    if (!it.getType().isBranch()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final int subgraphDifference$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int exclusiveCommits$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    public static final /* synthetic */ boolean access$isBranchHead(RefsModel $receiver, int commitId2) {
        return DataPackUtilKt.isBranchHead($receiver, commitId2);
    }
}

