/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.table.CommitSelectionImpl;
import com.intellij.vcs.log.ui.table.VcsLogCommitListModel;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphTableModel
extends AbstractTableModel
implements VcsLogCommitListModel {
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    private static final Logger LOG = Logger.getInstance(GraphTableModel.class);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final Runnable myRequestMore;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private VisiblePack myVisiblePack;

    public GraphTableModel(@NotNull VcsLogData logData, @NotNull Runnable requestMore, @NotNull VcsLogUiProperties properties) {
        if (logData == null) {
            GraphTableModel.$$$reportNull$$$0(0);
        }
        if (requestMore == null) {
            GraphTableModel.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            GraphTableModel.$$$reportNull$$$0(2);
        }
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myLogData = logData;
        this.myRequestMore = requestMore;
        this.myProperties = properties;
    }

    @Override
    public int getRowCount() {
        return this.myVisiblePack.getVisibleGraph().getVisibleCommitCount();
    }

    @Override
    public int getColumnCount() {
        return VcsLogColumnManager.getInstance().getModelColumnsCount();
    }

    @Override
    public String getColumnName(int column) {
        return GraphTableModel.getColumn(column).getLocalizedName();
    }

    @Override
    @NotNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.getValueAt(rowIndex, GraphTableModel.getColumn(columnIndex));
        if (obj == null) {
            GraphTableModel.$$$reportNull$$$0(3);
        }
        return obj;
    }

    @NotNull
    public <T> T getValueAt(int rowIndex, @NotNull VcsLogColumn<T> column) {
        Object object;
        if (column == null) {
            GraphTableModel.$$$reportNull$$$0(4);
        }
        if (rowIndex >= this.getRowCount() - 1 && VcsLogUtil.canRequestMore(this.myVisiblePack)) {
            this.myRequestMore.run();
        }
        try {
            object = ObjectUtils.chooseNotNull(column.getValue(this, rowIndex), column.getStubValue(this));
        }
        catch (ProcessCanceledException ignore) {
            T t = column.getStubValue(this);
            if (t == null) {
                GraphTableModel.$$$reportNull$$$0(6);
            }
            return t;
        }
        catch (Throwable t) {
            LOG.error("Failed to get information for the log table", t);
            T t2 = column.getStubValue(this);
            if (t2 == null) {
                GraphTableModel.$$$reportNull$$$0(7);
            }
            return t2;
        }
        if (object == null) {
            GraphTableModel.$$$reportNull$$$0(5);
        }
        return (T)object;
    }

    @NotNull
    private static VcsLogColumn<?> getColumn(int modelIndex) {
        VcsLogColumn<?> vcsLogColumn = VcsLogColumnManager.getInstance().getColumn(modelIndex);
        if (vcsLogColumn == null) {
            GraphTableModel.$$$reportNull$$$0(8);
        }
        return vcsLogColumn;
    }

    void setVisiblePack(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            GraphTableModel.$$$reportNull$$$0(9);
        }
        this.myVisiblePack = visiblePack;
        this.fireTableDataChanged();
    }

    @NotNull
    public VisiblePack getVisiblePack() {
        VisiblePack visiblePack = this.myVisiblePack;
        if (visiblePack == null) {
            GraphTableModel.$$$reportNull$$$0(10);
        }
        return visiblePack;
    }

    @NotNull
    public VcsLogData getLogData() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            GraphTableModel.$$$reportNull$$$0(11);
        }
        return vcsLogData;
    }

    @Override
    @NotNull
    public VcsLogDataProvider getDataProvider() {
        VcsLogData vcsLogData = this.getLogData();
        if (vcsLogData == null) {
            GraphTableModel.$$$reportNull$$$0(12);
        }
        return vcsLogData;
    }

    @NotNull
    public VcsLogUiProperties getProperties() {
        VcsLogUiProperties vcsLogUiProperties = this.myProperties;
        if (vcsLogUiProperties == null) {
            GraphTableModel.$$$reportNull$$$0(13);
        }
        return vcsLogUiProperties;
    }

    @Override
    public int getId(int row2) {
        return (Integer)this.myVisiblePack.getVisibleGraph().getRowInfo(row2).getCommit();
    }

    @Nullable
    public VirtualFile getRootAtRow(int row2) {
        return this.myVisiblePack.getRoot(row2);
    }

    @NotNull
    public List<VcsRef> getRefsAtRow(int row2) {
        VcsLogRefs vcsLogRefs = this.myVisiblePack.getRefs();
        if (vcsLogRefs instanceof RefsModel) {
            RefsModel refsModel = (RefsModel)vcsLogRefs;
            VirtualFile root = this.myVisiblePack.getRoot(row2);
            int id = this.getId(row2);
            if (root != null) {
                List<VcsRef> list = refsModel.refsToCommit(root, id);
                if (list == null) {
                    GraphTableModel.$$$reportNull$$$0(14);
                }
                return list;
            }
            List<VcsRef> list = refsModel.refsToCommit(id);
            if (list == null) {
                GraphTableModel.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<VcsRef> list = Collections.emptyList();
        if (list == null) {
            GraphTableModel.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<VcsRef> getBranchesAtRow(int row2) {
        List list = ContainerUtil.filter(this.getRefsAtRow(row2), ref -> ref.getType().isBranch());
        if (list == null) {
            GraphTableModel.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Deprecated
    @NotNull
    public VcsFullCommitDetails getFullDetails(int row2) {
        VcsFullCommitDetails vcsFullCommitDetails = this.myLogData.getCommitDetailsGetter().getCachedDataOrPlaceholder(this.getId(row2));
        if (vcsFullCommitDetails == null) {
            GraphTableModel.$$$reportNull$$$0(18);
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public VcsCommitMetadata getCommitMetadata(int row2) {
        VcsCommitMetadata vcsCommitMetadata = this.getCommitMetadata(row2, false);
        if (vcsCommitMetadata == null) {
            GraphTableModel.$$$reportNull$$$0(19);
        }
        return vcsCommitMetadata;
    }

    @NotNull
    public VcsCommitMetadata getCommitMetadata(int row2, boolean load) {
        List commitsToLoad = load ? this.getCommitsToLoad(row2) : ContainerUtil.emptyList();
        VcsCommitMetadata vcsCommitMetadata = this.myLogData.getMiniDetailsGetter().getCommitData(this.getId(row2), commitsToLoad);
        if (vcsCommitMetadata == null) {
            GraphTableModel.$$$reportNull$$$0(20);
        }
        return vcsCommitMetadata;
    }

    @Nullable
    public CommitId getCommitId(int row2) {
        VcsCommitMetadata metadata = this.getCommitMetadata(row2);
        if (metadata instanceof LoadingDetails) {
            return null;
        }
        return new CommitId((Hash)metadata.getId(), metadata.getRoot());
    }

    @NotNull
    public VcsLogCommitSelection createSelection(int[] rows) {
        return new CommitSelectionImpl(this.myLogData, this.myVisiblePack.getVisibleGraph(), rows);
    }

    @NotNull
    private Iterable<Integer> getCommitsToLoad(final int row2) {
        final int maxRows = this.getRowCount();
        Iterable<Integer> iterable = () -> new Iterator<Integer>(){
            private int myRowIndex;
            {
                this.myRowIndex = Math.max(0, row2 - 20);
            }

            @Override
            public boolean hasNext() {
                return this.myRowIndex < row2 + 40 && this.myRowIndex < maxRows;
            }

            @Override
            public Integer next() {
                int nextRow = this.myRowIndex++;
                return GraphTableModel.this.getId(nextRow);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements is not supported.");
            }
        };
        if (iterable == null) {
            GraphTableModel.$$$reportNull$$$0(21);
        }
        return iterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/GraphTableModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/GraphTableModel";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAt";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisiblePack";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefsAtRow";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesAtRow";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullDetails";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMetadata";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsToLoad";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValueAt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

