/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class PropertiesFileType
extends LanguageFileType {
    public static final LanguageFileType INSTANCE = new PropertiesFileType();
    public static final String DEFAULT_EXTENSION = "properties";
    public static final String DOT_DEFAULT_EXTENSION = ".properties";
    public static final Charset PROPERTIES_DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;

    private PropertiesFileType() {
        super((Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return "Properties";
    }

    @NotNull
    public String getDescription() {
        String string = PropertiesBundle.message("filetype.properties.description", new Object[0]);
        if (string == null) {
            PropertiesFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.PropertiesFileType);
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        Charset charset;
        if (file == null) {
            PropertiesFileType.$$$reportNull$$$0(1);
        }
        if (content == null) {
            PropertiesFileType.$$$reportNull$$$0(2);
        }
        if ((charset = EncodingRegistry.getInstance().getDefaultCharsetForPropertiesFiles(file)) == null) {
            charset = PROPERTIES_DEFAULT_CHARSET;
        }
        if (EncodingRegistry.getInstance().isNative2Ascii(file)) {
            charset = Native2AsciiCharset.wrap((Charset)charset);
        }
        return charset.name();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/PropertiesFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/PropertiesFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

