/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.codeInsight.intention.impl.QuickEditHandlerUtils;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.ReadActionCachedValue;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImplKt;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0016H\u0016J\"\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u001f0\u00162\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010#\u001a\u00020\nJ\b\u0010$\u001a\u00020\u0012H\u0016J\u0006\u0010%\u001a\u00020\u000eJ\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020\u000eH\u0016J\u0006\u0010(\u001a\u00020\nR\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00160\u00168DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/yaml/psi/impl/YAMLBlockScalarImpl;", "Lorg/jetbrains/yaml/psi/impl/YAMLScalarImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "contentType", "Lcom/intellij/psi/tree/IElementType;", "getContentType", "()Lcom/intellij/psi/tree/IElementType;", "explicitIndent", "", "getExplicitIndent", "()I", "includeFirstLineInContent", "", "getIncludeFirstLineInContent", "()Z", "indentString", "", "getIndentString", "()Ljava/lang/String;", "linesNodes", "", "getLinesNodes", "()Ljava/util/List;", "textCache", "Lcom/intellij/psi/util/ReadActionCachedValue;", "validCache", "getContentRanges", "Lcom/intellij/openapi/util/TextRange;", "getEncodeReplacements", "Lcom/intellij/openapi/util/Pair;", "input", "", "getNthContentTypeChild", "nth", "getText", "hasExplicitIndent", "isMultiline", "isValid", "locateIndent", "intellij.yaml.editing"})
@SourceDebugExtension(value={"SMAP\nYAMLBlockScalarImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLBlockScalarImpl.kt\norg/jetbrains/yaml/psi/impl/YAMLBlockScalarImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1284#2,3:169\n1#3:172\n*S KotlinDebug\n*F\n+ 1 YAMLBlockScalarImpl.kt\norg/jetbrains/yaml/psi/impl/YAMLBlockScalarImpl\n*L\n35#1:169,3\n*E\n"})
public abstract class YAMLBlockScalarImpl
extends YAMLScalarImpl {
    @NotNull
    private final ReadActionCachedValue<String> textCache;
    @NotNull
    private final ReadActionCachedValue<Boolean> validCache;

    public YAMLBlockScalarImpl(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
        this.textCache = new ReadActionCachedValue((Function0)new Function0<String>(this){
            final /* synthetic */ YAMLBlockScalarImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = YAMLBlockScalarImpl.access$getText$s2103216691(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getText$s2103216691(...)");
                return string;
            }
        });
        this.validCache = new ReadActionCachedValue((Function0)new Function0<Boolean>(this){
            final /* synthetic */ YAMLBlockScalarImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return YAMLBlockScalarImpl.access$isValid$s2103216691(this.this$0);
            }
        });
    }

    @NotNull
    protected abstract IElementType getContentType();

    @Override
    public boolean isMultiline() {
        return true;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this), () -> YAMLBlockScalarImpl.getContentRanges$lambda$3(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public String getText() {
        return (String)this.textCache.getCachedOrEvaluate();
    }

    public boolean isValid() {
        return (Boolean)this.validCache.getCachedOrEvaluate();
    }

    protected boolean getIncludeFirstLineInContent() {
        return false;
    }

    public final boolean hasExplicitIndent() {
        return this.getExplicitIndent() != -1;
    }

    @Nullable
    public final ASTNode getNthContentTypeChild(int nth) {
        int number = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != this.getContentType()) continue;
            if (number == nth) {
                return child;
            }
            ++number;
        }
        return null;
    }

    public final int locateIndent() {
        Integer n = QuickEditHandlerUtils.reuseFragmentEditorIndent((PsiLanguageInjectionHost)this, (Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ YAMLBlockScalarImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                ASTNode lineIndentElement2;
                int indent = YAMLBlockScalarImpl.access$getExplicitIndent(this.this$0);
                if (indent != -1) {
                    return indent;
                }
                ASTNode firstLine = this.this$0.getNthContentTypeChild(this.this$0.getIncludeFirstLineInContent() ? 0 : 1);
                if (firstLine != null) {
                    return YAMLUtil.getIndentInThisLine(firstLine.getPsi());
                }
                List line = (List)CollectionsKt.getOrNull(this.this$0.getLinesNodes(), (int)1);
                if (line != null && (lineIndentElement2 = (ASTNode)ContainerUtil.find((Iterable)line, arg_0 -> locateIndent.1.invoke$lambda$0(locateIndent.lineIndentElement.1.INSTANCE, arg_0))) != null) {
                    return lineIndentElement2.getTextLength();
                }
                return 0;
            }

            private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }));
        return n != null ? n : -1;
    }

    @NotNull
    public final String getIndentString() {
        String string = StringUtil.repeatSymbol((char)' ', (int)this.locateIndent());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeatSymbol(...)");
        return string;
    }

    @Override
    @NotNull
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String indentString = this.getIndentString();
        return SequencesKt.toList((Sequence)SequencesKt.zipWithNext((Sequence)TextRangeUtils.splitLineRanges((CharSequence)input), (Function2)((Function2)new Function2<TextRange, TextRange, Pair<TextRange, String>>(indentString){
            final /* synthetic */ String $indentString;
            {
                this.$indentString = $indentString;
                super(2);
            }

            @NotNull
            public final Pair<TextRange, String> invoke(@NotNull TextRange a, @NotNull TextRange b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return Pair.create((Object)TextRange.create((int)a.getEndOffset(), (int)b.getStartOffset()), (Object)this.$indentString);
            }
        })));
    }

    @NotNull
    protected final List<List<ASTNode>> getLinesNodes() {
        List result = (List)new SmartList();
        List currentLine = (List)new SmartList();
        for (ASTNode child = this.getFirstContentNode(); child != null; child = child.getTreeNext()) {
            currentLine.add(child);
            if (!YAMLBlockScalarImplKt.isEol(child)) continue;
            result.add(currentLine);
            currentLine = (List)new SmartList();
        }
        if (!currentLine.isEmpty()) {
            result.add(currentLine);
        }
        return result;
    }

    private final int getExplicitIndent() {
        if (this.getIncludeFirstLineInContent()) {
            return -1;
        }
        ASTNode aSTNode = this.getNthContentTypeChild(0);
        if (aSTNode == null) {
            return -1;
        }
        ASTNode headerNode = aSTNode;
        String string = headerNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String header = string;
        int n = header.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isDigit(header.charAt(i))) continue;
            int k = i + 1;
            if (k < header.length() && Character.isDigit(header.charAt(k))) {
                return -1;
            }
            String string2 = header.substring(i, k);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            int res = Integer.parseInt(string2);
            return res == 0 ? -1 : res;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result getContentRanges$lambda$3(YAMLBlockScalarImpl this$0) {
        List list;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int myStart = this$0.getTextRange().getStartOffset();
        int indent = this$0.locateIndent();
        Object[] objectArray = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this$0.getLinesNodes()), (Function1)((Function1)new Function1<List<? extends ASTNode>, TextRange>(myStart, indent){
            final /* synthetic */ int $myStart;
            final /* synthetic */ int $indent;
            {
                this.$myStart = $myStart;
                this.$indent = $indent;
                super(1);
            }

            @Nullable
            public final TextRange invoke(@NotNull List<? extends ASTNode> line) {
                Intrinsics.checkNotNullParameter(line, (String)"line");
                ASTNode first = (ASTNode)CollectionsKt.first(line);
                int start = first.getTextRange().getStartOffset() - this.$myStart + (Intrinsics.areEqual((Object)first.getElementType(), (Object)((Object)YAMLTokenTypes.INDENT)) ? Math.min(first.getTextLength(), this.$indent) : 0);
                int end = ((ASTNode)CollectionsKt.last(line)).getTextRange().getEndOffset() - this.$myStart;
                return start <= end ? TextRange.create((int)start, (int)end) : null;
            }
        }));
        SmartList initial$iv = new SmartList();
        boolean $i$f$fold = false;
        SmartList accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void range;
            SmartList smartList;
            TextRange textRange = (TextRange)element$iv;
            SmartList list2 = accumulator$iv;
            boolean bl = false;
            SmartList $this$getContentRanges_u24lambda_u243_u24lambda_u241_u24lambda_u240 = smartList = list2;
            boolean bl2 = false;
            if ($this$getContentRanges_u24lambda_u243_u24lambda_u241_u24lambda_u240.size() > 1 && ((TextRange)CollectionsKt.last((List)((List)$this$getContentRanges_u24lambda_u243_u24lambda_u241_u24lambda_u240))).getEndOffset() == range.getStartOffset()) {
                $this$getContentRanges_u24lambda_u243_u24lambda_u241_u24lambda_u240.set(CollectionsKt.getLastIndex((List)((List)$this$getContentRanges_u24lambda_u243_u24lambda_u241_u24lambda_u240)), (Object)new TextRange(((TextRange)CollectionsKt.last((List)((List)$this$getContentRanges_u24lambda_u243_u24lambda_u241_u24lambda_u240))).getStartOffset(), range.getEndOffset()));
            } else {
                $this$getContentRanges_u24lambda_u243_u24lambda_u241_u24lambda_u240.add((Object)range);
            }
            accumulator$iv = smartList;
        }
        SmartList contentRanges2 = accumulator$iv;
        if (!this$0.getIncludeFirstLineInContent() && contentRanges2.size() == 1) {
            TextRange it = (TextRange)CollectionsKt.single((List)((List)contentRanges2));
            boolean bl = false;
            list = CollectionsKt.listOf((Object)TextRange.create((int)it.getEndOffset(), (int)it.getEndOffset()));
        } else {
            list = contentRanges2.isEmpty() ? CollectionsKt.emptyList() : (this$0.getIncludeFirstLineInContent() ? (List)contentRanges2 : CollectionsKt.drop((Iterable)((Iterable)contentRanges2), (int)1));
        }
        objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)list, (Object[])objectArray);
    }

    public static final /* synthetic */ int access$getExplicitIndent(YAMLBlockScalarImpl $this) {
        return $this.getExplicitIndent();
    }

    public static final /* synthetic */ String access$getText$s2103216691(YAMLBlockScalarImpl $this) {
        return super.getText();
    }

    public static final /* synthetic */ boolean access$isValid$s2103216691(YAMLBlockScalarImpl $this) {
        return super.isValid();
    }
}

