/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.DuplicatedPropertiesInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentPropertiesEndsInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.MissingTranslationsInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.PropertiesKeysConsistencyInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.PropertiesPlaceholdersInspectionProvider;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class InconsistentResourceBundleInspection
extends GlobalSimpleInspectionTool {
    private static final Key<Set<ResourceBundle>> VISITED_BUNDLES_KEY = Key.create((String)"VISITED_BUNDLES_KEY");
    private final NotNullLazyValue<InconsistentResourceBundleInspectionProvider[]> myInspectionProviders = NotNullLazyValue.lazy(() -> new InconsistentResourceBundleInspectionProvider[]{new PropertiesKeysConsistencyInspectionProvider(), new DuplicatedPropertiesInspectionProvider(), new MissingTranslationsInspectionProvider(), new PropertiesPlaceholdersInspectionProvider(), new InconsistentPropertiesEndsInspectionProvider()});
    private final Map<String, Boolean> mySettings = new LinkedHashMap<String, Boolean>();

    @NotNull
    public String getShortName() {
        return "InconsistentResourceBundle";
    }

    @NotNull
    public OptPane getOptionsPane() {
        return new OptPane(ContainerUtil.map((Object[])((InconsistentResourceBundleInspectionProvider[])this.myInspectionProviders.getValue()), provider -> OptPane.checkbox((String)provider.getName(), (String)provider.getPresentableName(), (OptRegularComponent[])new OptRegularComponent[0])));
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = OptionController.of(this::isProviderEnabled, (bindId, value) -> {
            boolean boolValue = (Boolean)value;
            if (boolValue) {
                this.mySettings.remove(bindId);
            } else {
                this.mySettings.put((String)bindId, false);
            }
        });
        if (optionController == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(0);
        }
        return optionController;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(1);
        }
        for (Map.Entry<String, Boolean> e : this.mySettings.entrySet()) {
            JDOMExternalizerUtil.writeField((Element)node, (String)e.getKey(), (String)Boolean.toString(e.getValue()));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(2);
        }
        this.mySettings.clear();
        for (Element e : node.getChildren()) {
            String name = e.getAttributeValue("name");
            boolean value = Boolean.parseBoolean(e.getAttributeValue("value"));
            this.mySettings.put(name, value);
        }
    }

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(4);
        }
        if (problemDescriptionsProcessor == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(5);
        }
        globalContext.putUserData(VISITED_BUNDLES_KEY, (Object)ConcurrentCollectionFactory.createConcurrentSet());
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (file == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(7);
        }
        if (problemsHolder == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(8);
        }
        if (globalContext == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(9);
        }
        if (problemDescriptionsProcessor == null) {
            InconsistentResourceBundleInspection.$$$reportNull$$$0(10);
        }
        Set visitedBundles = (Set)globalContext.getUserData(VISITED_BUNDLES_KEY);
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        assert (visitedBundles != null);
        if (!visitedBundles.add(resourceBundle)) {
            return;
        }
        List files = resourceBundle.getPropertiesFiles();
        if (files.size() < 2) {
            return;
        }
        BidirectionalMap parents = new BidirectionalMap();
        for (PropertiesFile f : files) {
            PropertiesFile parent = PropertiesUtil.getParent((PropertiesFile)f, (Collection)files);
            if (parent == null) continue;
            parents.put((Object)f, (Object)parent);
        }
        Map propertiesFilesNamesMaps = FactoryMap.create(key -> key.getNamesMap());
        HashMap<PropertiesFile, Set<String>> keysUpToParent = new HashMap<PropertiesFile, Set<String>>();
        for (PropertiesFile f : files) {
            HashSet keys = new HashSet(((Map)propertiesFilesNamesMaps.get(f)).keySet());
            PropertiesFile parent = (PropertiesFile)parents.get((Object)f);
            while (parent != null) {
                keys.addAll(((Map)propertiesFilesNamesMaps.get(parent)).keySet());
                parent = (PropertiesFile)parents.get((Object)parent);
            }
            keysUpToParent.put(f, keys);
        }
        for (InconsistentResourceBundleInspectionProvider provider : (InconsistentResourceBundleInspectionProvider[])this.myInspectionProviders.getValue()) {
            if (!this.isProviderEnabled(provider.getName())) continue;
            provider.check((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, keysUpToParent, propertiesFilesNamesMaps, manager, globalContext.getRefManager(), problemDescriptionsProcessor);
        }
    }

    private boolean isProviderEnabled(String providerName) {
        return this.mySettings.getOrDefault(providerName, true);
    }

    @SafeVarargs
    @TestOnly
    public final void enableProviders(Class<? extends InconsistentResourceBundleInspectionProvider> ... providerClasses) {
        HashSet providersToEnable = ContainerUtil.newHashSet((Object[])providerClasses);
        for (InconsistentResourceBundleInspectionProvider inspectionProvider : (InconsistentResourceBundleInspectionProvider[])this.myInspectionProviders.getValue()) {
            if (!providersToEnable.contains(inspectionProvider.getClass())) continue;
            this.mySettings.put(inspectionProvider.getName(), true);
        }
    }

    @TestOnly
    public void disableAllProviders() {
        for (InconsistentResourceBundleInspectionProvider inspectionProvider : (InconsistentResourceBundleInspectionProvider[])this.myInspectionProviders.getValue()) {
            this.mySettings.put(inspectionProvider.getName(), false);
        }
    }

    @TestOnly
    public void clearSettings() {
        this.mySettings.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/inconsistentResourceBundle/InconsistentResourceBundleInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/inconsistentResourceBundle/InconsistentResourceBundleInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inspectionStarted";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

