/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.vcs.commit.CommitExceptionWithActions;
import com.intellij.vcs.commit.Committer;
import com.intellij.vcs.commit.CommitterResultHandler;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandlerKt;
import com.intellij.vcs.commit.VcsCommitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\r\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0003J\r\u0010\u0010\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/commit/ShowNotificationCommitResultHandler;", "Lcom/intellij/vcs/commit/CommitterResultHandler;", "committer", "Lcom/intellij/vcs/commit/VcsCommitter;", "(Lcom/intellij/vcs/commit/VcsCommitter;)V", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "countChangesIgnoringChangeLists", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "getCommitSummary", "", "Lcom/intellij/openapi/util/NlsSafe;", "getFileSummaryReport", "Lorg/jetbrains/annotations/Nls;", "onCancel", "", "onFailure", "onSuccess", "reportResult", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nShowNotificationCommitResultHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowNotificationCommitResultHandler.kt\ncom/intellij/vcs/commit/ShowNotificationCommitResultHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n800#2,11:101\n1360#2:112\n1446#2,5:113\n1855#2,2:118\n1549#2:120\n1620#2,3:121\n1549#2:124\n1620#2,3:125\n*S KotlinDebug\n*F\n+ 1 ShowNotificationCommitResultHandler.kt\ncom/intellij/vcs/commit/ShowNotificationCommitResultHandler\n*L\n45#1:101,11\n45#1:112\n45#1:113,5\n63#1:118,2\n78#1:120\n78#1:121,3\n83#1:124\n83#1:125,3\n*E\n"})
public final class ShowNotificationCommitResultHandler
implements CommitterResultHandler {
    @NotNull
    private final VcsCommitter committer;
    private final VcsNotifier notifier;

    public ShowNotificationCommitResultHandler(@NotNull VcsCommitter committer) {
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        this.committer = committer;
        this.notifier = VcsNotifier.getInstance(this.committer.getProject());
    }

    @Override
    public void onSuccess() {
        this.reportResult();
    }

    @Override
    public void onCancel() {
        this.notifier.notifyMinorWarning("vcs.commit.canceled", "", VcsBundle.message((String)"vcs.commit.canceled", (Object[])new Object[0]));
    }

    @Override
    public void onFailure() {
        this.reportResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportResult() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterIsInstanceTo$iv$iv;
        String message = this.getCommitSummary();
        List<VcsException> allExceptions = this.committer.getExceptions();
        if (allExceptions.isEmpty()) {
            this.notifier.notifyMinorInfo("vcs.commit.finished", "", message);
            return;
        }
        List<VcsException> errors = Committer.Companion.collectErrors(allExceptions);
        int errorsSize = errors.size();
        int warningsSize = allExceptions.size() - errorsSize;
        Iterable $this$filterIsInstance$iv = allExceptions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CommitExceptionWithActions)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CommitExceptionWithActions it = (CommitExceptionWithActions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getActions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List notificationActions = (List)destination$iv$iv;
        String title2 = null;
        String displayId = null;
        NotificationType notificationType = null;
        if (errorsSize > 0) {
            displayId = "vcs.commit.failed";
            $i$f$flatMapTo = new Object[]{errorsSize};
            String string = VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])$i$f$flatMapTo);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            title2 = string;
            notificationType = NotificationType.ERROR;
        } else {
            displayId = "vcs.commit.finished.with.warnings";
            $i$f$flatMapTo = new Object[]{warningsSize};
            String string = VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])$i$f$flatMapTo);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            title2 = string;
            notificationType = NotificationType.WARNING;
        }
        Notification notification = VcsNotifier.importantNotification().createNotification(title2, message, notificationType);
        notification.setDisplayId(displayId);
        Iterable $this$forEach$iv = notificationActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationAction it = (NotificationAction)element$iv;
            boolean bl = false;
            notification.addAction((AnAction)it);
        }
        VcsNotifier.addShowDetailsAction(this.committer.getProject(), notification);
        notification.notify(this.committer.getProject());
    }

    /*
     * WARNING - void declaration
     */
    @NlsContexts.NotificationContent
    private final String getCommitSummary() {
        List<VcsException> exceptions;
        Collection<HtmlChunk> collection;
        Collection destination$iv$iv;
        HtmlBuilder htmlBuilder;
        HtmlChunk htmlChunk;
        Set<String> feedback;
        HtmlBuilder htmlBuilder2;
        HtmlBuilder $this$getCommitSummary_u24lambda_u243 = htmlBuilder2 = new HtmlBuilder();
        boolean bl = false;
        $this$getCommitSummary_u24lambda_u243.append(this.getFileSummaryReport());
        String commitMessage = this.committer.getCommitMessage();
        if (!StringUtil.isEmpty((String)commitMessage)) {
            $this$getCommitSummary_u24lambda_u243.append(": ").append(commitMessage);
        }
        if (!((Collection)(feedback = this.committer.getFeedback())).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getCommitSummary_u24lambda_u243.br();
            Iterable iterable = feedback;
            htmlChunk = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$getCommitSummary_u24lambda_u243;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(HtmlChunk.text((String)p0));
            }
            collection = (List)destination$iv$iv;
            htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
        }
        if (!ShowNotificationCommitResultHandlerKt.access$hasOnlyWarnings(exceptions = this.committer.getExceptions())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getCommitSummary_u24lambda_u243.br();
            Iterable $i$f$map = exceptions;
            htmlChunk = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$getCommitSummary_u24lambda_u243;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsException bl2 = (VcsException)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(HtmlChunk.text((String)it.getMessage()));
            }
            collection = (List)destination$iv$iv2;
            htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
        }
        String string = htmlBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getFileSummaryReport() {
        int failed = this.countChangesIgnoringChangeLists((Collection<? extends Change>)this.committer.getFailedToCommitChanges());
        int committed = this.countChangesIgnoringChangeLists((Collection<? extends Change>)this.committer.getChanges()) - failed;
        if (failed > 0) {
            Object[] objectArray = new Object[]{committed, failed};
            String string = VcsBundle.message((String)"vcs.commit.files.committed.and.files.failed.to.commit", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Object[] objectArray = new Object[]{committed};
        String string = VcsBundle.message((String)"vcs.commit.files.committed", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final int countChangesIgnoringChangeLists(Collection<? extends Change> changes) {
        return new HashSet<Change>(changes).size();
    }
}

