/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotatedLineModificationDetails;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLineModificationDetailsProvider
implements FileAnnotation.LineModificationDetailsProvider {
    @NotNull
    private final FileAnnotation myAnnotation;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final FileAnnotation.CurrentFileRevisionProvider myCurrentRevisionProvider;
    @NotNull
    private final FileAnnotation.PreviousFileRevisionProvider myPreviousRevisionProvider;

    private DefaultLineModificationDetailsProvider(@NotNull FileAnnotation annotation, @NotNull FilePath filePath, @NotNull FileAnnotation.CurrentFileRevisionProvider currentRevisionProvider, @NotNull FileAnnotation.PreviousFileRevisionProvider previousRevisionProvider) {
        if (annotation == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(1);
        }
        if (currentRevisionProvider == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(2);
        }
        if (previousRevisionProvider == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(3);
        }
        this.myAnnotation = annotation;
        this.myFilePath = filePath;
        this.myCurrentRevisionProvider = currentRevisionProvider;
        this.myPreviousRevisionProvider = previousRevisionProvider;
    }

    @Nullable
    public static FileAnnotation.LineModificationDetailsProvider create(@NotNull FileAnnotation annotation) {
        VirtualFile file;
        if (annotation == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(4);
        }
        if ((file = annotation.getFile()) == null) {
            return null;
        }
        FileAnnotation.CurrentFileRevisionProvider currentRevisionProvider = annotation.getCurrentFileRevisionProvider();
        FileAnnotation.PreviousFileRevisionProvider previousRevisionProvider = annotation.getPreviousFileRevisionProvider();
        if (currentRevisionProvider == null || previousRevisionProvider == null) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        return new DefaultLineModificationDetailsProvider(annotation, filePath, currentRevisionProvider, previousRevisionProvider);
    }

    @Nullable
    public AnnotatedLineModificationDetails getDetails(int lineNumber) throws VcsException {
        String annotatedContent = this.myAnnotation.getAnnotatedContent();
        if (annotatedContent == null) {
            return null;
        }
        LineOffsets offsets = LineOffsetsUtil.create((CharSequence)annotatedContent);
        if (lineNumber >= offsets.getLineCount()) {
            return null;
        }
        String originalLine = DefaultLineModificationDetailsProvider.getLine(annotatedContent, offsets, lineNumber);
        VcsFileRevision afterRevision = this.myCurrentRevisionProvider.getRevision(lineNumber);
        String afterContent = DefaultLineModificationDetailsProvider.loadRevision(this.myAnnotation.getProject(), afterRevision, this.myFilePath);
        if (afterContent == null) {
            return null;
        }
        VcsFileRevision beforeRevision = this.myPreviousRevisionProvider.getPreviousRevision(lineNumber);
        String beforeContent = DefaultLineModificationDetailsProvider.loadRevision(this.myAnnotation.getProject(), beforeRevision, this.myFilePath);
        if (beforeContent == null) {
            return DefaultLineModificationDetailsProvider.createNewLineDetails(originalLine);
        }
        return DefaultLineModificationDetailsProvider.createDetailsFor(beforeContent, afterContent, originalLine);
    }

    @Nullable
    public static String loadRevision(@Nullable Project project, @Nullable VcsFileRevision revision, @NotNull FilePath filePath) throws VcsException {
        if (filePath == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(5);
        }
        try {
            if (revision == null) {
                return null;
            }
            byte[] bytes = revision.loadContent();
            if (bytes == null) {
                return null;
            }
            String content = VcsImplUtil.loadTextFromBytes(project, bytes, filePath);
            return StringUtil.convertLineSeparators((String)content);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Nullable
    public static AnnotatedLineModificationDetails createDetailsFor(@NotNull String beforeContent, @NotNull String afterContent, @NotNull String originalLine) {
        if (beforeContent == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(6);
        }
        if (afterContent == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(7);
        }
        if (originalLine == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(8);
        }
        List<LineFragment> fragments = DefaultLineModificationDetailsProvider.compareContents(beforeContent, afterContent);
        LineOffsets afterLineOffsets = LineOffsetsUtil.create((CharSequence)afterContent);
        int originalLineNumber = DefaultLineModificationDetailsProvider.findOriginalLine(afterContent, afterLineOffsets, originalLine, fragments);
        if (originalLineNumber == -1) {
            return null;
        }
        if (originalLineNumber >= afterLineOffsets.getLineCount()) {
            return null;
        }
        String lineContentAfter = DefaultLineModificationDetailsProvider.getLine(afterContent, afterLineOffsets, originalLineNumber);
        if (StringUtil.isEmptyOrSpaces((String)lineContentAfter)) {
            return DefaultLineModificationDetailsProvider.createNewLineDetails(lineContentAfter);
        }
        return DefaultLineModificationDetailsProvider.createFragmentDetails(lineContentAfter, afterLineOffsets, fragments, originalLineNumber);
    }

    @Nullable
    public static AnnotatedLineModificationDetails createDetailsFor(@Nullable String beforeContent, @NotNull String afterContent, int originalLineNumber) {
        LineOffsets afterLineOffsets;
        if (afterContent == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(9);
        }
        if (originalLineNumber >= (afterLineOffsets = LineOffsetsUtil.create((CharSequence)afterContent)).getLineCount()) {
            return null;
        }
        String lineContentAfter = DefaultLineModificationDetailsProvider.getLine(afterContent, afterLineOffsets, originalLineNumber);
        if (beforeContent == null) {
            return DefaultLineModificationDetailsProvider.createNewLineDetails(lineContentAfter);
        }
        if (StringUtil.isEmptyOrSpaces((String)lineContentAfter)) {
            return DefaultLineModificationDetailsProvider.createNewLineDetails(lineContentAfter);
        }
        List<LineFragment> fragments = DefaultLineModificationDetailsProvider.compareContents(beforeContent, afterContent);
        return DefaultLineModificationDetailsProvider.createFragmentDetails(lineContentAfter, afterLineOffsets, fragments, originalLineNumber);
    }

    @Nullable
    private static AnnotatedLineModificationDetails createFragmentDetails(@NotNull String lineContentAfter, @NotNull LineOffsets afterLineOffsets, @NotNull List<? extends LineFragment> fragments, int originalLineNumber) {
        LineFragment lineFragment;
        if (lineContentAfter == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(10);
        }
        if (afterLineOffsets == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(11);
        }
        if (fragments == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(12);
        }
        if ((lineFragment = (LineFragment)ContainerUtil.find(fragments.iterator(), fragment -> fragment.getStartLine2() <= originalLineNumber && originalLineNumber < fragment.getEndLine2())) == null) {
            return null;
        }
        if (lineFragment.getStartLine1() == lineFragment.getEndLine1()) {
            return DefaultLineModificationDetailsProvider.createNewLineDetails(lineContentAfter);
        }
        List innerFragments = lineFragment.getInnerFragments();
        if (innerFragments == null) {
            return DefaultLineModificationDetailsProvider.createModifiedLineDetails(lineContentAfter);
        }
        int lineStart = afterLineOffsets.getLineStart(originalLineNumber);
        int lineEnd = afterLineOffsets.getLineEnd(originalLineNumber);
        int windowStart = lineStart - lineFragment.getStartOffset2();
        int windowEnd = lineEnd - lineFragment.getStartOffset2();
        int lineLength = lineEnd - lineStart;
        ArrayList<AnnotatedLineModificationDetails.InnerChange> changes = new ArrayList<AnnotatedLineModificationDetails.InnerChange>();
        for (DiffFragment innerFragment : innerFragments) {
            boolean hasInserted;
            if (innerFragment.getEndOffset2() < windowStart || innerFragment.getStartOffset2() > windowEnd) continue;
            int start2 = Math.max(0, innerFragment.getStartOffset2() - windowStart);
            int end = Math.min(lineLength, innerFragment.getEndOffset2() - windowStart);
            boolean hasDeleted = innerFragment.getStartOffset1() != innerFragment.getEndOffset1();
            boolean bl = hasInserted = innerFragment.getStartOffset2() != innerFragment.getEndOffset2();
            AnnotatedLineModificationDetails.InnerChangeType type = hasInserted ? (hasDeleted ? AnnotatedLineModificationDetails.InnerChangeType.MODIFIED : AnnotatedLineModificationDetails.InnerChangeType.INSERTED) : AnnotatedLineModificationDetails.InnerChangeType.DELETED;
            changes.add(new AnnotatedLineModificationDetails.InnerChange(start2, end, type));
        }
        return new AnnotatedLineModificationDetails(lineContentAfter, changes);
    }

    @NotNull
    public static AnnotatedLineModificationDetails createNewLineDetails(@NotNull String lineContentAfter) {
        if (lineContentAfter == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(13);
        }
        AnnotatedLineModificationDetails.InnerChange innerChange = new AnnotatedLineModificationDetails.InnerChange(0, lineContentAfter.length(), AnnotatedLineModificationDetails.InnerChangeType.INSERTED);
        return new AnnotatedLineModificationDetails(lineContentAfter, Collections.singletonList(innerChange));
    }

    @NotNull
    public static AnnotatedLineModificationDetails createModifiedLineDetails(@NotNull String lineContentAfter) {
        if (lineContentAfter == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(14);
        }
        AnnotatedLineModificationDetails.InnerChange innerChange = new AnnotatedLineModificationDetails.InnerChange(0, lineContentAfter.length(), AnnotatedLineModificationDetails.InnerChangeType.MODIFIED);
        return new AnnotatedLineModificationDetails(lineContentAfter, Collections.singletonList(innerChange));
    }

    @NotNull
    private static List<LineFragment> compareContents(@NotNull String beforeContent, @NotNull String afterContent) {
        if (beforeContent == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(15);
        }
        if (afterContent == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(16);
        }
        ProgressIndicator indicator = (ProgressIndicator)ObjectUtils.chooseNotNull((Object)ProgressIndicatorProvider.getGlobalProgressIndicator(), (Object)DumbProgressIndicator.INSTANCE);
        List list = ComparisonManager.getInstance().compareLinesInner((CharSequence)beforeContent, (CharSequence)afterContent, ComparisonPolicy.DEFAULT, indicator);
        if (list == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static int findOriginalLine(@NotNull String afterContent, @NotNull LineOffsets afterLineOffsets, @NotNull String originalLine, @NotNull List<? extends LineFragment> fragments) {
        if (afterContent == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(18);
        }
        if (afterLineOffsets == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(19);
        }
        if (originalLine == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(20);
        }
        if (fragments == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(21);
        }
        for (LineFragment lineFragment : fragments) {
            for (int i = lineFragment.getStartLine2(); i < lineFragment.getEndLine2(); ++i) {
                String line = DefaultLineModificationDetailsProvider.getLine(afterContent, afterLineOffsets, i);
                if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)line, (CharSequence)originalLine)) continue;
                return i;
            }
        }
        return -1;
    }

    @NotNull
    private static String getLine(@NotNull String text2, @NotNull LineOffsets lineOffsets, int line) {
        if (text2 == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(22);
        }
        if (lineOffsets == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(23);
        }
        int lineStart = lineOffsets.getLineStart(line);
        int lineEnd = lineOffsets.getLineEnd(line);
        String string = text2.substring(lineStart, lineEnd);
        if (string == null) {
            DefaultLineModificationDetailsProvider.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRevisionProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousRevisionProvider";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeContent";
                break;
            }
            case 7: 
            case 9: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterContent";
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalLine";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineContentAfter";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterLineOffsets";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/annotate/DefaultLineModificationDetailsProvider";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/annotate/DefaultLineModificationDetailsProvider";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "compareContents";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadRevision";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsFor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFragmentDetails";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNewLineDetails";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createModifiedLineDetails";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compareContents";
                break;
            }
            case 17: 
            case 24: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalLine";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 24 -> new IllegalStateException(string);
        };
    }
}

