/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions.commit;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcsUtil.VcsImplUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\nJT\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007JM\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\n2\r\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/vcs/actions/commit/CheckinActionUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getIncludedChanges", "", "project", "Lcom/intellij/openapi/project/Project;", "selectedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "selectedUnversioned", "Lcom/intellij/openapi/vcs/FilePath;", "initialChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "pathsToCommit", "getInitiallySelectedChangeList", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getInitiallySelectedChangeListFor", "performCheckInAfterUpdate", "", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "forceUpdateCommitStateFromContext", "", "performCommonCommitAction", "actionName", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "updateCommonCommitAction", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCheckinActionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckinActionUtil.kt\ncom/intellij/openapi/vcs/actions/commit/CheckinActionUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,152:1\n37#2,2:153\n1#3:155\n13#4:156\n*S KotlinDebug\n*F\n+ 1 CheckinActionUtil.kt\ncom/intellij/openapi/vcs/actions/commit/CheckinActionUtil\n*L\n76#1:153,2\n30#1:156\n*E\n"})
public final class CheckinActionUtil {
    @NotNull
    public static final CheckinActionUtil INSTANCE = new CheckinActionUtil();
    @NotNull
    private static final Logger LOG;

    private CheckinActionUtil() {
    }

    public final void updateCommonCommitAction(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (project == null || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss() || CommitModeManager.Companion.getInstance(project).getCurrentCommitMode().disableDefaultCommitAction()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        AbstractVcs singleVcs = projectLevelVcsManager.getSingleVCS();
        presentation2.setEnabled(!projectLevelVcsManager.isBackgroundVcsOperationRunning() && (singleVcs == null || !singleVcs.isCommitActionDisabled()));
        presentation2.setVisible(true);
    }

    public final void performCommonCommitAction(@NotNull AnActionEvent e, @NotNull Project project, @NotNull LocalChangeList initialChangeList, @NotNull List<? extends FilePath> pathsToCommit, @Nullable String actionName, @Nullable CommitExecutor executor, boolean forceUpdateCommitStateFromContext) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialChangeList, (String)"initialChangeList");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        LOG.debug("performCommonCommitAction");
        String string2 = actionName;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String operationName = AbstractCommitWorkflowKt.cleanActionText$default(actionName, false, 2, null);
            Object[] objectArray = new Object[]{operationName};
            string = VcsBundle.message((String)"error.cant.perform.operation.now", (Object[])objectArray);
        } else {
            string = null;
        }
        String isFreezedDialogTitle = string;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        if (changeListManager2.isFreezedWithNotification(isFreezedDialogTitle)) {
            LOG.debug("ChangeListManager is freezed, abort commit");
            return;
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning()) {
            LOG.debug("Background operation is running, abort commit");
            return;
        }
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        List list = objectArray != null ? ArraysKt.asList((Object[])objectArray) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List selectedChanges = list;
        Iterable iterable = (Iterable)e.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY);
        List list2 = iterable != null ? CollectionsKt.toList((Iterable)iterable) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List selectedUnversioned = list2;
        Collection $this$toTypedArray$iv = pathsToCommit;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FilePath[] filePathArray = DescindingFilesFilter.filterDescindingFiles(thisCollection$iv.toArray(new FilePath[0]), project);
        Intrinsics.checkNotNullExpressionValue((Object)filePathArray, (String)"filterDescindingFiles(...)");
        List filteredPaths = ArraysKt.asList((Object[])filePathArray);
        this.performCheckInAfterUpdate(project, selectedChanges, selectedUnversioned, initialChangeList, filteredPaths, executor, forceUpdateCommitStateFromContext);
    }

    @RequiresEdt
    public final void performCheckInAfterUpdate(@NotNull Project project, @NotNull List<? extends Change> selectedChanges, @NotNull List<? extends FilePath> selectedUnversioned, @NotNull LocalChangeList initialChangeList, @NotNull List<? extends FilePath> pathsToCommit, @Nullable CommitExecutor executor, boolean forceUpdateCommitStateFromContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selectedChanges, (String)"selectedChanges");
        Intrinsics.checkNotNullParameter(selectedUnversioned, (String)"selectedUnversioned");
        Intrinsics.checkNotNullParameter((Object)initialChangeList, (String)"initialChangeList");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        FileDocumentManager.getInstance().saveAllDocuments();
        Object[] objectArray = new Object[]{project.getName()};
        String string = IdeBundle.message((String)"progress.saving.project", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = StoreUtilKt.saveSettings$default((ComponentManager)((ComponentManager)this.$project), (boolean)false, (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        ChangesViewCommitWorkflowHandler workflowHandler = ChangesViewWorkflowManager.getInstance(project).getCommitWorkflowHandler();
        if (executor == null && workflowHandler != null) {
            Collection<Object> included = this.getIncludedChanges(project, selectedChanges, selectedUnversioned, initialChangeList, pathsToCommit);
            workflowHandler.setCommitState(initialChangeList, included, forceUpdateCommitStateFromContext);
            workflowHandler.activate();
        } else {
            ChangeListManager.getInstance((Project)project).invokeAfterUpdateWithModal(true, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), () -> CheckinActionUtil.performCheckInAfterUpdate$lambda$1(project, selectedChanges, selectedUnversioned, initialChangeList, pathsToCommit, executor));
        }
    }

    private final Collection<Object> getIncludedChanges(Project project, List<? extends Change> selectedChanges, List<? extends FilePath> selectedUnversioned, LocalChangeList initialChangeList, List<? extends FilePath> pathsToCommit) {
        if (selectedChanges.isEmpty() && selectedUnversioned.isEmpty()) {
            Collection collection = ChangeListManager.getInstance((Project)project).getAllChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
            Collection allChanges = collection;
            Set set = VcsImplUtil.filterChangesUnder(allChanges, (Collection<FilePath>)pathsToCommit).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
            Set changesToCommit = set;
            Collection collection2 = initialChangeList.getChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getChanges(...)");
            return CollectionsKt.intersect((Iterable)collection2, (Iterable)changesToCommit);
        }
        List list = ContainerUtil.concat(selectedChanges, selectedUnversioned);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"concat(...)");
        return list;
    }

    @NotNull
    public final LocalChangeList getInitiallySelectedChangeList(@NotNull Project project, @NotNull AnActionEvent e) {
        ChangeList[] changeListArray;
        ChangeList[] changeListArray2;
        ChangeList[] changeListArray3;
        ChangeListManager manager;
        block8: {
            Change change;
            block7: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
                manager = changeListManager;
                changeListArray3 = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
                if (changeListArray3 == null || (changeListArray3 = (ChangeList[])ArraysKt.firstOrNull((Object[])changeListArray3)) == null) break block7;
                ChangeList[] it = changeListArray3;
                boolean bl = false;
                LocalChangeList localChangeList = manager.findChangeList(it.getName());
                changeListArray3 = localChangeList;
                if (localChangeList != null) break block8;
            }
            if ((change = (Change[])e.getData(VcsDataKeys.CHANGES)) != null && (change = (Change)ArraysKt.firstOrNull((Object[])change)) != null) {
                Change it = change;
                boolean bl = false;
                changeListArray3 = manager.getChangeList(it);
            } else {
                changeListArray3 = null;
            }
        }
        if ((changeListArray2 = changeListArray3) == null) {
            LocalChangeList localChangeList = manager.getDefaultChangeList();
            changeListArray = localChangeList;
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        } else {
            changeListArray = changeListArray2;
        }
        return changeListArray;
    }

    @NotNull
    public final LocalChangeList getInitiallySelectedChangeListFor(@NotNull Project project, @NotNull List<? extends FilePath> pathsToCommit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)changeListManagerEx), (String)"getInstanceEx(...)");
        ChangeListManagerEx manager = changeListManagerEx;
        LocalChangeList localChangeList = manager.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        LocalChangeList defaultChangeList = localChangeList;
        JBIterable<? extends Change> jBIterable = VcsImplUtil.filterChangesUnder(defaultChangeList.getChanges(), (Collection<FilePath>)pathsToCommit);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"filterChangesUnder(...)");
        JBIterable<? extends Change> selectedInDefault = jBIterable;
        if (selectedInDefault.isNotEmpty()) {
            return defaultChangeList;
        }
        JBIterable<? extends Change> jBIterable2 = VcsImplUtil.filterChangesUnder(manager.getAllChanges(), (Collection<FilePath>)pathsToCommit);
        Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"filterChangesUnder(...)");
        JBIterable<? extends Change> selectedChanges = jBIterable2;
        Collection<LocalChangeList> collection = manager.getAffectedLists(selectedChanges.toList());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAffectedLists(...)");
        Collection<LocalChangeList> changeLists = collection;
        LocalChangeList localChangeList2 = (LocalChangeList)CollectionsKt.singleOrNull((Iterable)changeLists);
        if (localChangeList2 == null) {
            localChangeList2 = defaultChangeList;
        }
        return localChangeList2;
    }

    private static final void performCheckInAfterUpdate$lambda$1(Project $project, List $selectedChanges, List $selectedUnversioned, LocalChangeList $initialChangeList, List $pathsToCommit, CommitExecutor $executor) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$selectedChanges, (String)"$selectedChanges");
        Intrinsics.checkNotNullParameter((Object)$selectedUnversioned, (String)"$selectedUnversioned");
        Intrinsics.checkNotNullParameter((Object)$initialChangeList, (String)"$initialChangeList");
        Intrinsics.checkNotNullParameter((Object)$pathsToCommit, (String)"$pathsToCommit");
        Collection<Object> included = INSTANCE.getIncludedChanges($project, $selectedChanges, $selectedUnversioned, $initialChangeList, $pathsToCommit);
        if ($executor != null) {
            CommitChangeListDialog.commitWithExecutor($project, included, $initialChangeList, $executor, null, null);
        } else {
            CommitChangeListDialog.commitVcsChanges($project, included, $initialChangeList, null, null);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CheckinActionUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

