/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.CloudConfigVersionContext;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.SettingsSyncEventListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncLocalSettings;
import com.intellij.settingsSync.SettingsSyncPushResult;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSynchronizerKt;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.util.ResettableLazy;
import com.intellij.util.ResettableLazyKt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.jetbrains.cloudconfig.CloudConfigFileClientV2;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.FileVersionInfo;
import com.jetbrains.cloudconfig.auth.JbaJwtTokenAuthProvider;
import com.jetbrains.cloudconfig.exception.InvalidVersionIdException;
import com.jetbrains.cloudconfig.exception.UnauthorizedException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000 G2\u00020\u0001:\u0001GB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u001d\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0015H\u0011\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u0003H\u0005J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020-0/2\u0006\u0010&\u001a\u00020\u0003J\n\u00100\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010-2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u001a\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u001a2\b\u00104\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010&\u001a\u00020\u0003H\u0016J\"\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u0002062\b\u0010<\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010=\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010+\u0012\u0006\u0012\u0004\u0018\u00010\u00030>2\u0006\u0010?\u001a\u00020\u0003H\u0002J\b\u0010@\u001a\u00020AH\u0016J\"\u0010B\u001a\u0002082\u0006\u0010C\u001a\u00020+2\b\u0010D\u001a\u0004\u0018\u00010\u00032\u0006\u0010;\u001a\u000206H\u0002J7\u0010B\u001a\u0002082\u0006\u0010C\u001a\u00020+2\b\u0010D\u001a\u0004\u0018\u00010\u00032\u0006\u0010;\u001a\u0002062\u0006\u0010!\u001a\u00020\u00152\u0006\u0010E\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\bFR0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\u0004\u0018\u00010\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0004R\u0014\u0010\u0011\u001a\u00020\u00078PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "serverUrl", "", "(Ljava/lang/String;)V", "<set-?>", "Lcom/intellij/util/ResettableLazy;", "Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "_client", "get_client$intellij_settingsSync", "()Lcom/intellij/util/ResettableLazy;", "set_client$intellij_settingsSync", "(Lcom/intellij/util/ResettableLazy;)V", "_currentIdTokenVar", "get_currentIdTokenVar$intellij_settingsSync", "()Ljava/lang/String;", "set_currentIdTokenVar$intellij_settingsSync", "client", "getClient$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "clientVersionContext", "Lcom/intellij/settingsSync/CloudConfigVersionContext;", "getClientVersionContext", "()Lcom/intellij/settingsSync/CloudConfigVersionContext;", "lastRemoteErrorRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "checkServerState", "Lcom/intellij/settingsSync/ServerState;", "clearLastRemoteError", "", "createCloudConfigClient", "url", "versionContext", "createCloudConfigClient$intellij_settingsSync", "createConfiguration", "Lcom/jetbrains/cloudconfig/Configuration;", "createFile", "filePath", "content", "currentSnapshotFilePath", "deleteFile", "downloadSnapshot", "Ljava/io/InputStream;", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "fetchHistory", "", "getCurrentIdToken", "getLatestVersion", "handleRemoteError", "e", "idTokenInRequest", "isFileExists", "", "push", "Lcom/intellij/settingsSync/SettingsSyncPushResult;", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "force", "expectedServerVersionId", "receiveSnapshotFile", "Lkotlin/Pair;", "snapshotFilePath", "receiveUpdates", "Lcom/intellij/settingsSync/UpdateResult;", "sendSnapshotFile", "inputStream", "knownServerVersion", "cloudConfigClient", "sendSnapshotFile$intellij_settingsSync", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nCloudConfigServerCommunicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/CloudConfigServerCommunicator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n13#2:392\n*S KotlinDebug\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/CloudConfigServerCommunicator\n*L\n373#1:392\n*E\n"})
public class CloudConfigServerCommunicator
implements SettingsSyncRemoteCommunicator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudConfigVersionContext clientVersionContext;
    @VisibleForTesting
    @Nullable
    private volatile String _currentIdTokenVar;
    @NotNull
    private ResettableLazy<? extends CloudConfigFileClientV2> _client;
    @NotNull
    private final AtomicReference<Throwable> lastRemoteErrorRef;
    @NotNull
    private static final String URL_PROVIDER = "https://www.jetbrains.com/config/IdeaCloudConfig.xml";
    @NotNull
    private static final String DEFAULT_PRODUCTION_URL = "https://cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String DEFAULT_DEBUG_URL = "https://stgn.cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String URL_PROPERTY = "idea.settings.sync.cloud.url";
    @NotNull
    private static final Lazy<String> _url = LazyKt.lazy((Function0)Companion._url.1.INSTANCE);
    @NotNull
    private static final Logger LOG;
    @VisibleForTesting
    @NotNull
    private static final ETagStorage DUMMY_ETAG_STORAGE;

    public CloudConfigServerCommunicator(@Nullable String serverUrl) {
        this.clientVersionContext = new CloudConfigVersionContext();
        this._client = ResettableLazyKt.resettableLazy((Function0)((Function0)new Function0<CloudConfigFileClientV2>(this, serverUrl){
            final /* synthetic */ CloudConfigServerCommunicator this$0;
            final /* synthetic */ String $serverUrl;
            {
                this.this$0 = $receiver;
                this.$serverUrl = $serverUrl;
                super(0);
            }

            @NotNull
            public final CloudConfigFileClientV2 invoke() {
                String string = this.$serverUrl;
                if (string == null) {
                    string = CloudConfigServerCommunicator.Companion.getDefaultUrl$intellij_settingsSync();
                }
                return this.this$0.createCloudConfigClient$intellij_settingsSync(string, this.this$0.getClientVersionContext());
            }
        }));
        this.lastRemoteErrorRef = new AtomicReference();
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            @Override
            public void loginStateChanged() {
                this.get_client$intellij_settingsSync().reset();
            }
        });
    }

    public /* synthetic */ CloudConfigServerCommunicator(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @NotNull
    protected final CloudConfigVersionContext getClientVersionContext() {
        return this.clientVersionContext;
    }

    @Nullable
    public final String get_currentIdTokenVar$intellij_settingsSync() {
        return this._currentIdTokenVar;
    }

    public final void set_currentIdTokenVar$intellij_settingsSync(@Nullable String string) {
        this._currentIdTokenVar = string;
    }

    @NotNull
    public final ResettableLazy<CloudConfigFileClientV2> get_client$intellij_settingsSync() {
        return this._client;
    }

    @TestOnly
    public final void set_client$intellij_settingsSync(@NotNull ResettableLazy<? extends CloudConfigFileClientV2> resettableLazy) {
        Intrinsics.checkNotNullParameter(resettableLazy, (String)"<set-?>");
        this._client = resettableLazy;
    }

    @NotNull
    public CloudConfigFileClientV2 getClient$intellij_settingsSync() {
        return (CloudConfigFileClientV2)this._client.getValue();
    }

    private final String getCurrentIdToken() {
        this._client.getValue();
        return this._currentIdTokenVar;
    }

    @VisibleForTesting
    @Nullable
    protected final String currentSnapshotFilePath() throws IOException, UnauthorizedException {
        try {
            Object object;
            boolean crossIdeSyncEnabled = this.isFileExists("cross-ide-sync-enabled");
            if (crossIdeSyncEnabled != SettingsSyncLocalSettings.Companion.getInstance().isCrossIdeSyncEnabled()) {
                LOG.info("Cross-IDE sync status on server is: " + SettingsSynchronizerKt.enabledOrDisabled(crossIdeSyncEnabled) + ". Updating local settings with it.");
                SettingsSyncLocalSettings.Companion.getInstance().setCrossIdeSyncEnabled(crossIdeSyncEnabled);
            }
            if (crossIdeSyncEnabled) {
                object = "settings.sync.snapshot.zip";
            } else {
                String string = ApplicationNamesInfo.getInstance().getProductName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductName(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                object = string2 + "/settings.sync.snapshot.zip";
            }
            return object;
        }
        catch (Throwable e) {
            if (e instanceof IOException || e instanceof UnauthorizedException) {
                throw e;
            }
            LOG.warn("Couldn't check if cross-ide-sync-enabled exists", e);
            return null;
        }
    }

    private final Pair<InputStream, String> receiveSnapshotFile(String snapshotFilePath) throws IOException {
        return (Pair)this.clientVersionContext.doWithVersion(snapshotFilePath, null, (Function1)new Function1<String, Pair<? extends InputStream, ? extends String>>(this){
            final /* synthetic */ CloudConfigServerCommunicator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<InputStream, String> invoke(@NotNull String filePath) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                try {
                    InputStream stream2 = this.this$0.getClient$intellij_settingsSync().read(filePath);
                    String actualVersion = this.this$0.getClientVersionContext().get(filePath);
                    if (actualVersion == null) {
                        CloudConfigServerCommunicator.access$getLOG$cp().warn("Version not stored in the context for " + filePath);
                    }
                    pair = new Pair((Object)stream2, (Object)actualVersion);
                }
                catch (FileNotFoundException fileNotFound) {
                    pair = new Pair(null, null);
                }
                return pair;
            }
        });
    }

    private final SettingsSyncPushResult sendSnapshotFile(InputStream inputStream, String knownServerVersion, boolean force) {
        return this.sendSnapshotFile$intellij_settingsSync(inputStream, knownServerVersion, force, this.clientVersionContext, this.getClient$intellij_settingsSync());
    }

    @VisibleForTesting
    @NotNull
    public final SettingsSyncPushResult sendSnapshotFile$intellij_settingsSync(@NotNull InputStream inputStream, @Nullable String knownServerVersion, boolean force, @NotNull CloudConfigVersionContext versionContext, @NotNull CloudConfigFileClientV2 cloudConfigClient) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)versionContext, (String)"versionContext");
        Intrinsics.checkNotNullParameter((Object)cloudConfigClient, (String)"cloudConfigClient");
        String snapshotFilePath = null;
        String defaultMessage = "Unknown during checking cross-ide-sync-enabled";
        try {
            String string = this.currentSnapshotFilePath();
            if (string == null) {
                return new SettingsSyncPushResult.Error(defaultMessage);
            }
            snapshotFilePath = string;
        }
        catch (IOException ioe) {
            String string = ioe.getMessage();
            if (string == null) {
                string = defaultMessage;
            }
            return new SettingsSyncPushResult.Error(string);
        }
        String versionToPush = null;
        if (force) {
            FileVersionInfo fileVersionInfo = this.getLatestVersion(snapshotFilePath);
            versionToPush = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
        } else if (knownServerVersion != null) {
            versionToPush = knownServerVersion;
        } else {
            String serverVersion;
            FileVersionInfo fileVersionInfo = this.getLatestVersion(snapshotFilePath);
            String string = serverVersion = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
            if (serverVersion == null) {
                versionToPush = null;
            } else {
                return SettingsSyncPushResult.Rejected.INSTANCE;
            }
        }
        String serverVersionId2 = (String)versionContext.doWithVersion(snapshotFilePath, versionToPush, (Function1)new Function1<String, String>(cloudConfigClient, inputStream, versionContext){
            final /* synthetic */ CloudConfigFileClientV2 $cloudConfigClient;
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ CloudConfigVersionContext $versionContext;
            {
                this.$cloudConfigClient = $cloudConfigClient;
                this.$inputStream = $inputStream;
                this.$versionContext = $versionContext;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull String filePath) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                this.$cloudConfigClient.write(filePath, this.$inputStream);
                String actualVersion = this.$versionContext.get(filePath);
                if (actualVersion == null) {
                    CloudConfigServerCommunicator.access$getLOG$cp().warn("Version not stored in the context for " + filePath);
                }
                return actualVersion;
            }
        });
        return new SettingsSyncPushResult.Success(serverVersionId2);
    }

    @Override
    @NotNull
    public ServerState checkServerState() {
        String idTokenInRequest = this.getCurrentIdToken();
        try {
            String string;
            String string2 = this.currentSnapshotFilePath();
            if (string2 == null) {
                return new ServerState.Error("Unknown error during checkServerState");
            }
            String snapshotFilePath = string2;
            FileVersionInfo latestVersion = this.getClient$intellij_settingsSync().getLatestVersion(snapshotFilePath);
            LOG.debug("Latest version info: " + latestVersion);
            this.clearLastRemoteError();
            FileVersionInfo fileVersionInfo = latestVersion;
            String string3 = string = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
            if (string == null) {
                return ServerState.FileNotExists.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)string, (Object)SettingsSyncLocalSettings.Companion.getInstance().getKnownAndAppliedServerId())) {
                return ServerState.UpToDate.INSTANCE;
            }
            return ServerState.UpdateNeeded.INSTANCE;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e, idTokenInRequest);
            return new ServerState.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public UpdateResult receiveUpdates() {
        LOG.info("Receiving settings snapshot from the cloud config server...");
        String idTokenInRequest = this.getCurrentIdToken();
        try {
            String string = this.currentSnapshotFilePath();
            if (string == null) {
                return new UpdateResult.Error("Unknown error during receiveUpdates");
            }
            String snapshotFilePath = string;
            Pair<InputStream, String> pair = this.receiveSnapshotFile(snapshotFilePath);
            InputStream stream2 = (InputStream)pair.component1();
            String version = (String)pair.component2();
            this.clearLastRemoteError();
            if (stream2 == null) {
                LOG.info(snapshotFilePath + " not found on the server");
                return UpdateResult.NoFileOnServer.INSTANCE;
            }
            File file = FileUtil.createTempFile((String)"settings.sync.snapshot", (String)(UUID.randomUUID().toString() + ".zip"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File tempFile = file;
            try {
                FileUtil.writeToFile((File)tempFile, (byte[])stream2.readAllBytes());
                Path path = tempFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                SettingsSnapshot snapshot = SettingsSnapshotZipSerializer.INSTANCE.extractFromZip(path);
                if (snapshot == null) {
                    LOG.info("cannot extract snapshot from tempFile " + tempFile.toPath() + ". Implying there's no snapshot");
                    UpdateResult updateResult = UpdateResult.NoFileOnServer.INSTANCE;
                    return updateResult;
                }
                UpdateResult updateResult = snapshot.isDeleted() ? (UpdateResult)UpdateResult.FileDeletedFromServer.INSTANCE : (UpdateResult)new UpdateResult.Success(snapshot, version);
                return updateResult;
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e, idTokenInRequest);
            return new UpdateResult.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SettingsSyncPushResult push(@NotNull SettingsSnapshot snapshot, boolean force, @Nullable String expectedServerVersionId) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        LOG.info("Pushing setting snapshot to the cloud config server...");
        try {
            path = SettingsSnapshotZipSerializer.INSTANCE.serializeToZip(snapshot);
        }
        catch (Throwable e) {
            LOG.warn(e);
            String string = e.getMessage();
            if (string == null) {
                string = "Couldn't prepare zip file";
            }
            return new SettingsSyncPushResult.Error(string);
        }
        Path zip = path;
        String idTokenInRequest = this.getCurrentIdToken();
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(zip, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            SettingsSyncPushResult pushResult = this.sendSnapshotFile(inputStream, expectedServerVersionId, force);
            this.clearLastRemoteError();
            SettingsSyncPushResult settingsSyncPushResult = pushResult;
            return settingsSyncPushResult;
        }
        catch (InvalidVersionIdException ive) {
            LOG.info("Rejected: version doesn't match the version on server: " + ive.getMessage());
            SettingsSyncPushResult settingsSyncPushResult = SettingsSyncPushResult.Rejected.INSTANCE;
            return settingsSyncPushResult;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e, idTokenInRequest);
            SettingsSyncPushResult settingsSyncPushResult = new SettingsSyncPushResult.Error(message);
            return settingsSyncPushResult;
        }
        finally {
            try {
                PathKt.delete$default((Path)zip, (boolean)false, (int)1, null);
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
    }

    private final void clearLastRemoteError() {
        if (this.lastRemoteErrorRef.get() != null) {
            LOG.info("Connection to setting sync server is restored");
        }
        this.lastRemoteErrorRef.set(null);
    }

    private final String handleRemoteError(Throwable e, String idTokenInRequest) {
        String string;
        String defaultMessage = "Error during communication with server";
        if (e instanceof IOException) {
            Throwable throwable = this.lastRemoteErrorRef.get();
            if (!Intrinsics.areEqual((Object)(throwable != null ? throwable.getMessage() : null), (Object)e.getMessage())) {
                this.lastRemoteErrorRef.set(e);
                LOG.warn(defaultMessage + ": " + e.getMessage());
            }
        } else if (e instanceof UnauthorizedException) {
            if (idTokenInRequest != null) {
                SettingsSyncAuthService.Companion.getInstance().invalidateJBA(idTokenInRequest);
            }
            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
            LOG.warn("Got \"Unauthorized\" from Settings Sync server. Settings Sync will be disabled. Please login to JBA again");
        } else {
            LOG.error(e);
        }
        if ((string = e.getMessage()) == null) {
            string = defaultMessage;
        }
        return string;
    }

    @Nullable
    public final InputStream downloadSnapshot(@NotNull String filePath, @NotNull FileVersionInfo version) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        InputStream stream2 = (InputStream)this.clientVersionContext.doWithVersion(filePath, version.getVersionId(), (Function1)new Function1<String, InputStream>(this){
            final /* synthetic */ CloudConfigServerCommunicator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final InputStream invoke(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return this.this$0.getClient$intellij_settingsSync().read(path);
            }
        });
        if (stream2 == null) {
            LOG.info(filePath + " not found on the server");
        }
        return stream2;
    }

    @Override
    public void createFile(@NotNull String filePath, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        CloudConfigFileClientV2 cloudConfigFileClientV2 = this.getClient$intellij_settingsSync();
        String string = content;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        cloudConfigFileClientV2.write(filePath, new ByteArrayInputStream(byArray));
    }

    private final FileVersionInfo getLatestVersion(String filePath) {
        return this.getClient$intellij_settingsSync().getLatestVersion(filePath);
    }

    @Override
    public void deleteFile(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(null);
        this.getClient$intellij_settingsSync().delete(filePath);
    }

    @Override
    public boolean isFileExists(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.getClient$intellij_settingsSync().getLatestVersion(filePath) != null;
    }

    @NotNull
    public final List<FileVersionInfo> fetchHistory(@NotNull String filePath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List<FileVersionInfo> list = this.getClient$intellij_settingsSync().getVersions(filePath);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getVersions(...)");
        return list;
    }

    @VisibleForTesting
    @NotNull
    public CloudConfigFileClientV2 createCloudConfigClient$intellij_settingsSync(@NotNull String url, @NotNull CloudConfigVersionContext versionContext) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)versionContext, (String)"versionContext");
        Configuration conf = this.createConfiguration();
        return new CloudConfigFileClientV2(url, conf, DUMMY_ETAG_STORAGE, versionContext);
    }

    private final Configuration createConfiguration() {
        String idToken;
        Configuration configuration = new Configuration().connectTimeout(10000).readTimeout(50000);
        this._currentIdTokenVar = idToken = SettingsSyncAuthService.Companion.getInstance().getIdToken();
        if (idToken == null) {
            LOG.warn("No idToken provided! Setting Sync will be disabled");
        } else {
            configuration.auth(new JbaJwtTokenAuthProvider(idToken));
        }
        Intrinsics.checkNotNull((Object)configuration);
        return configuration;
    }

    public CloudConfigServerCommunicator() {
        this(null, 1, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CloudConfigServerCommunicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DUMMY_ETAG_STORAGE = new ETagStorage(){

            @Nullable
            public String get(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return null;
            }

            public void store(@NotNull String path, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }

            public void remove(@Nullable String path) {
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator$Companion;", "", "()V", "DEFAULT_DEBUG_URL", "", "DEFAULT_PRODUCTION_URL", "DUMMY_ETAG_STORAGE", "Lcom/jetbrains/cloudconfig/ETagStorage;", "getDUMMY_ETAG_STORAGE$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/ETagStorage;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "URL_PROPERTY", "URL_PROVIDER", "_url", "Lkotlin/Lazy;", "defaultUrl", "getDefaultUrl$intellij_settingsSync", "()Ljava/lang/String;", "getProductionUrl", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultUrl$intellij_settingsSync() {
            return (String)_url.getValue();
        }

        private final String getProductionUrl() {
            String configUrl = (String)HttpRequests.request((String)CloudConfigServerCommunicator.URL_PROVIDER).productNameAsUserAgent().connect(Companion::getProductionUrl$lambda$0, (Object)CloudConfigServerCommunicator.DEFAULT_PRODUCTION_URL, LOG);
            LOG.info("Using SettingSync server URL: " + configUrl);
            Intrinsics.checkNotNull((Object)configUrl);
            return configUrl;
        }

        @NotNull
        public final ETagStorage getDUMMY_ETAG_STORAGE$intellij_settingsSync() {
            return DUMMY_ETAG_STORAGE;
        }

        private static final String getProductionUrl$lambda$0(HttpRequests.Request request) {
            String string;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            try {
                Element documentElement = JDOMUtil.load((InputStream)request.getInputStream());
                string = documentElement.getAttributeValue("baseUrl");
            }
            catch (JDOMException e) {
                throw new IOException(e);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ String access$getProductionUrl(Companion $this) {
            return $this.getProductionUrl();
        }
    }
}

