/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractIntProperty;
import com.intellij.uiDesigner.propertyInspector.properties.HGapProperty;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.LayoutManager;

@Service(value={Service.Level.PROJECT})
public final class VGapProperty
extends AbstractIntProperty<RadContainer> {
    public static VGapProperty getInstance(Project project) {
        return (VGapProperty)project.getService(VGapProperty.class);
    }

    public VGapProperty() {
        super(null, "Vertical Gap", -1);
    }

    @Override
    public Integer getValue(RadContainer component) {
        LayoutManager layoutManager = component.getLayout();
        if (layoutManager instanceof BorderLayout) {
            BorderLayout layout = (BorderLayout)layoutManager;
            return layout.getVgap();
        }
        layoutManager = component.getLayout();
        if (layoutManager instanceof FlowLayout) {
            FlowLayout layout = (FlowLayout)layoutManager;
            return layout.getVgap();
        }
        layoutManager = component.getLayout();
        if (layoutManager instanceof CardLayout) {
            CardLayout layout = (CardLayout)layoutManager;
            return layout.getVgap();
        }
        layoutManager = component.getLayout();
        if (layoutManager instanceof AbstractLayout) {
            AbstractLayout layoutManager2 = (AbstractLayout)layoutManager;
            return layoutManager2.getVGap();
        }
        return null;
    }

    @Override
    protected void setValueImpl(RadContainer component, Integer value) throws Exception {
        LayoutManager layoutManager = component.getLayout();
        if (layoutManager instanceof BorderLayout) {
            BorderLayout layout = (BorderLayout)layoutManager;
            layout.setVgap(value);
        } else {
            layoutManager = component.getLayout();
            if (layoutManager instanceof FlowLayout) {
                FlowLayout layout = (FlowLayout)layoutManager;
                layout.setVgap(value);
            } else {
                layoutManager = component.getLayout();
                if (layoutManager instanceof CardLayout) {
                    CardLayout layout = (CardLayout)layoutManager;
                    layout.setVgap(value);
                } else {
                    AbstractLayout layoutManager2 = (AbstractLayout)component.getLayout();
                    layoutManager2.setVGap(value.intValue());
                }
            }
        }
    }

    @Override
    protected int getDefaultValue(RadContainer radContainer) {
        return HGapProperty.getDefaultGap(radContainer.getLayout());
    }
}

