/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.binding.ReferenceInForm;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFileReference
extends ReferenceInForm {
    public ResourceFileReference(PsiPlainTextFile file, TextRange range) {
        super(file, range);
    }

    @Nullable
    public PsiElement resolve() {
        Module module2 = ModuleUtilCore.findModuleForFile((PsiFile)this.myFile);
        if (module2 == null) {
            return null;
        }
        VirtualFile formFile = ResourceFileUtil.findResourceFileInDependents((Module)module2, (String)this.getRangeText());
        if (formFile == null) {
            return null;
        }
        return this.myFile.getManager().findFile(formFile);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ResourceFileReference.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiFile)) {
            throw new IncorrectOperationException();
        }
        this.updateRangeText(FormEditingUtil.buildResourceName((PsiFile)element));
        return this.myFile;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) {
        if (newElementName == null) {
            ResourceFileReference.$$$reportNull$$$0(1);
        }
        return this.handleFileRename(newElementName, "", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/binding/ResourceFileReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleElementRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

