/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleTransferable<T>
implements Transferable {
    private static final Logger LOG = Logger.getInstance(SimpleTransferable.class);
    private static final Map<String, DataFlavor> ourDataFlavorMap = new HashMap<String, DataFlavor>();
    private final T myDataProxy;
    private final Class<T> myDataClass;
    private final DataFlavor myDataFlavor;

    public SimpleTransferable(T data, Class<T> dataClass) {
        this.myDataProxy = data;
        this.myDataClass = dataClass;
        this.myDataFlavor = SimpleTransferable.getDataFlavor(this.myDataClass);
    }

    public SimpleTransferable(T data, Class<T> dataClass, DataFlavor flavor) {
        this.myDataProxy = data;
        this.myDataClass = dataClass;
        this.myDataFlavor = flavor;
    }

    @Override
    @NotNull
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        block3: {
            T t;
            try {
                if (!this.myDataFlavor.equals(flavor)) break block3;
                t = this.myDataProxy;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (t == null) {
                SimpleTransferable.$$$reportNull$$$0(0);
            }
            return t;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private static <T> DataFlavor getDataFlavor(Class<T> dataClass) {
        DataFlavor result = ourDataFlavorMap.get(dataClass.getName());
        if (result == null) {
            try {
                result = new DataFlavor("application/x-java-jvm-local-objectref");
                ourDataFlavorMap.put(dataClass.getName(), result);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        try {
            return new DataFlavor[]{this.myDataFlavor};
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return new DataFlavor[0];
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        try {
            return flavor.equals(this.myDataFlavor);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static <T> T getData(Transferable transferable, Class<T> dataClass) {
        try {
            DataFlavor dataFlavor = SimpleTransferable.getDataFlavor(dataClass);
            if (!transferable.isDataFlavorSupported(dataFlavor)) {
                return null;
            }
            Object transferData = transferable.getTransferData(dataFlavor);
            if (!dataClass.isInstance(transferData)) {
                return null;
            }
            return (T)transferData;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/SimpleTransferable", "getTransferData"));
    }
}

