/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.model;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.searchEverywhereMl.ranking.core.model.SearchEverywhereRankingModel;
import com.intellij.searchEverywhereMl.ranking.core.model.SimpleSearchEverywhereRankingModel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000eH\u0002J\u001e\u0010\u0011\u001a\u00020\u00062\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/model/ExactMatchSearchEverywhereRankingModel;", "Lcom/intellij/searchEverywhereMl/ranking/core/model/SearchEverywhereRankingModel;", "model", "Lcom/intellij/internal/ml/DecisionFunction;", "(Lcom/intellij/internal/ml/DecisionFunction;)V", "EPSILON", "", "MINIMUM_EM_WITH_EXTENSION_VALUE", "MINIMUM_EXACT_MATCH_VALUE", "simpleModel", "Lcom/intellij/searchEverywhereMl/ranking/core/model/SimpleSearchEverywhereRankingModel;", "isExactMatch", "", "features", "", "", "", "predict", "intellij.searchEverywhereMl.ranking.core"})
public final class ExactMatchSearchEverywhereRankingModel
extends SearchEverywhereRankingModel {
    private final double MINIMUM_EM_WITH_EXTENSION_VALUE;
    private final double MINIMUM_EXACT_MATCH_VALUE;
    private final double EPSILON;
    @NotNull
    private final SimpleSearchEverywhereRankingModel simpleModel;

    public ExactMatchSearchEverywhereRankingModel(@NotNull DecisionFunction model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2);
        this.MINIMUM_EM_WITH_EXTENSION_VALUE = 0.99;
        this.MINIMUM_EXACT_MATCH_VALUE = 0.9;
        this.EPSILON = 1.0E-5;
        this.simpleModel = new SimpleSearchEverywhereRankingModel(model2);
    }

    private final boolean isExactMatch(Map<String, ? extends Object> features2) {
        Object wordsInQuery = features2.getOrDefault("wholeTextWordsInQuery", (Object)0);
        Object wordsInElement = features2.getOrDefault("wholeTextWordsInElement", (Object)0);
        Object exactlyMatchedWords = features2.getOrDefault("wholeTextExactlyMatchedWords", (Object)0);
        Object levenshteinDistance = features2.getOrDefault("wholeTextLevenshteinDistanceCaseInsensitive", (Object)1.0);
        boolean allWordsMatch = Intrinsics.areEqual((Object)wordsInElement, (Object)wordsInQuery) && Intrinsics.areEqual((Object)wordsInElement, (Object)exactlyMatchedWords) && !Intrinsics.areEqual((Object)exactlyMatchedWords, (Object)0);
        return Intrinsics.areEqual((Object)wordsInQuery, (Object)1) ? Intrinsics.areEqual((Object)levenshteinDistance, (Object)0.0) : allWordsMatch;
    }

    @Override
    public double predict(@NotNull Map<String, ? extends Object> features2) {
        Intrinsics.checkNotNullParameter(features2, (String)"features");
        boolean isExactMatch2 = this.isExactMatch(features2);
        boolean isExtensionMatch = Intrinsics.areEqual((Object)features2.getOrDefault("fileTypeMatchesQuery", (Object)false), (Object)true);
        double mlPrediction = this.simpleModel.predict(features2);
        boolean isNameAndExtensionMatch = isExactMatch2 && isExtensionMatch;
        boolean isNameOnlyMatch = isExactMatch2 && !isExtensionMatch;
        return isNameAndExtensionMatch ? this.MINIMUM_EM_WITH_EXTENSION_VALUE + mlPrediction * (1.0 - this.MINIMUM_EM_WITH_EXTENSION_VALUE) : (isNameOnlyMatch ? this.MINIMUM_EXACT_MATCH_VALUE + mlPrediction * (this.MINIMUM_EM_WITH_EXTENSION_VALUE - this.MINIMUM_EXACT_MATCH_VALUE - this.EPSILON) : 0.0 + mlPrediction * (this.MINIMUM_EXACT_MATCH_VALUE - this.EPSILON));
    }
}

