/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.exception.ParseException;
import com.amazonaws.encryptionsdk.internal.EncryptionContextSerializer;
import com.amazonaws.encryptionsdk.internal.PrimitivesParser;
import com.amazonaws.encryptionsdk.model.CiphertextType;
import com.amazonaws.encryptionsdk.model.ContentType;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CiphertextHeaders {
    public static final int NO_MAX_ENCRYPTED_DATA_KEYS = 0;
    private static final SecureRandom RND = new SecureRandom();
    private byte version_ = (byte)-1;
    private byte typeVal_;
    private short cryptoAlgoVal_ = (short)-1;
    private byte[] messageId_;
    private int encryptionContextLen_ = -1;
    private byte[] encryptionContext_ = new byte[0];
    private int cipherKeyCount_ = -1;
    private List<KeyBlob> cipherKeyBlobs_;
    private byte contentTypeVal_ = (byte)-1;
    private int reservedField_ = -1;
    private short nonceLen_ = (short)-1;
    private int frameLength_ = -1;
    private byte[] headerNonce_;
    private byte[] headerTag_;
    private int suiteDataLen_ = -1;
    private byte[] suiteData_;
    private int currKeyBlobIndex_ = 0;
    private boolean isComplete_;
    private int maxEncryptedDataKeys_ = 0;

    public CiphertextHeaders() {
    }

    @Deprecated
    public CiphertextHeaders(byte version, CiphertextType type, CryptoAlgorithm cryptoAlgo, byte[] encryptionContext, List<KeyBlob> keyBlobs, ContentType contentType, int frameSize) {
        this(type, CiphertextHeaders.assertVersionCompatibility(version, cryptoAlgo), encryptionContext, keyBlobs, contentType, frameSize);
    }

    private static CryptoAlgorithm assertVersionCompatibility(byte version, CryptoAlgorithm cryptoAlgo) {
        if (version != cryptoAlgo.getMessageFormatVersion()) {
            throw new IllegalArgumentException("Version must match the message format version from the type");
        }
        return cryptoAlgo;
    }

    public CiphertextHeaders(CiphertextType type, CryptoAlgorithm cryptoAlgo, byte[] encryptionContext, List<KeyBlob> keyBlobs, ContentType contentType, int frameSize) {
        this.version_ = cryptoAlgo.getMessageFormatVersion();
        this.typeVal_ = type.getValue();
        this.cryptoAlgoVal_ = cryptoAlgo.getValue();
        this.encryptionContext_ = (byte[])encryptionContext.clone();
        if (this.encryptionContext_.length > 65535) {
            throw new AwsCryptoException("Size of encryption context exceeds the allowed maximum 65535");
        }
        this.encryptionContextLen_ = encryptionContext.length;
        this.cipherKeyCount_ = keyBlobs.size();
        this.cipherKeyBlobs_ = new ArrayList<KeyBlob>(keyBlobs);
        this.contentTypeVal_ = contentType.getValue();
        this.reservedField_ = 0;
        this.nonceLen_ = cryptoAlgo.getNonceLen();
        this.messageId_ = new byte[cryptoAlgo.getMessageIdLength()];
        RND.nextBytes(this.messageId_);
        this.frameLength_ = frameSize;
        this.isComplete_ = true;
    }

    public Boolean isComplete() {
        return this.isComplete_;
    }

    private int parseVersion(byte[] b, int off) throws ParseException {
        if (this.version_ >= 0) {
            return 0;
        }
        this.version_ = PrimitivesParser.parseByte(b, off);
        return 1;
    }

    private int configV1(byte[] b, int off) {
        this.suiteDataLen_ = -1;
        return 0;
    }

    private int configV2(byte[] b, int off) {
        this.suiteDataLen_ = this.getCryptoAlgoId().getSuiteDataLength();
        this.typeVal_ = CiphertextType.CUSTOMER_AUTHENTICATED_ENCRYPTED_DATA.getValue();
        this.headerNonce_ = this.getCryptoAlgoId().getHeaderNonce();
        if (this.headerNonce_ == null) {
            throw new IllegalStateException("Message format v2 requires the algorithm to specify a header nonce.");
        }
        if (this.headerNonce_.length > Short.MAX_VALUE) {
            throw new IllegalStateException("Message format v2 requires the algorithm to specify a header nonce with length less than 2^15.");
        }
        this.nonceLen_ = (short)this.headerNonce_.length;
        return 0;
    }

    private int parseType(byte[] b, int off) throws ParseException {
        if (this.typeVal_ != 0) {
            return 0;
        }
        this.typeVal_ = PrimitivesParser.parseByte(b, off);
        if (CiphertextType.deserialize(this.typeVal_) == null) {
            throw new BadCiphertextException("Invalid ciphertext type.");
        }
        return 1;
    }

    private int parseAlgoId(byte[] b, int off) throws ParseException {
        if (this.cryptoAlgoVal_ >= 0) {
            return 0;
        }
        this.cryptoAlgoVal_ = PrimitivesParser.parseShort(b, off);
        if (CryptoAlgorithm.deserialize(this.version_, this.cryptoAlgoVal_) == null) {
            throw new BadCiphertextException("Invalid algorithm identifier in ciphertext");
        }
        return 2;
    }

    private int parseMessageId(byte[] b, int off) throws ParseException {
        if (this.messageId_ != null) {
            return 0;
        }
        int len = b.length - off;
        int messageIdLen = this.getCryptoAlgoId().getMessageIdLength();
        if (len >= messageIdLen) {
            this.messageId_ = Arrays.copyOfRange(b, off, off + messageIdLen);
            return messageIdLen;
        }
        throw new ParseException("Not enough bytes to parse serial number");
    }

    private int parseSuiteData(byte[] b, int off) throws ParseException {
        if (this.suiteData_ != null) {
            return 0;
        }
        int len = b.length - off;
        if (len >= this.suiteDataLen_) {
            this.suiteData_ = Arrays.copyOfRange(b, off, off + this.suiteDataLen_);
            return this.suiteDataLen_;
        }
        throw new ParseException("Not enough bytes to parse suite specific data");
    }

    private int parseEncryptionContextLen(byte[] b, int off) throws ParseException {
        if (this.encryptionContextLen_ >= 0) {
            return 0;
        }
        this.encryptionContextLen_ = PrimitivesParser.parseUnsignedShort(b, off);
        if (this.encryptionContextLen_ < 0) {
            throw new BadCiphertextException("Invalid encryption context length in ciphertext");
        }
        return 2;
    }

    private int parseEncryptionContext(byte[] b, int off) throws ParseException {
        if (this.encryptionContextLen_ < this.encryptionContext_.length) {
            throw new IllegalStateException("Parsed encryption context is in an invalid state. Size exceeds parsed encryption context length.");
        }
        if (this.encryptionContextLen_ == this.encryptionContext_.length) {
            return 0;
        }
        int len = b.length - off;
        if (len >= this.encryptionContextLen_) {
            this.encryptionContext_ = Arrays.copyOfRange(b, off, off + this.encryptionContextLen_);
            return this.encryptionContextLen_;
        }
        throw new ParseException("Not enough bytes to parse encryption context");
    }

    private int parseEncryptedDataKeyCount(byte[] b, int off) throws ParseException {
        if (this.cipherKeyCount_ >= 0) {
            return 0;
        }
        this.cipherKeyCount_ = PrimitivesParser.parseUnsignedShort(b, off);
        if (this.cipherKeyCount_ < 0) {
            throw new BadCiphertextException("Invalid cipher key count in ciphertext");
        }
        if (this.maxEncryptedDataKeys_ > 0 && this.cipherKeyCount_ > this.maxEncryptedDataKeys_) {
            throw new AwsCryptoException("Ciphertext encrypted data keys exceed maxEncryptedDataKeys");
        }
        this.cipherKeyBlobs_ = Arrays.asList(new KeyBlob[this.cipherKeyCount_]);
        return 2;
    }

    private int parseEncryptedKeyBlobList(byte[] b, int off) throws PartialParseException {
        int parsedBytes = 0;
        try {
            if (this.cipherKeyCount_ > 0) {
                while (this.currKeyBlobIndex_ < this.cipherKeyCount_) {
                    if (this.cipherKeyBlobs_.get(this.currKeyBlobIndex_) == null) {
                        this.cipherKeyBlobs_.set(this.currKeyBlobIndex_, new KeyBlob());
                    }
                    if (!this.cipherKeyBlobs_.get(this.currKeyBlobIndex_).isComplete()) {
                        parsedBytes += this.parseEncryptedKeyBlob(b, off + parsedBytes);
                        if (!this.cipherKeyBlobs_.get(this.currKeyBlobIndex_).isComplete()) {
                            throw new ParseException("Not enough bytes to parse key blob");
                        }
                    }
                    ++this.currKeyBlobIndex_;
                }
            }
        }
        catch (ParseException ex) {
            throw new PartialParseException(ex, parsedBytes);
        }
        return parsedBytes;
    }

    private int parseEncryptedKeyBlob(byte[] b, int off) throws ParseException {
        return this.cipherKeyBlobs_.get(this.currKeyBlobIndex_).deserialize(b, off);
    }

    private int parseContentType(byte[] b, int off) throws ParseException {
        if (this.contentTypeVal_ >= 0) {
            return 0;
        }
        this.contentTypeVal_ = PrimitivesParser.parseByte(b, off);
        if (ContentType.deserialize(this.contentTypeVal_) == null) {
            throw new BadCiphertextException("Invalid content type in ciphertext.");
        }
        return 1;
    }

    private int parseReservedField(byte[] b, int off) throws ParseException {
        if (this.reservedField_ >= 0) {
            return 0;
        }
        this.reservedField_ = PrimitivesParser.parseInt(b, off);
        if (this.reservedField_ != 0) {
            throw new BadCiphertextException("Invalid value for reserved field in ciphertext");
        }
        return 4;
    }

    private int parseNonceLen(byte[] b, int off) throws ParseException {
        if (this.nonceLen_ >= 0) {
            return 0;
        }
        this.nonceLen_ = PrimitivesParser.parseByte(b, off);
        if (this.nonceLen_ < 0) {
            throw new BadCiphertextException("Invalid nonce length in ciphertext");
        }
        return 1;
    }

    private int parseFramePayloadLength(byte[] b, int off) throws ParseException {
        if (this.frameLength_ >= 0) {
            return 0;
        }
        this.frameLength_ = PrimitivesParser.parseInt(b, off);
        if (this.frameLength_ < 0) {
            throw new BadCiphertextException("Invalid frame length in ciphertext");
        }
        return 4;
    }

    private int parseHeaderNonce(byte[] b, int off) throws ParseException {
        if (this.nonceLen_ == 0 || this.headerNonce_ != null) {
            return 0;
        }
        int len = b.length - off;
        if (len >= this.nonceLen_) {
            this.headerNonce_ = Arrays.copyOfRange(b, off, off + this.nonceLen_);
            return this.nonceLen_;
        }
        throw new ParseException("Not enough bytes to parse header nonce");
    }

    private int parseHeaderTag(byte[] b, int off) throws ParseException {
        if (this.headerTag_ != null) {
            return 0;
        }
        int len = b.length - off;
        CryptoAlgorithm cryptoAlgo = CryptoAlgorithm.deserialize(this.version_, this.cryptoAlgoVal_);
        int tagLen = cryptoAlgo.getTagLen();
        if (len >= tagLen) {
            this.headerTag_ = Arrays.copyOfRange(b, off, off + tagLen);
            return tagLen;
        }
        throw new ParseException("Not enough bytes to parse header tag");
    }

    private int parseComplete(byte[] b, int off) throws ParseException {
        this.isComplete_ = true;
        return 0;
    }

    public int deserialize(byte[] b, int off) throws ParseException {
        return this.deserialize(b, off, 0);
    }

    public int deserialize(byte[] b, int off, int maxEncryptedDataKeys) throws ParseException {
        if (b == null) {
            return 0;
        }
        this.maxEncryptedDataKeys_ = maxEncryptedDataKeys;
        int parsedBytes = 0;
        try {
            ParsingStep[] steps;
            parsedBytes += this.parseVersion(b, off + parsedBytes);
            switch (this.version_) {
                case 1: {
                    steps = new ParsingStep[]{this::configV1, this::parseType, this::parseAlgoId, this::parseMessageId, this::parseEncryptionContextLen, this::parseEncryptionContext, this::parseEncryptedDataKeyCount, this::parseEncryptedKeyBlobList, this::parseContentType, this::parseReservedField, this::parseNonceLen, this::parseFramePayloadLength, this::parseHeaderNonce, this::parseHeaderTag, this::parseComplete};
                    break;
                }
                case 2: {
                    steps = new ParsingStep[]{this::parseAlgoId, this::configV2, this::parseMessageId, this::parseEncryptionContextLen, this::parseEncryptionContext, this::parseEncryptedDataKeyCount, this::parseEncryptedKeyBlobList, this::parseContentType, this::parseFramePayloadLength, this::parseSuiteData, this::parseHeaderTag, this::parseComplete};
                    break;
                }
                default: {
                    throw new BadCiphertextException("Invalid version");
                }
            }
            for (ParsingStep step : steps) {
                parsedBytes += step.parse(b, off + parsedBytes);
            }
        }
        catch (PartialParseException e) {
            parsedBytes += e.bytesParsed_;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedBytes;
    }

    public byte[] serializeAuthenticatedFields() {
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(outBytes);
            dataStream.writeByte(this.version_);
            if (this.version_ == 1) {
                dataStream.writeByte(this.typeVal_);
                dataStream.writeShort(this.cryptoAlgoVal_);
                dataStream.write(this.messageId_);
                PrimitivesParser.writeUnsignedShort(dataStream, this.encryptionContextLen_);
                if (this.encryptionContextLen_ > 0) {
                    dataStream.write(this.encryptionContext_);
                }
                dataStream.writeShort(this.cipherKeyCount_);
                for (int i = 0; i < this.cipherKeyCount_; ++i) {
                    byte[] cipherKeyBlobBytes = this.cipherKeyBlobs_.get(i).toByteArray();
                    dataStream.write(cipherKeyBlobBytes);
                }
                dataStream.writeByte(this.contentTypeVal_);
                dataStream.writeInt(this.reservedField_);
                dataStream.writeByte(this.nonceLen_);
                dataStream.writeInt(this.frameLength_);
            } else if (this.version_ == 2) {
                dataStream.writeShort(this.cryptoAlgoVal_);
                dataStream.write(this.messageId_);
                PrimitivesParser.writeUnsignedShort(dataStream, this.encryptionContextLen_);
                if (this.encryptionContextLen_ > 0) {
                    dataStream.write(this.encryptionContext_);
                }
                dataStream.writeShort(this.cipherKeyCount_);
                for (int i = 0; i < this.cipherKeyCount_; ++i) {
                    byte[] cipherKeyBlobBytes = this.cipherKeyBlobs_.get(i).toByteArray();
                    dataStream.write(cipherKeyBlobBytes);
                }
                dataStream.writeByte(this.contentTypeVal_);
                dataStream.writeInt(this.frameLength_);
                dataStream.write(this.suiteData_);
            } else {
                throw new IllegalArgumentException("Unsupported version: " + this.version_);
            }
            dataStream.close();
            return outBytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize cipher text headers", e);
        }
    }

    public byte[] toByteArray() {
        if (this.headerNonce_ == null || this.headerTag_ == null) {
            throw new AwsCryptoException("Header nonce and tag cannot be null.");
        }
        if (this.version_ == 2 && this.suiteData_ == null) {
            throw new AwsCryptoException("Suite Data cannot be null in the v2 message format.");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.serializeAuthenticatedFields());
            if (this.version_ == 1) {
                baos.write(this.headerNonce_);
            }
            baos.write(this.headerTag_);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new AwsCryptoException(ex);
        }
    }

    public byte getVersion() {
        return this.version_;
    }

    public CiphertextType getType() {
        return CiphertextType.deserialize(this.typeVal_);
    }

    public CryptoAlgorithm getCryptoAlgoId() {
        return CryptoAlgorithm.deserialize(this.version_, this.cryptoAlgoVal_);
    }

    public int getEncryptionContextLen() {
        return this.encryptionContextLen_;
    }

    public byte[] getEncryptionContext() {
        return (byte[])this.encryptionContext_.clone();
    }

    public Map<String, String> getEncryptionContextMap() {
        return EncryptionContextSerializer.deserialize(this.encryptionContext_);
    }

    public int getEncryptedKeyBlobCount() {
        return this.cipherKeyCount_;
    }

    public List<KeyBlob> getEncryptedKeyBlobs() {
        return new ArrayList<KeyBlob>(this.cipherKeyBlobs_);
    }

    public ContentType getContentType() {
        return ContentType.deserialize(this.contentTypeVal_);
    }

    public byte[] getMessageId() {
        return this.messageId_ != null ? (byte[])this.messageId_.clone() : null;
    }

    public short getNonceLength() {
        return this.nonceLen_;
    }

    public int getFrameLength() {
        return this.frameLength_;
    }

    public byte[] getHeaderNonce() {
        return this.headerNonce_ != null ? (byte[])this.headerNonce_.clone() : null;
    }

    public byte[] getHeaderTag() {
        return this.headerTag_ != null ? (byte[])this.headerTag_.clone() : null;
    }

    public void setHeaderNonce(byte[] headerNonce) {
        this.headerNonce_ = (byte[])headerNonce.clone();
    }

    public void setHeaderTag(byte[] headerTag) {
        this.headerTag_ = (byte[])headerTag.clone();
    }

    public byte[] getSuiteData() {
        return this.suiteData_ != null ? (byte[])this.suiteData_.clone() : null;
    }

    public void setSuiteData(byte[] suiteData) {
        this.suiteData_ = (byte[])suiteData.clone();
    }

    int getMaxEncryptedDataKeys() {
        return this.maxEncryptedDataKeys_;
    }

    @FunctionalInterface
    private static interface ParsingStep {
        public int parse(byte[] var1, int var2) throws ParseException, PartialParseException;
    }

    private static class PartialParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        final int bytesParsed_;

        private PartialParseException(Throwable ex, int bytesParsed) {
            super(ex);
            this.bytesParsed_ = bytesParsed;
        }
    }
}

