/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.io.Serializable;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jooq.ArrayComponentConverter;
import org.jooq.ArrayConverter;
import org.jooq.Converter;
import org.jooq.Internal;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractConverter;
import org.jooq.impl.IdentityConverter;

public class Converters<T, U>
extends AbstractConverter<T, U> {
    final Converter[] chain;

    @NotNull
    public static <T> Converter<T, T> identity(Class<T> type) {
        return new IdentityConverter<T>(type);
    }

    @Deprecated(forRemoval=true, since="3.14")
    @NotNull
    public static <T, U> Converter<T, U> of() {
        return new Converters<T, U>(new Converter[0]);
    }

    @Deprecated(forRemoval=true, since="3.14")
    @NotNull
    public static <T, U> Converter<T, U> of(Converter<T, U> converter) {
        return new Converters<T, U>(converter);
    }

    @NotNull
    public static <T, X1, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, U> c2) {
        return new Converters<T, U>(c1, c2);
    }

    @NotNull
    public static <T, X1, X2, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, ? extends X2> c2, Converter<? super X2, U> c3) {
        return new Converters<T, U>(c1, c2, c3);
    }

    @NotNull
    public static <T, X1, X2, X3, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, ? extends X2> c2, Converter<? super X2, ? extends X3> c3, Converter<? super X3, U> c4) {
        return new Converters<T, U>(c1, c2, c3, c4);
    }

    public static <T, U> Converter<U, T> inverse(Converter<T, U> converter) {
        if (converter instanceof IdentityConverter) {
            return converter;
        }
        return Converter.of(converter.toType(), converter.fromType(), converter::to, converter::from);
    }

    public static <T, U> Converter<T[], U[]> forArrays(Converter<T, U> converter) {
        if (converter instanceof ArrayComponentConverter) {
            return ((ArrayComponentConverter)converter).converter;
        }
        return new ArrayConverter<T, U>(converter);
    }

    public static <T, U> Converter<T, U> forArrayComponents(Converter<T[], U[]> converter) {
        if (converter instanceof ArrayConverter) {
            return ((ArrayConverter)converter).converter;
        }
        return new ArrayComponentConverter(converter);
    }

    Converters(Converter ... chain) {
        super(chain[0].fromType(), chain[chain.length - 1].toType());
        this.chain = chain;
    }

    @Override
    public final U from(T t) {
        Object result = t;
        for (int i = 0; i < this.chain.length; ++i) {
            result = this.chain[i].from(result);
        }
        return (U)result;
    }

    @Override
    public final T to(U u) {
        Object result = u;
        for (int i = this.chain.length - 1; i >= 0; --i) {
            result = this.chain[i].to(result);
        }
        return (T)result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String separator = " -> ";
        sb.append("Converters [ ");
        sb.append(this.fromType().getName());
        for (Converter converter : this.chain) {
            sb.append(separator);
            sb.append(converter.toType().getName());
        }
        sb.append(" ]");
        return sb.toString();
    }

    static final <T, U> Function<T, U> nullable(Function<? super T, ? extends U> f) {
        return f instanceof Serializable ? (Function<Object, Object> & Serializable)t -> t == null ? null : f.apply(t) : t -> t == null ? null : f.apply(t);
    }

    static final <T, U> Function<T, U> notImplemented() {
        return t -> {
            throw new DataTypeException("Conversion function not implemented");
        };
    }

    @Internal
    public static final class UnknownType {
        private UnknownType() {
        }
    }
}

