#
#       Searduino
#
#  Copyright (C) 2011, 2012 Henrik Sandklef      
#                                                                   
# This program is free software; you can redistribute it and/or     
# modify it under the terms of the GNU General Public License       
# as published by the Free Software Foundation; either version 3    
# of the License, or any later version.                             
#                                                                   
#                                                                   
# This program is distributed in the hope that it will be useful,   
# but WITHOUT ANY WARRANTY; without even the implied warranty of    
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
# GNU General Public License for more details.                      
#                                                                   
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software       
# Foundation, Inc., 51 Franklin Street, Boston,            
# MA  02110-1301, USA.                                              
#
#

ifndef ARDUINO
$(error Variables not set correctly ARDUINO='${ARDUINO}')
endif		

#
# Searduino version
# 
SEARDUINO_VERSION=6500
SEARDUINO_VERSION_STRING=0.65

SEARDUINO_VERSION_MAJOR=0
SEARDUINO_VERSION_MINOR=65
SEARDUINO_VERSION_PREPARE=

REQUESTED_SEARDUINO_VERSION_MAJOR=$(shell echo $(REQUESTED_SEARDUINO_VERSION) | sed 's,\([0-9]*\)\.[0-9]*,\1,g')
REQUESTED_SEARDUINO_VERSION_MINOR=$(shell echo $(REQUESTED_SEARDUINO_VERSION) | sed 's,[0-9]*\.\([0-9]*\),\1,g')
REQUESTED_SEARDUINO_VERSION_TOTAL=$(shell echo $(REQUESTED_SEARDUINO_VERSION_MAJOR)\*10000+$(REQUESTED_SEARDUINO_VERSION_MINOR)\*100 | bc)

#
#
#
ifdef REQUESTED_SEARDUINO_VERSION

  VERSION_OK := $(shell [ $(REQUESTED_SEARDUINO_VERSION_TOTAL) -gt  $(SEARDUINO_VERSION) ] && echo true)

  ifeq ($(VERSION_OK),true)    
     $(error "You've requested version ${REQUESTED_SEARDUINO_VERSION_MAJOR}.${REQUESTED_SEARDUINO_VERSION_MINOR} of Searudino and ${SEARDUINO_VERSION_STRING} is installed")
  endif

endif

UNAME := $(shell uname -s)

ARDUINO_VERSION=100

#
# Under cygwin, we need to add "C:\\cygwin" to the path
#   .... we're assuming cygwin has been installed to 
#   the default installation dir
#
CYGWIN=true
ROOT_PATH=
ifeq (${CYGWIN},true)
  ROOT_PATH=C:\\\\cygwin
endif


SEARDUINO_MK_PATH=$(ROOT_PATH)/opt/searduino/share/searduino/
SEARDUINO_INC_PATH=$(ROOT_PATH)/opt/searduino/include/searduino/

ifeq (${ARDUINO},stub)
include $(SEARDUINO_MK_PATH)/mk/searduino-stub.mk
else
include $(SEARDUINO_MK_PATH)/mk/searduino-arduino.mk
endif

SEARDUINO_LIB_PATH=-L$(ROOT_PATH)/opt/searduino/libs/searduino/arduino-libs/$(BOARD) -L$(ROOT_PATH)/opt/searduino/lib

include $(SEARDUINO_MK_PATH)/mk/searduino-functions.mk
