class Weapon:
    chance_base = 0
    chance_add = tuple()
    chance_sub = tuple()

    damage_base = 0
    damage_add = tuple()
    damage_sub = tuple()

    def __init__(self, creature):
        self.creature = creature

    def chance_against(self, other):
        chance = self.chance_base

        for adder in self.chance_add:
            who, attr = adder.split('_')
            if who == 'my':
                add = getattr(self.creature, attr)
                chance += add
            elif who == 'his':
                add = getattr(other, attr)
                chance += add

        for subber in self.chance_sub:
            who, attr = adder.split('_')
            if who == 'my':
                sub = getattr(self.creature, attr)
                chance -= sub
            elif who == 'his':
                sub = getattr(other, attr)
                chance -= sub

        chance += other.armor.adjust_chance(self)

        return max(1, chance)

    def damage_against(self, other):
        damage = self.damage_base

        for adder in self.damage_add:
            who, attr = adder.split('_')
            if who == 'my':
                add = getattr(self.creature, attr)
                damage += add
            elif who == 'his':
                add = getattr(other, attr)
                damage += add

        for subber in self.damage_sub:
            who, attr = adder.split('_')
            if who == 'my':
                sub = getattr(self.creature, attr)
                damage -= sub
            elif who == 'his':
                sub = getattr(other, attr)
                damage -= sub

        damage += other.armor.adjust_damage(self)

        return max(1, damage)


class Fist(Weapon):
    chance_base = 20
    chance_add = 'my_dex',
    chance_sub = 'his_dex',

    damage_base = 2
    damage_add = 'my_str',
    damage_sub = 'his_dex',


class Dagger(Weapon):
    chance_base = 15
    chance_add = 'my_dex', 'my_wis'
    chance_sub = 'his_dex',

    damage_base = 6
    damage_add = 'my_str', 'my_int'
    damage_sub = 'his_dex',



class Armor:
    chance_adjust = 0
    damage_adjust = 0

    chances = {}
    damages = {}

    def adjust_chance(self, weapon):
        chance = self.chance_adjust

        t = type(weapon)
        if t in self.chances.keys():
            chance += self.chances[t]

        return chance

    def adjust_damage(self, weapon):
        damage = self.damage_adjust

        t = type(weapon)
        if t in self.damages.keys():
            damage += self.damages[t]

        return damage


class Leather(Armor):
    chance_adjust = -1
    damage_adjust = -1

    chances = {Fist: -1,
                Dagger: -1,
    }
    damages = {
                Dagger: 1,
    }


class Chain(Armor):
    chance_adjust = -3
    damage_adjust = -3

    chances = {Fist: -5,
    }
    damages = {Fist: 1,
                Dagger: -1,
    }


