/************************************************************************\
 * Magic Square solves magic squares.                                   *
 * Copyright (C) 2019  Asher Gordon <AsDaGo@posteo.net>                 *
 *                                                                      *
 * This file is part of Magic Square.                                   *
 *                                                                      *
 * Magic Square is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * Magic Square is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with Magic Square.  If not, see                                *
 * <https://www.gnu.org/licenses/>.                                     *
\************************************************************************/

/* debug.c -- print debugging message when we receive a signal that
   indicates a bug */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include "debug.h"
#include "sig2str.h"

/* Which signals to print a debug message on */
const int debug_signals[DEBUG_SIGNALS_ENTRIES] =
  {SIGABRT, SIGBUS, SIGFPE, SIGILL, SIGSEGV, SIGSTKFLT, SIGSYS};

/* Print a debuging message and exit() */
void __attribute__((__noreturn__)) debug_abort (int signum) {
  char signame[SIG2STR_MAX];

  if (sig2str(signum, signame)) {
    fprintf(stderr, "Terminated by unknown signal (%d) %s\n\n",
	    signum, strsignal(signum));
  }
  else {
    fprintf(stderr, "Terminated by SIG%s (%d) %s\n\n",
	    signame, signum, strsignal(signum));
  }

  fputs("You've found a bug in " PACKAGE_NAME "!\n"
	"Please report it to <" PACKAGE_BUGREPORT ">.\n",
	stderr);

  exit(-signum);
}
