<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

/**
* XFMail is currently a simple abstraction for mail()
* @package lbbackend
*/
class XFMail {

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * send an e-mail
  * @param array $args input data for mail: 'to', 'subject', 'message' and 'simulate'
  * @return mixed
  * @since 1.0.0
  */
  public static function send($args){
    if ( !isset($args['to']) || strlen($args['to']) < 6 )
    return 'NO_RECIPIENT';
    if ( !isset($args['message']) || strlen($args['message']) < 8 )
    return 'NO_MESSAGE';
    if ( !isset($args['subject']) || strlen($args['subject']) < 8 )
    $args['subject'] = XF::get_cfg('main_title');
  $args['subject'] = XF::sanitize_var($args['subject'],'str','stripspaces');
  $eol = chr(13).chr(10);
  $header  = 'From: "'.XF::get_cfg('mail_from_name').'" <'.XF::get_cfg('mail_from_mail').'>'.$eol;
  $header .= 'Content-Type: text/plain; charset=utf-8';
  $m = ( isset($args['simulate']) )
  ? true
  : mail($args['to'],$args['subject'],$args['message'],$header);
  $l = ( $m ) ? 'info' : 'error';
  XF::logger($l,'sub','mail','to',$args['to'],'subject',$args['subject'],'msghash',sha1($args['message']),'success',XF::bool2yn($m));
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,XF::arr2str($args));
  return $m;
  }

}
?>