<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "my";
include "inc/header.inc.php";


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');


$file->user_id = $me['user_id'];

//images
$image_type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$image_type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$image_type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif


if (isset($_REQUEST['file_id'])) {
	$file_id = $_REQUEST['file_id'];
	$file->file_id = $file_id;
	$output_file = $file->getFileRecord();
	
	if (isset($output_file)) {
		if ($output_file['user_id'] != $me['user_id']) { // check that the file is mine
			header("Location: fil_view.php?" . strip_tags(SID));
			exit;
		}
		
		//either send it to the template (image) or open the file
		foreach($image_type_ids as $ft): 
			if ($output_file['file_suffix'] == $ft) {
				$output_image = $output_file;
			}
		endforeach;
		
		if (!isset($output_image)) {
			foreach($c_node['file']['mime'] as $key => $i):
				if ($output_file['file_suffix'] == $i['suffix']) {
					header("Content-type: " . $c_node['file']['mime'][$key]['mime']);
					break;
				}
			endforeach;
		}
	
		
		
	
		if (empty($output_image)) {
		    if (!@readfile($c_node['dir']['asset_path'] . $output_file['file'])) {
		        echo $lang['err_no_file_downloaded'];
		    }
			exit;
		}
	}
}


$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->orderby = "file_title";


$output_files = $file->getFiles();


//get images out of files output
if (isset($output_files)) {
	foreach($output_files as $key => $i): 
		foreach($image_type_ids as $ft): 
			if ($i['file_suffix'] == $ft) {
				$output_images[] = $output_files[$key];
				unset($output_files[$key]);
			}
		endforeach;
	endforeach;
}


//storage
$output_storage = $file->getAllocation();

if (isset($output_storage['allocation'])) {
	$percentage_used = floor((100/$output_storage['allocation']) * $output_storage['allocation_used']);
	if ($percentage_used > 100) {
	    $percentage_used = 100;
	}
	$percentage_unused = 100 - $percentage_used;
}


// MOVE TO TEMPLATE --------------------------------------------------------
if ($output_storage['allocation'] > $output_storage['allocation_used']) {
	$body->set('allow_file_add', 1);		
}

if (!empty($output_files)) {
    $body->set('files', $output_files);
}

if (!empty($output_images)) {
    $body->set('images', $output_images);
}

if (!empty($output_image)) {
    $body->set('image', $output_image);
}

if (!empty($image_type_ids)) {
    $body->set('image_type_ids', $image_type_ids);
}

if (!empty($output_storage)) {
    $body->set('storage', $output_storage);
}

if (!empty($percentage_used)) {
    $body->set('percentage_used', $percentage_used);
}

if (!empty($percentage_unused)) {
    $body->set('percentage_unused', $percentage_unused);
}

if (isset($display)) {
    $body->set('display', $display);
}

include "inc/footer.inc.php";

?>
