% FUNCTION [...] = gf_levelset_get(levelset LS, [operation [, args]])
%
%   General function for querying information about LEVELSET objects.
%   
%
%   * V = gf_levelset_get(levelset LS, 'values', int nls)
%   Return the vector of dof for `nls` funtion.
%   
%   If `nls` is 0, the method return the vector of dof for the primary
%   level-set funtion. If `nls` is 1, the method return the vector of
%   dof for the secondary level-set function (if any).
%
%   * d = gf_levelset_get(levelset LS, 'degree')
%   Return the degree of lagrange representation.
%
%   * mf = gf_levelset_get(levelset LS, 'mf')
%   Return a reference on the mesh_fem object.
%
%   * z = gf_levelset_get(levelset LS, 'memsize')
%   Return the amount of memory (in bytes) used by the level-set.
%
%   * s = gf_levelset_get(levelset LS, 'char')
%   Output a (unique) string representation of the levelset.
%   
%   This can be used to perform comparisons between two
%   different levelset objects.
%   This function is to be completed.
%   
%
%   * gf_levelset_get(levelset LS, 'display')
%   displays a short summary for a levelset.
%
%
function [varargout]=gf_levelset_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('levelset_get', varargin{:});
  else
    gf_matlab('levelset_get', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
