<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// sql-funktionen fr mysql, postgresql und sqlite
if(!isset($conf["sql_typ"])) include("./config.php"); // $conf-variablen mit den sql-einstellungen

$sqliteerror = "";

function dbfehler()
{
  global $conf, $link, $sqliteerror;
  // ziel: fehlermeldung ausgeben, falls was schiefgelaufen ist
  // return: nichts
  $errstr = "Es ist ein Fehler bei einem SQL-Query aufgetreten!<br />";
  if($conf["sql_typ"] == "mysql")
  {
    $errstr .= "MySQL-Fehler: ".mysql_error($link);
  }
  if($conf["sql_typ"] == "postgresql")
  {
    $errstr .= "PostgreSQL-Fehler: ".pg_last_error($link);
  }
  if($conf["sql_typ"] == "sqlite")
  {
    $errstr .= "SQLite-Fehler: ".$sqliteerror;
  }
  fehler($errstr);
}

function sql_connect()
{
  global $conf, $sqliteerror;
  // ziel: verbindung zum sql-server herstellen und datenbank auswhlen
  // return: $link (verbindungs-ressource)
  if($conf["sql_typ"] == "mysql")
  {
    $link = mysql_connect($conf["sql_host"].":".$conf["sql_port"], $conf["sql_username"], $conf["sql_passwort"]) or dbfehler();
    mysql_select_db($conf["sql_datenbank"], $link) or dbfehler();
  }
  if($conf["sql_typ"] == "postgresql")
  {
    $link = pg_connect("host=".$conf["sql_host"]." port=".$conf["sql_port"]." dbname=".$conf["sql_datenbank"]." user=".$conf["sql_username"]." password=".$conf["sql_passwort"]) or dbfehler();
  }
  if($conf["sql_typ"] == "sqlite")
  {
    $link = sqlite_open($conf["sql_datenbank"], 06666, $sqliteerror) or dbfehler();
  }
  return $link;
}

function sql_createtable($name, $spalten)
{
  global $conf, $link;
  // ziel: tabellen erstellen
  // return: nichts
  if($conf["sql_typ"] == "mysql")
  {
    $sql = "CREATE TABLE ".$conf["sql_prefix"]."_".$name." (";
    foreach($spalten as $spalte => $optionen)
    {
      if(substr($spalte, 0, 3) != "KEY")
      {
        $sql .= $spalte." ".$optionen["typ"];
        switch ($optionen["typ"])
        {
          case "bigint":
          case "tinyint":
          case "smallint":
          case "varchar":
            $sql .= "(".$optionen["size"].") ";
            if($optionen["unsigned"] == true)  $sql .= "UNSIGNED ";
            if($optionen["NULL"]     == false) $sql .= "NOT NULL ";
            if($optionen["auto"]     == true)  $sql .= "AUTO_INCREMENT ";
            if(isset($optionen["default"]))    $sql .= "DEFAULT ".$optionen["default"]." ";
        }
      }
      else
      {
        $sql .= $optionen["typ"]." KEY (".$optionen["spalte"].")";
      }
      $sql .= ", ";
    }
    $sql = substr($sql, 0, -2); // letztes komma entfernen
    $sql .= ") Type=MyISAM;";
    mysql_query($sql, $link) or dbfehler();
  }
  if($conf["sql_typ"] == "postgresql")
  {
    $sql = "CREATE TABLE ".$conf["sql_prefix"]."_".$name." (";
    foreach($spalten as $spalte => $optionen)
    {
      if($optionen["typ"] == "tinyint") $optionen["typ"] = "smallint"; // pgsql hat keinen tinyint-typ
      if(substr($spalte, 0, 3) != "KEY")
      {
        if($optionen["auto"] == true)
        {
          if($optionen["typ"] == "bigint") $optionen["typ"] = "bigserial";
        }
        $sql .= $spalte." ".$optionen["typ"];
        if(isset($optionen["size"]) and $optionen["typ"] == "varchar") $sql .= "(".$optionen["size"].")"; // keine size-angaben fr integers und text
        if($optionen["NULL"] == false)  $sql .= " NOT NULL";
        if(isset($optionen["default"])) $sql .= " DEFAULT ".$optionen["default"]." ";
        $sql .= ", ";
      }
      elseif($optionen["typ"] == "PRIMARY")
      {
        $sql .= " PRIMARY KEY (".$optionen["spalte"]."), ";
      }
    }
    $sql = substr($sql, 0, -2); // letztes komma entfernen
    $sql .= ");";
    pg_query($link, $sql) or dbfehler();
  }
  if($conf["sql_typ"] == "sqlite")
  {
    $sql = "CREATE TABLE ".$conf["sql_prefix"]."_".$name." (";
    foreach($spalten as $spalte => $optionen)
    {
      if(substr($spalte, 0, 3) != "KEY")
      {
        $sql .= $spalte;
        if($optionen["typ"] == "tinyint" or $optionen["typ"] == "smallint" or $optionen["typ"] == "bigint" or $optionen["typ"] == "int") $optionen["typ"] = "INTEGER"; // sqlite kennt nur allgemein den "INTEGER"-Typ
        if($optionen["typ"] == "text" or $optionen["typ"] == "varchar") $optionen["typ"] == "TEXT"; // sqlite kennt nur allgemein den "TEXT"-Typ
        $sql .= " ".$optionen["typ"]." ";
        if($optionen["auto"] == true)  $sql .= "AUTOINCREMENT ";
        if($optionen["NULL"] == false) $sql .= "NOT NULL ";
        if(isset($optionen["default"]) and substr($optionen["default"], 0, 1) != "'") $optionen["default"] = "'".$optionen["default"]."'";
        if(isset($optionen["default"])) $sql .= "DEFAULT ".$optionen["default"]." ";
        
        
        //if(is_string($optionen["default"])) $sql .= " DEFAULT ".$optionen["default"].", ";
        //if(is_numeric($optionen["default"])) $sql .= " DEFAULT ".$optionen["default"].", ";
        //if($optionen["default"] == NULL and $optionen["NULL"] == true)  $sql .= " DEFAULT NULL, ";
        //if($optionen["default"] == NULL and $optionen["NULL"] == false) $sql .= ", ";
        $sql = substr($sql, 0, -1).", ";
      }
      elseif($optionen["typ"] == "PRIMARY")
      {
        $sql .= "PRIMARY KEY (".$optionen["spalte"]."), ";
      }
    }
    $sql = substr($sql, 0, -2); // letztes komma entfernen
    $sql .= ");";
    echo $sql;
    sqlite_query($link, $sql) or dbfehler();
  }
}

function sql_insert($tabelle, $werte)
{
  global $conf, $link;
  // ziel: zeilen in tabellen einfgen
  // return: nichts
  $sql = "INSERT INTO ".$conf["sql_prefix"]."_".$tabelle." (";
  foreach($werte as $spalte => $wert)
  {
    $sql .= $spalte.", ";
  }
  $sql = substr($sql, 0, -2); // letztes komma entfernen
  $sql .= ") VALUES (";
  foreach($werte as $wert)
  {
    if(is_string($wert))
    {
      if($conf["sql_typ"] == "mysql") $sql .= "'".mysql_real_escape_string($wert, $link)."', ";
      if($conf["sql_typ"] == "postgresql") $sql .= "'".pg_escape_string($wert)."', ";
	  if($conf["sql_typ"] == "sqlite") $sql .= "'".sqlite_escape_string($wert)."', ";
    }
    if(is_null($wert))
    {
      $sql .= "NULL, ";
    }
    if(!is_string($wert) and !is_null($wert))
    {
      $sql .= $wert.", ";
    }
  }
  $sql = substr($sql, 0, -2); // letztes komma entfernen
  $sql .= ");";

  if($conf["sql_typ"] == "mysql")
  {
    mysql_query($sql, $link) or dbfehler();
  }
  if($conf["sql_typ"] == "postgresql")
  {
    pg_query($link, $sql) or dbfehler();
  }
  if($conf["sql_typ"] == "sqlite")
  {
    sqlite_query($sql, $link) or dbfehler();
  }
}

function sql_close()
{
  global $conf, $link;
  // ziel: verbindung mit sql-server beenden
  // return: nichts
  if($conf["sql_typ"] == "mysql") mysql_close($link) or dbfehler();
  if($conf["sql_typ"] == "postgresql") pg_close($link) or dbfehler();
  if($conf["sql_typ"] == "sqlite") sqlite_close($link) or dbfehler();
}

function sql_select($was, $table, $extra, $offset = NULL, $count = NULL)
{
  global $conf, $link;
  // ziel: select-query senden
  // return: $result (ergebnis-ressource)
  $sql = "SELECT ".$was." FROM ".$conf["sql_prefix"]."_".$table." ".$extra;
  if($conf["sql_typ"] == "mysql")
  {
    if(isset($offset) or isset($offset))
    {
      $addlimit = " LIMIT ";
      if(isset($offset)) $addlimit .= $offset.", ";
      if(isset($count)) $addlimit .= $count;
      $sql .= $addlimit;
    }
    $result = mysql_query($sql, $link) or dbfehler();
  }
  if($conf["sql_typ"] == "sqlite")
  {
    if(isset($offset) or isset($offset))
    {
      $addlimit = " LIMIT ";
      if(isset($offset)) $addlimit .= $offset.", ";
      if(isset($count)) $addlimit .= $count;
      $sql .= $addlimit;
    }
    $result = sqlite_query($sql, $link) or dbfehler();
  }
  if($conf["sql_typ"] == "postgresql")
  {
    if(isset($count) or isset($offset))
    {
      $addlimit = " ";
      if(isset($count)) $addlimit .= "LIMIT ".$count." ";
      if(isset($offset)) $addlimit .= "OFFSET ".$offset;
      $sql .= $addlimit;
    }
    $result = pg_query($link, $sql) or dbfehler();
  }
  return $result;
}

function sql_fetch_assoc($result)
{
  global $conf;
  // ziel: array mit den werten einer zeile aus dem result holen
  // return: $ergebnis (array)
  if($conf["sql_typ"] == "mysql") $ergebnis = mysql_fetch_assoc($result);
  if($conf["sql_typ"] == "postgresql") $ergebnis = pg_fetch_array($result);
  if($conf["sql_typ"] == "sqlite") $ergebnis = sqlite_fetch_array($result, SQLITE_ASSOC);
  return $ergebnis;
}

function sql_free_result($result)
{
  global $conf, $link;
  // ziel: speicher freigeben
  // return: nichts
  if($conf["sql_typ"] == "mysql") mysql_free_result($result);
  if($conf["sql_typ"] == "postgresql") pg_free_result($result);
  //bei sqlite einfach nichts tun
}

function sql_num_rows($result)
{
  global $conf, $link;
  // ziel: die zeilen eines select-results zhlen
  // return: $rows (integer)
  if($conf["sql_typ"] == "mysql") $rows = mysql_num_rows($result);
  if($conf["sql_typ"] == "postgresql") $rows = pg_num_rows($result);
  if($conf["sql_typ"] == "sqlite") $rows = sqlite_num_rows($result);
  return $rows;
}

function sql_update($table, $werte, $extra)
{
  global $conf, $link;
  // ziel: werte von zeilen aktualisieren
  // return: nichts
  $sql = "UPDATE ".$conf["sql_prefix"]."_".$table." SET ";
  foreach($werte as $spalte => $wert)
  {
    if(is_string($wert))
    {
      if($conf["sql_typ"] == "mysql") $wert = "'".mysql_real_escape_string($wert, $link)."'";
      if($conf["sql_typ"] == "postgresql") $wert = "'".pg_escape_string($wert)."'";
      if($conf["sql_typ"] == "sqlite") $wert = "'".sqlite_escape_string($wert)."'";
    }
    $sql .= $spalte."=".$wert.", ";
  }
  $sql = substr($sql, 0, -2); // letztes komma entfernen
  $sql .= " ".$extra;
  if($conf["sql_typ"] == "mysql") mysql_query($sql, $link) or dbfehler();
  if($conf["sql_typ"] == "postgresql") pg_query($link, $sql) or dbfehler();
  if($conf["sql_typ"] == "sqlite") sqlite_query($sql, $link) or dbfehler();
}

function sql_delete($table, $where)
{
  global $conf, $link;
  // ziel: zeile(n) aus einer tabelle lschen
  // return: nichts
  $sql = "DELETE FROM ".$conf["sql_prefix"]."_".$table." ".$where;
  if($conf["sql_typ"] == "mysql") mysql_query($sql, $link) or dbfehler();
  if($conf["sql_typ"] == "postgresql") pg_query($link, $sql) or dbfehler();
  if($conf["sql_typ"] == "sqlite") sqlite_query($sql, $link) or dbfehler();
}
?>
