<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["mailbox"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
?>
<table class="maintable" width="100%">
<tr>
<td class="leftnav">
    <a href="index.php?action=mailbox&amp;show=inbox">Inbox</a><br />
    <a href="index.php?action=mailbox&amp;show=outbox">Outbox</a><br />
    <a href="index.php?action=mailbox&amp;show=neu&amp;type=neu">Neu</a><br />
</td>
<td align="center">

<?php
//*********************************** mailbox **********************************
if(!isset($_GET["show"]))
{
  $result = sql_select("*", "mailbox", "WHERE empfnger=".$user["id"]." AND gelesen=0", NULL, NULL);
  $neue = sql_num_rows($result);
  ?>
  <h3>Mailbox</h3>
  <p>Es gibt <b><?php echo $neue ?></b> neue Nachricht(en).</p>
  <?php
}
else
{
  //************************************ inbox ***********************************
  if($_GET["show"]=="inbox")
  {
    ?>
    <h3>Inbox</h3>
    <table class="maintable" width="80%">
    <tr class="rowberschrift">
      <td><b>ID</b></td>
      <td><b>Titel</b></td>
      <td><b>Absender</b></td>
      <td><b>gesendet am</b></td>
    </tr>
    <?php
    // alle nachrichten holen
    $result = sql_select("*", "mailbox", "WHERE empfnger='".$user["id"]."' AND gelscht!=1 ORDER BY id DESC", NULL, NULL);

    $zeile=2;
    while ($ergebnis=sql_fetch_assoc($result))
    {
      // namen des absenders herausfinden
      $userresult = sql_select("*", "users", "WHERE id=".$ergebnis["absender"], NULL, NULL);
      $userergebnis = sql_fetch_assoc($userresult);

      echo "<tr class=\"row$zeile\">\n";
      ?>
      <td class="liste"><?php echo $ergebnis["id"] ?></td>
      <?php
      if ($ergebnis["gelesen"]==0)
      {
        //nachricht wurde noch nicht gelesen
        ?>
        <td class="liste"><a href="index.php?action=mailbox&amp;show=readmsg&amp;box=in&amp;msg=<?php echo $ergebnis["id"] ?>"><b><?php echo $ergebnis["titel"] ?></b></a></td>
        <?php
      }
      if ($ergebnis["gelesen"]==1)
      {
        //nachricht wurde schon gelesen
        ?>
        <td class="liste"><a href="index.php?action=mailbox&amp;show=readmsg&amp;box=in&amp;msg=<?php echo $ergebnis["id"] ?>"><?php echo $ergebnis["titel"] ?></a></td>
        <?php
      }
      ?>
      <td class="liste"><?php if($rechte["memberlist"] == true) { ?><a href="index.php?action=userinfo&amp;id=<?php echo $ergebnis["absender"] ?>"><?php } echo htmlspecialchars($userergebnis["username"]); if($rechte["memberlist"] == true) { ?></a></td><?php } ?>
      <td class="liste"><?php echo date("d.m.Y", $ergebnis["created"] + $zeitoffset) ?> - <?php echo date("H:i:s", $ergebnis["created"] + $zeitoffset) ?></td>
      </tr>
      <?php
      $zeile++;
      if ($zeile>2) $zeile=1;
    }
    ?>
    </table>
    <?php
  } // ende-inbox

  //********************************* outbox *************************************
  if($_GET["show"]=="outbox")
  {
    ?>
    <h3>Outbox</h3>
    <table class="maintable" width="80%">
    <tr class="rowberschrift">
      <td><b>ID</b></td>
      <td><b>Titel</b></td>
      <td><b>Empfnger</b></td>
      <td><b>gesendet am</b></td>
      <td><b>gelesen</b></td>
    </tr>
    <?php
    // alle nachrichten holen
    $result = sql_select("*", "mailbox", "WHERE absender='".$user["id"]."' AND gelscht!=2 ORDER BY id DESC", NULL, NULL);

    $zeile=2;
    while ($ergebnis=sql_fetch_assoc($result))
    {
      // namen des empfngers herausfinden
      $userresult = sql_select("*", "users", "WHERE id=".$ergebnis["empfnger"], NULL, NULL);
      $userergebnis = sql_fetch_assoc($userresult);

      echo "<tr class=\"row$zeile\">\n";
      ?>
      <td class="liste"><?php echo $ergebnis["id"] ?></td>
      <td class="liste"><a href="index.php?action=mailbox&amp;show=readmsg&amp;box=out&amp;msg=<?php echo $ergebnis["id"] ?>"><?php echo $ergebnis["titel"] ?></a></td>
      <td class="liste"><?php if($rechte["memberlist"] == true) { ?><a href="index.php?action=userinfo&amp;id=<?php echo $ergebnis["empfnger"] ?>"><?php } echo htmlspecialchars($userergebnis["username"]); if($rechte["memberlist"] == true) { ?></a><?php } ?></td>
      <td class="liste"><?php echo date("d.m.Y", $ergebnis["created"] + $zeitoffset) ?> - <?php echo date("H:i:s", $ergebnis["created"] + $zeitoffset) ?></td>
      <td class="liste"><?php if($ergebnis["gelesen"]==1) { echo "Ja"; } else { echo "Nein"; } ?></td>
      </tr>
      <?php
      $zeile++;
      if ($zeile>2) $zeile=1;
    }
    ?>
    </table>
    <?php
  } // ende-outbox

  //********************************* readmsg ************************************
  if($_GET["show"]=="readmsg")
  {
    // nachricht abrufen
    $result = sql_select("*", "mailbox", "WHERE id=".$_GET["msg"], NULL, NULL);
    $ergebnis = sql_fetch_assoc($result);
    if($user["id"]!=$ergebnis["empfnger"] and $user["id"]!=$ergebnis["absender"]) fehler("Sie besitzen nicht die ntigen Zugriffsrechte!");

    // namen des absenders herausfinden
    $absresult = sql_select("*", "users", "WHERE id=".$ergebnis["absender"], NULL, NULL);
    $absergebnis = sql_fetch_assoc($absresult);
    $empfresult = sql_select("*", "users", "WHERE id=".$ergebnis["empfnger"], NULL, NULL);
    $empfergebnis = sql_fetch_assoc($empfresult);

    // BB-Code-Parser laden
    include("./bbcode_parser.php");
    $parser = new HTML_BBCodeParser;

    // Smilie-Parser
    include("./smilie_parser.php");
    ?>
    <h3>Nachricht lesen</h3>
    <table class="maintable" width="80%">
    <tr class="rowberschrift">
      <td align="left"><b>Titel: <?php echo $ergebnis["titel"] ?></b></td>
      <td align="right">gesendet am <?php echo date("d.m.Y", $ergebnis["created"] + $zeitoffset) ?> - <?php echo date("H:i:s", $ergebnis["created"] + $zeitoffset) ?> von <?php if($rechte["memberlist"] == true) { ?><a class="berschriftlink" href="index.php?action=userinfo&amp;id=<?php echo $ergebnis["absender"] ?>"><?php } ?><b><?php echo htmlspecialchars($absergebnis["username"]) ?></b><?php if($rechte["memberlist"] == true) { ?></a><?php } ?> an <?php if($rechte["memberlist"] == true) { ?><a class="berschriftlink" href="index.php?action=userinfo&amp;id=<?php echo $ergebnis["empfnger"] ?>"><?php } ?><b><?php echo htmlspecialchars($empfergebnis["username"]) ?></b><?php if($rechte["memberlist"] == true) { ?></a><?php } ?></td>
    </tr>
    <tr class="row2">
      <td colspan="2">
      <?php
      if($ergebnis["bbcode"] == 1)
      {
        $parser->setText($ergebnis["nachricht"]);
        $parser->parse();
        $nachricht = $parser->getParsed();
      }
      else
      {
        $nachricht = $ergebnis["nachricht"];
      }
      if($ergebnis["smilies"] == 1)
      {
        $nachricht = parse_smilies($nachricht);
      }
      echo str_replace("\n", "<br />\n", $nachricht);

      // signatur?
      if($ergebnis["signatur"] == 1)
      {
        if($absergebnis["sig_bbcode"] == 1)
        {
          $parser->setText($absergebnis["signatur"]);
          $parser->parse();
          $signatur = $parser->getParsed();
        }
        else
        {
          $signatur = $absergebnis["signatur"];
        }
        if($absergebnis["sig_smilies"] == 1)
        {
          $signatur = parse_smilies($signatur);
        }
        echo str_replace("\n", "<br />\n", "\n___________________\n".$signatur);
      }
      ?></td>
    </tr>
    <tr class="rowberschrift">
      <td align="left"></td>
      <td align="right">
      <a class="berschriftlink" href="index.php?action=mailbox&amp;show=delete&amp;msg=<?php echo $ergebnis["id"] ?>"><b>lschen</b></a> <?php
      if ($ergebnis["absender"]!==$user["id"])
      {
        // die nachricht ist nicht in der outbox => antworten- und weiterleiten-knopf
        ?><a class="berschriftlink" href="index.php?action=mailbox&amp;show=neu&amp;type=antworten&amp;msg=<?php echo $ergebnis["id"] ?>"><b><?php echo $t_antworten ?></b></a>
        <a class="berschriftlink" href="index.php?action=mailbox&amp;show=neu&amp;type=weiterleiten&amp;msg=<?php echo $ergebnis["id"] ?>"><b>weiterleiten</b></a>
        <?php if($rechte["sendmail"] == true) { ?><a class="berschriftlink" href="index.php?action=sendmail&amp;id=<?php echo $ergebnis["absender"] ?>"><b>E-Mail an Abs.</b></a>
        <?php }
      }
      else
      {
        //die nachricht ist in der outbox => erneut versenden-knopf
        ?><a class="berschriftlink" href="index.php?action=mailbox&amp;show=neu&amp;type=erneut&amp;msg=<?php echo $ergebnis["id"] ?>"><b>erneut versenden</b></a>
        <?php if($rechte["sendmail"] == true) { ?><a class="berschriftlink" href="index.php?action=sendmail&amp;id=<?php echo $ergebnis["empfnger"] ?>"><b>E-Mail an Empf..</b></a>
        <?php }
      }
      ?></td>
    </tr>
    </table>
    <?php
    // falls der empfnger die nachricht liest,
    // "gelesen" auf 1 setzen
    if ($user["id"] == $ergebnis["empfnger"])
    {
      $werte = array("gelesen" => 1);
      sql_update("mailbox", $werte, "WHERE id=".$ergebnis["id"]);
    }
  } // ende-readmsg

  //******************************** neu *****************************************
  if($_GET["show"]=="neu")
  {
    if (!isset($_POST["step"]))
    {
      // Formular ausgeben

      if (isset($_GET["msg"]))
      {
        // es ist eine Antwort oder Weiterleitung
        // => Infos ber vorherige Nachricht abfragen
        $result = sql_select("*", "mailbox", "WHERE id=".$_GET["msg"], NULL, NULL);
        $ergebnis = sql_fetch_assoc($result);
        $absresult = sql_select("*", "users", "WHERE id=".$ergebnis["absender"], NULL, NULL);
        $absergebnis = sql_fetch_assoc($absresult);
        $empresult = sql_select("*", "users", "WHERE id=".$ergebnis["empfnger"], NULL, NULL);
        $empergebnis = sql_fetch_assoc($empresult);
        if($user["id"]!=$ergebnis["empfnger"] and $user["id"]!=$ergebnis["absender"]) fehler("Sie besitzen nicht die ntigen Zugriffsrechte");
      }

      // Neu, Antwort, Weiterleitung oder Erneut senden?
      switch($_GET["type"])
      {
        case "neu":
          echo "<h3>Neue Nachricht</h3>\n";
          break;
        case "antworten":
          echo "<h3>Antworten</h3>\n";
          break;
        case "weiterleiten":
          echo "<h3>Nachricht weiterleiten</h3>\n";
          break;
        case "erneut":
          echo "<h3>Nachricht erneut senden</h3>\n";
          break;
      }
      ?>
      <form name="form1" method="POST" action="index.php?action=mailbox&amp;show=neu">
      <input name="step" type="hidden" value="2" />
      <table class="maintable">
      <tr class="rowberschrift">
        <td colspan="2">Nachricht:</td>
      </tr>
      <tr class="row2">
        <td>Empfnger:</td><td><input class="inputtext" name="empfaenger" type="text" size="40" <?php
        if($_GET["type"]=="antworten")
        {
          echo "value=\"".$absergebnis["username"]."\"";
        }
        if($_GET["type"]=="erneut")
        {
          echo "value=\"".$empergebnis["username"]."\"";
        }
        if(isset($_GET["userid"]))
        {
          $result = sql_select("*", "users", "WHERE id=".$_GET["userid"], NULL, NULL);
          $ergebnis = sql_fetch_assoc($result);
          echo "value=\"".$ergebnis["username"]."\"";
        }
        ?> /></td>
      </tr>
      <tr class="row2">
        <td>Betreff:</td><td><input class="inputtext" name="titel" type="text" size="40" <?php
        if($_GET["type"]=="antworten")
        {
          echo "value=\"RE: ".$ergebnis['titel']."\"";
        }
        if($_GET["type"]=="weiterleiten")
        {
          echo "value=\"FWD: ".$ergebnis['titel']."\"";
        }
        if($_GET["type"]=="erneut")
        {
          echo "value=\"".$ergebnis['titel']."\"";
        }
        ?> /></td>
      </tr>
      <tr class="row2">
        <td>BB-Code:</td><td><?php $formname = "form1"; $textname = "nachricht"; include("./bbcode_inputs.php") ?></td>
      </tr>
      <tr class="row2">
        <td>Nachricht:</td><td><textarea class="inputtext" name="nachricht" cols="30" rows="20" /><?php
          if($_GET["type"]=="weiterleiten" or $_GET["type"]=="antworten")
          {
            // Ursprngliche Nachricht anhngen:
            echo "\n\n### Ursprngliche Nachricht: ###\n";
            echo ("Absender: ".$absergebnis["username"]."\n");
            echo ("Empfnger: ".$empergebnis["username"]."\n");
            echo ("Gesendet am: ".date("d.m.Y", $ergebnis["created"])." - ".date("H:i:s", $ergebnis["created"])." (Server-Zeit)\n");
            echo ("Titel: ".$ergebnis["titel"]."\n\n");
            echo $ergebnis["nachricht"];
          }
          if($_GET["type"]=="erneut")
          {
            echo $ergebnis["nachricht"];
          }
          ?></textarea></td>
        </tr>
        <tr class="rowberschrift">
          <td colspan="2">Optionen:</td>
        </tr>
        <tr class="row2">
          <td>BB-Code aktivieren:</td><td><input name="bbcode" type="radio" value="1"<?php if($user["auto_bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($user["auto_bbcode"] == 0) echo " checked" ?> />Nein</td>
        </tr>
        <tr class="row2">
          <td>Smilies aktivieren:</td><td><input name="smilies" type="radio" value="1"<?php if($user["auto_smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($user["auto_smilies"] == 0) echo " checked" ?> />Nein</td>
        </tr>
        <tr class="row2">
          <td>Signatur anhngen:</td><td><input name="signatur" type="radio" value="1"<?php if($user["auto_sig"] == 1) echo " checked" ?> />Ja <input name="signatur" type="radio" value="0"<?php if($user["auto_sig"] == 0) echo " checked" ?> />Nein</td>
        </tr>
        <tr class="row2">
          <td>&nbsp</td><td><input type="submit" value="Senden" /></td>
        </tr>
      </table>
      </form>
      <?php
    }
    else
    {
      if(trim($_POST["titel"])=="") fehler("Sie haben keinen Betreff angegeben!");
      // userid des empfngers holen
      $empfngerresult = sql_select("*", "users", "WHERE username='".$_POST["empfaenger"]."'", NULL, NULL);
      if(sql_num_rows($empfngerresult) == 0)
      {
        // den empfnger gibt's nicht
        redir(getenv ("HTTP_REFERER"), "Der Empfnger existiert nicht!", false);
      }
      else
      {
        // es gibt den Empfnger
        $empfnger = sql_fetch_assoc($empfngerresult);

        // alles in die Datenbank
        $werte = array(
            "titel"     => $_POST["titel"],
            "absender"  => $user["id"],
            "empfnger" => $empfnger["id"],
            "nachricht" => $_POST["nachricht"],
            "bbcode"    => $_POST["bbcode"],
            "smilies"   => $_POST["smilies"],
            "signatur"  => $_POST["signatur"],
            "gelesen"   => 0,
            "gelscht"  => 0,
            "created"   => time()
            );
        sql_insert("mailbox", $werte);

        // will der empfnger eine email-benachrichtigung?
        if($empfnger["pn_email"] == 1)
        {
          // mail verschicken
          mail($empfnger["email"], $einstellungen["titel"].": Neue PN!", $user["username"]." hat Ihnen eine private Nachricht geschickt!\n".$einstellungen["adresse"]."index.php", "From: ".$einstellungen["infomail"]."\nReply-To: ".$einstellungen["infomail"]."\nX-Mailer: PHP/" . phpversion());
        }
        //redirect-script

        redir("index.php?action=mailbox&show=outbox", "Die Nachricht wurde gesendet!");
      } // ende-isset-step
    }
  } // ende-neu

  //******************************* delete ***************************************
  if($_GET["show"]=="delete")
  {
    $result = sql_select("*", "mailbox", "WHERE id=".$_GET["msg"], NULL, NULL);
    $ergebnis = sql_fetch_assoc($result);
    if($user["id"]!=$ergebnis["empfnger"] and $user["id"]!=$ergebnis["absender"]) fehler("Sie besitzen nicht die ntigen Zugriffsrechte!");
    if(!isset($_GET["sicher"]))
    {
      ?>
      <b>Soll die Nachricht wirklich gelscht werden?<br /><a href="index.php?action=mailbox&amp;show=delete&amp;msg=<?php echo $_GET["msg"] ?>&amp;sicher=ja">lschen</a></b>
      <?php
    }
    else
    {
      // wurde die mail vom anderen schon gelscht?
      // bestimmen des neuen "gelscht"-Wertes:
      if($ergebnis["gelscht"]==0)
      {
        if ($ergebnis["empfnger"]==$user["id"])
        {
          // er ist der empfnger
          $werte = array("gelscht" => 1);
          sql_update("mailbox", $werte, "WHERE id=".$ergebnis["id"]);
        }
        else
        {
          // er ist der absender
          $werte = array("gelscht" => 2);
          sql_update("mailbox", $werte, "WHERE id=".$ergebnis["id"]);
        }
      }
      else
      {
        // nachricht lschen
        sql_delete("mailbox", "WHERE id=".$_GET["msg"]);
      }

      redir("index.php?action=mailbox&show=inbox", "Die Nachricht wurde gelscht!");
    }
  } // ende-delete
} // ende-isset-show
?>
</td></tr>
</table>