<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
?>
<table class="maintable" width="100%">
<tr class="rowberschrift">
    <td><b>ID</b></td>
    <td><b>Rechte</b></td>
    <td><b>Titel</b></td>
    <td><b>Threads</b></td>
    <td><b>Posts</b></td>
    <td><b>Letzter Post</b></td>
</tr>


<?php
if(isset($kategorien))
{
  // jede zeile aus dem array holen und in die table einfgen
  foreach($kategorien as $kategorie)
  {
    ?>
    <tr class="rowberschrift">
      <td colspan="6"><?php echo $kategorie["titel"] ?></td>
    </tr>
    <?php
    $zeile = 2;
    // ggf. mini-announcements anzeigen
    if(isset($kategorie["miniannouncements"]))
    {
      foreach($kategorie["miniannouncements"] as $miniannouncement)
      {
        ?>
        <tr class="row<?php echo $zeile ?>">
          <td class="liste" colspan="6"><span class="announcementtitel"><?php echo $miniannouncement["titel"] ?>:</span><br /><?php echo $miniannouncement["nachricht"] ?></td>
        </tr>
        <?php
        $zeile++;
        if ($zeile>2) $zeile=1;
      }
    }
    // ggf. thread-announcements anzeigen
    if(isset($kategorie["threadannouncements"]))
    {
      foreach($kategorie["threadannouncements"] as $threadannouncement)
      {
        ?>
        <tr class="row<?php echo $zeile ?>">
          <td class="liste"><?php echo $threadannouncement["id"] ?></td>
          <td class="liste">&nbsp;</td>
          <td class="liste">Ankndigung: <a href="<?php echo $threadannouncement["link"] ?>"><?php echo $threadannouncement["titel"] ?></a></td>
          <td class="liste" colspan="3">&nbsp;</td>
        </tr>
        <?php
        $zeile++;
        if ($zeile>2) $zeile=1;
      }
    }
    
    if(isset($kategorie["boards"]))
    {
      // jede zeile aus dem array holen und in die table einfgen
      foreach($kategorie["boards"] as $board)
      {
        ?>
        <tr class="row<?php echo $zeile ?>">
          <td class="liste"><?php echo $board["id"] ?></td>
          <td class="liste"><?php echo $board["rechte"] ?></td>
          <td class="liste"><a href="<?php echo $board["titellink"] ?>"><?php echo $board["titel"] ?></a><br />
          <?php echo $board["beschreibung"] ?></td>
          <td class="liste"><?php echo $board["threads"] ?></td>
          <td class="liste"><?php echo $board["posts"] ?></td>
          <td class="liste"><?php
          if($board["posts"] != 0)
          {
            ?><a href="<?php echo $board["lastpostlink"] ?>"><?php echo $board["lastposttitel"] ?></a><br />
            <?php echo $board["lastpostdatum"]." von ";
            if($board["lastpostautorlink"] != "") { ?><a href="<?php echo $board["lastpostautorlink"] ?>"><?php }
            echo $board["lastpostautor"];
            if($board["lastpostautorlink"] != "") { ?></a><?php }
            ?></td><?php
          }
          else
          {
            ?> - </td>
            <?php
          }
          ?>
        </tr>
        <?php

        $zeile++;
        if ($zeile>2) $zeile=1;
      }
    }
  }
}
?>
</table>