<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

$strseite = "<b>Seite: ";
if(isset($seitenlink))
{
  if($startausgeblendet == true) $strseite .= ".. ";
  foreach($seitenlink as $n => $slink)
  {
    if($n != "letzte")
    {
      if($slink == "")
      {
        // aktuelle seite
        $strseite .= $n." ";
      }
      else
      {
        $strseite .= "<a href=\"".$slink."\">".$n."</a> ";
      }
    }
    else
    {
      $strseite .= "<a href=\"".$slink."\">[letzte Seite]</a>";
    }
  }
}
else
{
  $strseite .= "1";
}
$strseite .= "</b>";
echo $strseite;
?>
</b><br /><br />

<table class="maintable" width="100%">
<tr class="rowberschrift">
    <td>ID</td>
    <td>Status</td>
    <td>Titel</td>
    <td>erstellt</td>
    <td>Posts</td>
    <td>Hits</td>
    <td>Letzter Post</td>
</tr>

<?php
// jede zeile aus dem array holen und in die table einfgen
$zeile = 2;
// ggf. mini-announcements anzeigen
if(isset($miniannouncements))
{
  foreach($miniannouncements as $miniannouncement)
  {
    ?>
    <tr class="row<?php echo $zeile ?>">
      <td class="liste" colspan="7"><span class="announcementtitel"><?php echo $miniannouncement["titel"] ?>:</span><br /><?php echo $miniannouncement["nachricht"] ?></td>
    </tr>
    <?php
    $zeile++;
    if ($zeile>2) $zeile=1;
  }
}
// ggf. thread-announcements anzeigen
if(isset($threadannouncements))
{
  foreach($threadannouncements as $threadannouncement)
  {
    ?>
    <tr class="row<?php echo $zeile ?>">
      <td class="liste"><?php echo $threadannouncement["id"] ?></td>
      <td class="liste">&nbsp;</td>
      <td class="liste">Ankndigung: <a href="<?php echo $threadannouncement["link"] ?>"><?php echo $threadannouncement["titel"] ?></a></td>
      <td class="liste" colspan="4">&nbsp;</td>
    </tr>
    <?php
    $zeile++;
    if ($zeile>2) $zeile=1;
  }
}

if(isset($threads))
{
  foreach($threads as $thread)
  {
    ?>
    <tr class="row<?php echo $zeile ?>">
      <td class="liste"><?php echo $thread["id"] ?></td>
      <td class="liste"><?php echo $thread["status"] ?></td>
      <td class="liste"><?php if($thread["sticky"] == true) echo "Sticky: "; if($thread["umfrage"] == true) echo "Umfrage: " ?><a href="<?php echo $thread["titellink"] ?>"><?php echo $thread["titel"] ?></a></td>
      <td class="liste"><?php echo $thread["erstellt"]." von ";
      if($thread["autorlink"] != "") echo "<a href=\"".$thread["autorlink"]."\">";
      echo $thread["autorname"];
      if($thread["autorlink"] != "") echo "</a>";
      ?></td>
      <td class="liste"><?php echo $thread["posts"] ?></td>
      <td class="liste"><?php echo $thread["hits"] ?></td>
      <td class="liste"><?php
      if($thread["posts"] != 0)
      {
        ?><a href="<?php echo $thread["lastpostlink"] ?>"><?php echo $thread["lastpostdatum"] ?></a> von <?php
        if($thread["lastpostautorlink"] != "") { ?><a href="<?php echo $thread["lastpostautorlink"] ?>"><?php }
        echo $thread["lastpostautor"];
        if($thread["lastpostautorlink"] != "") { ?></a><?php }
        ?></td><?php
      }
      else
      {
        ?> - </td>
        <?php
      }
      ?>
    </tr>
    <?php

    $zeile++;
    if ($zeile>2) $zeile=1;
  }
}
?>
</table>
<br />
<table class="maintable" width="100%">
<tr class="rowberschrift">
  <td align="left"><b>Legende</b></td>
  <td align="right"><b>Aktionen</b></td>
</tr>
<tr class="row2">
  <td align="left">&nbsp</td><td align="right"><?php
  if(isset($neuerthreadlink)) echo "<a href=\"".$neuerthreadlink."\">".$t_neuerthread."</a>";
  ?></td>
</tr>
</table>
<br />
<?php echo $strseite ?>
