<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if(!isset($_GET["action"]) or $_GET["action"] != "statistik")
{
  // mini-statistik
  ?>
  <table class="maintable" width="100%">
  <tr class="rowberschrift">
    <td>Statistik</td>
  </tr>
  <tr class="row2">
    <td><?php echo $statistik["posts"] ?> Posts in <?php echo $statistik["threads"] ?> Threads in <?php echo $statistik["boards"] ?> Boards.<br />
    <?php echo $statistik["users"] ?> registrierte Benutzer. Neuester Benutzer:
    <?php
    if(isset($statistik["newestuserlink"]))
    {
      ?><a href="<?php echo $statistik["newestuserlink"] ?>"><?php
    }
    echo $statistik["newestuser"];
    if(isset($statistik["newestuserlink"]))
    {
      ?></a><?php
    }
    ?><br />
    <a href="index.php?action=statistik">mehr</a></td>
  </tr>
  </table>
<?php
}
else
{
  // ausfhrliche statistik
  ?>
  <h3>Statistik</h3>
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="2">Allgemeines</td>
  </tr>
  <tr class="row2">
    <td>Installiert seit:</td><td><?php echo date("d.m.Y", $statistik["installiertseit"]) ?></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Boards</td>
  </tr>
  <tr class="row2">
    <td>Aktuelle Boards:</td><td><?php echo $statistik["boards"] ?></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Threads</td>
  </tr>
  <tr class="row2">
    <td>Aktuelle Threads:</td><td><?php echo $statistik["threads"] ?></td>
  </tr>
  <tr class="row2">
    <td>Threads insgesamt:</td><td><?php echo $statistik["totalthreads"] ?></td>
  </tr>
  <tr class="row2">
    <td>Threads pro Tag:</td><td><?php echo $statistik["threadsperday"] ?></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Posts</td>
  </tr>
  <tr class="row2">
    <td>Aktuelle Posts:</td><td><?php echo $statistik["posts"] ?></td>
  </tr>
  <tr class="row2">
    <td>Posts insgesamt:</td><td><?php echo $statistik["totalposts"] ?></td>
  </tr>
  <tr class="row2">
    <td>Posts pro Tag:</td><td><?php echo $statistik["postsperday"] ?></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">PNs</td>
  </tr>
  <tr class="row2">
    <td>PNs insgesamt:</td><td><?php echo $statistik["totalpns"] ?></td>
  </tr>
  <tr class="row2">
    <td>PNs pro Tag:</td><td><?php echo $statistik["pnsperday"] ?></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Benutzer</td>
  </tr>
  <tr class="row2">
    <td>Aktuelle Benutzer:</td><td><?php echo $statistik["users"] ?></td>
  </tr>
  <tr class="row2">
    <td>Registrierungen insgesamt:</td><td><?php echo $statistik["totalregistrations"] ?></td>
  </tr>
  <tr class="row2">
    <td>Registrierungen pro Tag:</td><td><?php echo $statistik["registrationsperday"] ?></td>
  </tr>
  <tr class="row2">
    <td>Neuester Benutzer:</td><td><?php
    if(isset($statistik["newestuserlink"]))
    {
      ?><a href="<?php echo $statistik["newestuserlink"] ?>"><?php
    }
    echo $statistik["newestuser"];
    if(isset($statistik["newestuserlink"]))
    {
      ?></a><?php
    }
    ?></td>
  </tr>
  </table>
  <?php
}
?>