<div class="barnraiser_wiki_page">
	<div class="block">
		<div class="block_body">
			<?php
			if(isset($barnraiser_wiki_page['wikipage_id'])) {
			?>
			<p>
				<?php echo $barnraiser_wiki_page['revision_body'];?>
			</p>
	
			<p>
				<span class="datetime"><?php echo strftime("%d %b %G %H:%M", $barnraiser_wiki_page['revision_create_datetime']);?></span>

				&nbsp;&#124;&nbsp;
					
				<a href="index.php?t=network&amp;connection_id=<?php echo $barnraiser_wiki_page['connection_id'];?>" class="connection_id"><?php echo $barnraiser_wiki_page['connection_nickname']?></a>
			</p>
			<?php
			}
			else {
			?>
			<p>
				This page has not been made yet.
			</p>
			<?php }?>
		</div>

		<div class="block_footer">
			<?php
			if (isset($barnraiser_wiki_wikipage) && $barnraiser_wiki_page['wikipage_name'] != $barnraiser_wiki_wikipage) {
			?>
				<a href="index.php?wp=<?php echo AM_WEBPAGE_NAME;?>"><?php echo $lang['href_return_to_webpage'];?></a>&nbsp;
			<?php }?>
			
			<?php
			if (isset($barnraiser_wiki_page['revision_id']) && $barnraiser_wiki_page['revision_id'] != $barnraiser_wiki_page['current_revision_id']) {
			?>
				<a href="index.php?wp=<?php echo AM_WEBPAGE_NAME;?>&amp;wikipage=<?php echo $barnraiser_wiki_page['wikipage_name'];?>"><?php echo $lang['href_current_revision'];?></a>
			<?php }?>

			<?php
			if (isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $plugin_permissions['barnraiser_wiki']['edit_page']) {
			?>
				<a href="index.php?p=barnraiser_wiki&amp;t=edit_wikipage&amp;wikipage=<?php echo $barnraiser_wiki_page['wikipage_name'];?>&amp;wp=<?php echo AM_WEBPAGE_NAME;?>" class="edit"><?php echo $lang['href_edit'];?></a>&nbsp;
			<?php
			}
			else {
			?>
			<span class="disabled_link" onclick="javascript:showInterfaceSystemMessage(event, 'no_wiki_edit_title', 'no_wiki_edit_message');"><?php echo $lang['href_edit'];?></span>
			<span style="display:none;">
				<span id="no_wiki_edit_title">Permissions problem:</span>
				<span id="no_wiki_edit_message">
					You do not have permissions to edit the wiki.
					<?php
					if (isset($_SESSION['connection_id'])) {
					?>
					If you are connected then look in your <a href="index.php?t=network&amp;connection_id=<?php echo $_SESSION['connection_id'];?>" class="connection_id">account page</a> where you will find more information about your membership.
					<?php
					}
					else {
					?>
					Try <a href="index.php?t=login" class="login">connecting</a> first.
					<?php }?>
				</span>
			</span>
			<?php }?>

			<?php
			if (isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $plugin_permissions['barnraiser_wiki']['manage_wiki']) {
			?>
				<a href="index.php?p=barnraiser_wiki&amp;t=maintain&amp;wp=<?php echo AM_WEBPAGE_NAME;?>" class="maintain"><?php echo $lang['href_maintain'];?></a>
			<?php }?>
		</div>
	</div>

	<?php
	if(isset($barnraiser_wiki_page['wikipage_id']) && !empty($barnraiser_wiki_page['wikipage_allow_note'])) {
	?>
	<div class="notes">
		<div class="block">
			<div class="block_body">
				<?php
				if (isset($barnraiser_wiki_notes)) {
				?>
				
				<?php
				foreach ($barnraiser_wiki_notes as $key => $i):
				?>
				<a name="note_id<?php echo $i['note_id'];?>"></a>

				<div id="note_id<?php echo $i['note_id'];?>">
					<div class="note">
						<form action="plugins/barnraiser_wiki/add_del_note.php" method="post">
				        <input type="hidden" name="note_id" value="<?php echo $i['note_id'];?>" />
						
						<div class="note_header">
							<?php echo strftime("%d %b %G %H:%M", $i['note_create_datetime']);?>
							&nbsp;
							<a href="index.php?t=network&amp;connection_id=<?php echo $i['connection_id'];?>" class="connection_id"><?php echo $i['connection_nickname']?></a>
							<br />
						</div>
	
						<div class="note_body">
							<?php echo $i['note_body'];?>
						</div>
						
						<div class="note_footer">
							<?php
							if (isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $plugin_permissions['barnraiser_wiki']['manage_wiki']) {
							?>
							<input type="submit" name="delete_note" value="delete note" />
							<?php }?>
						</div>
						</form>
					</div>
				</div>
				<?php
				endforeach;
				}
				else {
				?>
					<p>
				        <?php echo $lang['txt_no_notes'];?>
					</p>
				<?php }?>

				<?php
				if (isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $plugin_permissions['barnraiser_wiki']['add_note']) {
				?>
					<div class="add">
						<form action="plugins/barnraiser_wiki/add_del_note.php?wp=<?php echo AM_WEBPAGE_NAME;?>" method="post">
						<input type="hidden" name="wikipage_id" value="<?php echo $barnraiser_wiki_page['wikipage_id'];?>" />
						<input type="hidden" name="wikipage_name" value="<?php echo $barnraiser_wiki_page['wikipage_name'];?>" />
		
						<a name="add_note_form"></a>
						<textarea name="note_body" id="note_body" cols="80" rows="5"></textarea>
		
						<input type="submit" name="insert_note" value="<?php echo $lang['sub_add_note'];?>" /><br />
		
						</form>
					</div>
				<?php }?>
			</div>

			<?php
			if (!isset($_SESSION['connection_permission']) || !($_SESSION['connection_permission'] & $plugin_permissions['barnraiser_wiki']['add_note'])) {
			?>
			<div class="block_footer">
				<span class="disabled_link" onclick="javascript:showInterfaceSystemMessage(event, 'no_wiki_note_add_title', 'no_wiki_note_add_message');">add note</span>&nbsp;
				<span style="display:none;">
					<span id="no_wiki_note_add_title">Permissions problem:</span>
					<span id="no_wiki_note_add_message">
						You do not have permissions to add a note against a wiki page.
						<?php
						if (isset($_SESSION['connection_id'])) {
						?>
						If you are connected then look in your <a href="index.php?t=network&amp;connection_id=<?php echo $_SESSION['connection_id'];?>">account page</a> where you will find more information about your membership.
						<?php
						}
						else {
						?>
						Try <a href="index.php?t=login" class="login">connecting</a> first.
						<?php }?>
					</span>
				</span>
			</div>
			<?php }?>
		</div>
	</div>
	<?php }?>
</div>