<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

$menu_section = "my";

if (!isset($me['user_id']) || $me['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'my_common.lang.php');
require_once($languageArrayPath . 'arr_rsp.lang.php');


// Setup statistics -------------------------------------------------------
require_once('class/Statistic.class.php');
$statistic = new Statistic($db, null);
$statistic->user_status = $c_node['user']['status'];
$output_user_statistics = $statistic->getAllUserStatistics();
$statistic->user_id = $me['user_id'];
$output_statistics = $statistic->getStatistics();


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, null);
$comment->wiki = $wiki;


// Create social network summary -------------------------------------------
require_once('class/SocialNetwork.class.php');
$sn = new Socialnetwork(null, $db);
$sn->relation_type_ids = $c_node['user']['relation_type'];
$sn->status_ids = $c_node['user']['status'];
$sn->user_id = $me['user_id'];
if (isset($me['relations'])) {
	$output_network['degree1'] = count($me['relations']);
	
	if (empty($output_network['degree1'])) {
		$output_network['degree1'] = "0";
	}
}

$lang['txt_degree1'] = str_replace('SYS_KEYWORD_DEG_TOTAL', $output_network['degree1'], $lang['txt_degree1']);

if (empty($output_statistics['total_users'])) {
	$output_statistics['total_users'] = "0";
}
$lang['txt_network'] = str_replace('SYS_KEYWORD_USRS_TOTAL', $output_user_statistics['total_users'], $lang['txt_network']);

if (empty($output_statistics['total_online_users'])) {
	$output_statistics['total_online_users'] = "0";
}
$lang['txt_network'] = str_replace('SYS_KEYWORD_USERS_ONLINE_TOTAL', $output_user_statistics['total_online_users'], $lang['txt_network']);


// Create blog summary -------------------------------------------
$total_blogs = "0";
if (!empty($output_statistics)) {
	foreach ($output_statistics as $key => $i):
		if ($i['statistic_type_id'] == $c_node['statistic']['user']['total_blogs']) {
			if (!empty($i['total'])) {
				$total_blogs = $i['total'];
			}
			unset($output_statistics[$key]);
			break;
		}
	endforeach;
}
$lang['txt_blog'] = str_replace('SYS_KEYWORD_TOTAL', $total_blogs, $lang['txt_blog']);


$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
$comment->item_user_id = $me['user_id'];
$total_blog_comments = $comment->getCommentCount();

if (empty($total_blog_comments)) {
	$total_blog_comments = "0";
}
$lang['txt_blog'] = str_replace('SYS_KEYWORD_COM_TOTAL', $total_blog_comments, $lang['txt_blog']);


// Create library summary -------------------------------------------
$total_library_items = "0";
if (!empty($output_statistics)) {
	foreach ($output_statistics as $key => $i):
		if ($i['statistic_type_id'] == $c_node['statistic']['user']['total_library_items']) {
			if (!empty($i['total'])) {
				$total_library_items = $i['total'];
			}
			unset($output_statistics[$key]);
			break;
		}
	endforeach;
}
$lang['txt_library'] = str_replace('SYS_KEYWORD_TOTAL', $total_library_items, $lang['txt_library']);


$comment->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
$comment->item_user_id = $me['user_id'];
$total_library_comments = $comment->getCommentCount();

if (empty($total_library_comments)) {
	$total_library_comments = "0";
}
$lang['txt_library'] = str_replace('SYS_KEYWORD_COM_TOTAL', $total_library_comments, $lang['txt_library']);


// Create forum summary -------------------------------------------
$total_subjects = "0";
if (!empty($output_statistics)) {
	foreach ($output_statistics as $key => $i):
		if ($i['statistic_type_id'] == $c_node['statistic']['user']['total_forum_subjects']) {
			if (!empty($i['total'])) {
				$total_subjects = $i['total'];
			}
			unset($output_statistics[$key]);
			break;
		}
	endforeach;
}
$lang['txt_forum'] = str_replace('SYS_KEYWORD_TOTAL', $total_subjects, $lang['txt_forum']);


$comment->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
$comment->item_user_id = $me['user_id'];
$total_library_comments = $comment->getCommentCount();

if (empty($total_subject_comments)) {
	$total_subject_comments = "0";
}
$lang['txt_forum'] = str_replace('SYS_KEYWORD_COM_TOTAL', $total_subject_comments, $lang['txt_forum']);


// Create poll summary -------------------------------------------
$total_polls = "0";
if (!empty($output_statistics)) {
	foreach ($output_statistics as $key => $i):
		if ($i['statistic_type_id'] == $c_node['statistic']['user']['total_polls']) {
			if (!empty($i['total'])) {
				$total_polls = $i['total'];
			}
			unset($output_statistics[$key]);
			break;
		}
	endforeach;
}
$lang['txt_poll'] = str_replace('SYS_KEYWORD_TOTAL', $total_polls, $lang['txt_poll']);

require_once('class/Poll.class.php');
$poll = new Poll($db, null);
$poll->user_id = $me['user_id'];
$total_poll_participaton = $poll->selPollParticipationCount();

if (empty($total_poll_participaton)) {
	$total_poll_participaton = "0";
}
$lang['txt_poll'] = str_replace('SYS_KEYWORD_COM_TOTAL', $total_poll_participaton, $lang['txt_poll']);


// Create quiz summary -------------------------------------------
$total_quizzes = "0";
if (!empty($output_statistics)) {
	foreach ($output_statistics as $key => $i):
		if ($i['statistic_type_id'] == $c_node['statistic']['user']['total_quizzes']) {
			if (!empty($i['total'])) {
				$total_quizzes = $i['total'];
			}
			unset($output_statistics[$key]);
			break;
		}
	endforeach;
}
$lang['txt_quiz'] = str_replace('SYS_KEYWORD_TOTAL', $total_quizzes, $lang['txt_quiz']);

require_once('class/Quiz.class.php');
$quiz = new Quiz($db, null);
$quiz->user_id = $me['user_id'];
$total_quiz_completion = $quiz->selResults();
$total_quiz_completion = count($total_quiz_completion);

if (empty($total_quiz_completion)) {
	$total_quiz_completion = "0";
}
$lang['txt_quiz'] = str_replace('SYS_KEYWORD_COM_TOTAL', $total_quiz_completion, $lang['txt_quiz']);


// Create comment summary -------------------------------------------
$total_comments = "0";
if (!empty($output_statistics)) {
	foreach ($output_statistics as $key => $i):
		if ($i['statistic_type_id'] == $c_node['statistic']['user']['total_comments']) {
			if (!empty($i['total'])) {
				$total_comments = $i['total'];
			}
			unset($output_statistics[$key]);
			break;
		}
	endforeach;
}
$lang['txt_comments'] = str_replace('SYS_KEYWORD_TOTAL', $total_comments, $lang['txt_comments']);

require_once('class/Comment.class.php');
$comment = new Comment($db, null);
$comment->item_user_id = $me['user_id'];
$total_received_comments = $comment->getCommentCount();

if (empty($total_received_comments)) {
	$total_received_comments = "0";
}
$lang['txt_comments'] = str_replace('SYS_KEYWORD_COM_TOTAL', $total_received_comments, $lang['txt_comments']);


// Create schedule summary -------------------------------------------
require_once('class/Schedule.class.php');
$schedule = new Schedule($db, null, $date);
$schedule->schedule_config = $c_node['schedule'];
$schedule->start_date = date("Y-m-d");
$schedule->no_of_days_shown = 7;
$schedule->user_id = $me['user_id']; // get allocation
$output_schedule_items = $schedule->selScheduleItems(null, 1);


// get latest comments ------------------------------------------------
$comment->no_user_id = $me['user_id'];
$comment->item_user_id = $me['user_id'];
$comment->limit = 3;
$comment->order_by = "c.comment_create_datetime desc";
$output_comments = $comment->selComments();



//MOVE TO TEMPLATE
if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_schedule_items)) {
   $body->set('schedule_items', $output_schedule_items);
}

$body->set('schedule_config', $c_node['schedule']);
$body->set('rsp_item_type_ids', $c_node['rsp']['item_type']);

include "inc/footer.inc.php";

?>
