/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax;

import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLFragmentStreamReader
implements XMLStreamReader {
    private static final int STATE_START_DOCUMENT = 0;
    private static final int STATE_IN_FRAGMENT = 1;
    private static final int STATE_FRAGMENT_END = 2;
    private static final int STATE_END_DOCUMENT = 3;
    private XMLStreamReader parent;
    private final boolean proceedToNext;
    private int state;
    private int depth;

    public XMLFragmentStreamReader(XMLStreamReader parent) {
        this(parent, true);
    }

    public XMLFragmentStreamReader(XMLStreamReader parent, boolean proceedToNext) {
        this.parent = parent;
        this.proceedToNext = proceedToNext;
        if (parent.getEventType() != 1) {
            throw new IllegalStateException("Expected START_ELEMENT as current event");
        }
    }

    @Override
    public int getEventType() {
        switch (this.state) {
            case 0: {
                return 7;
            }
            case 1: {
                return this.parent.getEventType();
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 8;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int next() throws XMLStreamException {
        switch (this.state) {
            case 0: {
                this.state = 1;
                return 1;
            }
            case 1: {
                int type = this.parent.next();
                switch (type) {
                    case 1: {
                        ++this.depth;
                        break;
                    }
                    case 2: {
                        if (this.depth == 0) {
                            this.state = 2;
                            break;
                        }
                        --this.depth;
                    }
                }
                return type;
            }
            case 2: {
                if (this.proceedToNext) {
                    this.parent.next();
                }
                this.state = 3;
                return 8;
            }
        }
        throw new NoSuchElementException("End of document reached");
    }

    @Override
    public int nextTag() throws XMLStreamException {
        switch (this.state) {
            case 0: {
                this.state = 1;
                return 1;
            }
            case 2: 
            case 3: {
                throw new NoSuchElementException();
            }
        }
        int result = this.parent.nextTag();
        switch (result) {
            case 1: {
                ++this.depth;
                break;
            }
            case 2: {
                if (this.depth == 0) {
                    this.state = 2;
                    break;
                }
                --this.depth;
            }
        }
        return result;
    }

    @Override
    public void close() throws XMLStreamException {
        this.parent = null;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.parent.getProperty(name);
    }

    @Override
    public String getCharacterEncodingScheme() {
        if (this.state == 0) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getEncoding() {
        if (this.state == 0) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public Location getLocation() {
        return this.parent.getLocation();
    }

    @Override
    public int getAttributeCount() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getAttributeLocalName(index);
    }

    @Override
    public QName getAttributeName(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getAttributeNamespace(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.isAttributeSpecified(index);
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getElementText();
    }

    @Override
    public String getLocalName() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getLocalName();
    }

    @Override
    public QName getName() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getName();
    }

    @Override
    public String getPrefix() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getPrefix();
    }

    @Override
    public String getNamespaceURI() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getNamespaceURI();
    }

    @Override
    public int getNamespaceCount() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getNamespaceURI(index);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getNamespaceURI(prefix);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.parent.getNamespaceContext();
    }

    @Override
    public String getPIData() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getPIData();
    }

    @Override
    public String getPITarget() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getPITarget();
    }

    @Override
    public String getText() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getText();
    }

    @Override
    public char[] getTextCharacters() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextLength() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getTextLength();
    }

    @Override
    public int getTextStart() {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException();
        }
        return this.parent.getTextStart();
    }

    @Override
    public boolean hasName() {
        return this.state != 0 && this.state != 3 && this.parent.hasName();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.state != 3;
    }

    @Override
    public boolean hasText() {
        return this.state != 0 && this.state != 3 && this.parent.hasText();
    }

    @Override
    public boolean isCharacters() {
        return this.state != 0 && this.state != 3 && this.parent.isCharacters();
    }

    @Override
    public boolean isStartElement() {
        return this.state != 0 && this.state != 3 && this.parent.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.state != 0 && this.state != 3 && this.parent.isEndElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.state != 0 && this.state != 3 && this.parent.isWhiteSpace();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        switch (this.state) {
            case 0: {
                if (type == 7) break;
                throw new XMLStreamException("Expected START_DOCUMENT");
            }
            case 3: {
                if (type == 8) break;
                throw new XMLStreamException("Expected END_DOCUMENT");
            }
            default: {
                this.parent.require(type, namespaceURI, localName);
            }
        }
    }
}

