/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.common.builder;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.factory.AxiomElementType;
import org.apache.axiom.om.impl.intf.factory.AxiomNodeFactory;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.builder.SOAPBuilderHelper;
import org.w3c.dom.Element;

public class SOAP11BuilderHelper
extends SOAPBuilderHelper
implements SOAP11Constants {
    private boolean faultcodePresent = false;
    private boolean faultstringPresent = false;

    @Override
    public AxiomElementType<? extends AxiomElement> handleEvent(OMElement parent, int elementLevel, String namespaceURI, String localName) throws SOAPProcessingException {
        AxiomElementType<AxiomElement> elementType = null;
        if (elementLevel == 4) {
            if ("faultcode".equals(localName)) {
                elementType = AxiomNodeFactory::createSOAP11FaultCode;
                this.faultcodePresent = true;
            } else if ("faultstring".equals(localName)) {
                elementType = AxiomNodeFactory::createSOAP11FaultReason;
                this.faultstringPresent = true;
            } else {
                elementType = "faultactor".equals(localName) ? AxiomNodeFactory::createSOAP11FaultRole : ("detail".equals(localName) ? AxiomNodeFactory::createSOAP11FaultDetail : AxiomNodeFactory::createNSAwareElement);
            }
        } else if (elementLevel == 5) {
            String parentTagName = "";
            parentTagName = parent instanceof Element ? ((Element)((Object)parent)).getTagName() : parent.getLocalName();
            if (parentTagName.equals("faultcode")) {
                throw new SOAPProcessingException("faultcode element should not have children");
            }
            if (parentTagName.equals("faultstring")) {
                throw new SOAPProcessingException("faultstring element should not have children");
            }
            if (parentTagName.equals("faultactor")) {
                throw new SOAPProcessingException("faultactor element should not have children");
            }
            elementType = AxiomNodeFactory::createNSAwareElement;
        } else if (elementLevel > 5) {
            elementType = AxiomNodeFactory::createNSAwareElement;
        }
        return elementType;
    }
}

