/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory.meta;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.common.builder.Detachable;

final class DetachableInputStream
extends InputStream
implements Detachable {
    private InputStream target;
    private final boolean closeOnDetach;

    DetachableInputStream(InputStream target, boolean closeOnDetach) {
        this.target = target;
        this.closeOnDetach = closeOnDetach;
    }

    @Override
    public int read() throws IOException {
        return this.target.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.target.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.target.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.target.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.target.available();
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }

    @Override
    public void detach() throws OMException {
        MemoryBlob blob = Blobs.createMemoryBlob();
        try {
            blob.readFrom(this.target);
        }
        catch (StreamCopyException ex) {
            throw new OMException(ex.getCause());
        }
        if (this.closeOnDetach) {
            try {
                this.target.close();
            }
            catch (IOException ex) {
                throw new OMException(ex);
            }
        }
        this.target = blob.readOnce();
    }
}

