/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.event;

import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.unomi.router.core.context.RouterCamelContext;
import org.apache.unomi.router.core.event.UpdateCamelRouteEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCamelRouteEventHandler
extends CellarSupport
implements EventHandler<UpdateCamelRouteEvent> {
    private static final Logger logger = LoggerFactory.getLogger((String)UpdateCamelRouteEventHandler.class.getName());
    private RouterCamelContext routerCamelContext;

    public void handle(UpdateCamelRouteEvent event) {
        logger.debug("Handle event");
        if (this.isAllowed(event.getSourceGroup(), "config", event.getId(), EventType.INBOUND).booleanValue()) {
            logger.debug("Event is allowed");
            if (event.getSourceNode() != null && event.getSourceNode().getId().equalsIgnoreCase(this.clusterManager.getNode().getId())) {
                logger.debug("Cluster event is local (coming from local synchronizer or listener)");
                return;
            }
            try {
                logger.debug("Event id is {}", (Object)event.getId());
                if (event.getId().equals(RouterCamelContext.EVENT_ID_REMOVE) && StringUtils.isNotBlank((CharSequence)event.getRouteId())) {
                    this.routerCamelContext.killExistingRoute(event.getRouteId(), false);
                } else if (event.getId().equals(RouterCamelContext.EVENT_ID_IMPORT)) {
                    this.routerCamelContext.updateProfileImportReaderRoute(event.getRouteId(), false);
                } else if (event.getId().equals(RouterCamelContext.EVENT_ID_EXPORT)) {
                    this.routerCamelContext.updateProfileExportReaderRoute(event.getRouteId(), false);
                }
            }
            catch (Exception e) {
                logger.error("Error when executing event", (Throwable)e);
            }
        }
    }

    public Class<UpdateCamelRouteEvent> getType() {
        return UpdateCamelRouteEvent.class;
    }

    public Switch getSwitch() {
        return null;
    }

    public void setRouterCamelContext(RouterCamelContext routerCamelContext) {
        this.routerCamelContext = routerCamelContext;
    }
}

