/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.lang.reflect.Method;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TransactionAttribute;
import org.apache.aries.transaction.TransactionToken;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.apache.aries.transaction.annotations.TransactionPropagationType;
import org.apache.aries.transaction.exception.TransactionRollbackException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.Coordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxInterceptorImpl
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxInterceptorImpl.class);
    private TransactionManager tm;
    private Coordinator coordinator;
    private TxComponentMetaDataHelper metaDataHelper;

    public int getRank() {
        return 1;
    }

    public Object preCall(ComponentMetadata cm, Method m, Object ... parameters) throws Throwable {
        String methodName = m.getName();
        TransactionPropagationType type = this.metaDataHelper.getComponentMethodTxAttribute(cm, methodName);
        if (type == null) {
            return null;
        }
        TransactionAttribute txAttribute = TransactionAttribute.fromValue(type);
        LOGGER.debug("PreCall for bean {}, method {} with tx strategy {}.", new Object[]{this.getCmId(cm), m.getName(), txAttribute});
        TransactionToken token = txAttribute.begin(this.tm);
        String coordName = "txInterceptor." + m.getDeclaringClass().getName() + "." + m.getName();
        Coordination coord = this.coordinator.begin(coordName, 0L);
        token.setCoordination(coord);
        return token;
    }

    public void postCallWithException(ComponentMetadata cm, Method m, Throwable ex, Object preCallToken) {
        LOGGER.debug("PostCallWithException for bean {}, method {}.", new Object[]{this.getCmId(cm), m.getName(), ex});
        if (!(preCallToken instanceof TransactionToken)) {
            return;
        }
        TransactionToken token = (TransactionToken)preCallToken;
        try {
            token.getCoordination().end();
        }
        catch (CoordinationException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        try {
            Transaction tran = token.getActiveTransaction();
            if (tran != null && this.isRollBackException(ex)) {
                tran.setRollbackOnly();
            }
            token.getTransactionAttribute().finish(this.tm, token);
        }
        catch (Exception e) {
            LOGGER.warn("Exception during transaction cleanup", (Throwable)e);
        }
    }

    private String getCmId(ComponentMetadata cm) {
        return cm == null ? null : cm.getId();
    }

    public void postCallWithReturn(ComponentMetadata cm, Method m, Object returnType, Object preCallToken) throws Exception {
        LOGGER.debug("PostCallWithReturn for bean {}, method {}.", (Object)this.getCmId(cm), (Object)m);
        if (preCallToken == null) {
            return;
        }
        if (preCallToken instanceof TransactionToken) {
            TransactionToken token = (TransactionToken)preCallToken;
            token.getCoordination().end();
            try {
                token.getTransactionAttribute().finish(this.tm, token);
            }
            catch (Exception e) {
                LOGGER.debug(Constants.MESSAGES.getMessage("exception.during.tx.finish", new Object[0]), (Throwable)e);
                throw new TransactionRollbackException(e);
            }
        }
    }

    private boolean isRollBackException(Throwable ex) {
        return ex instanceof RuntimeException || ex instanceof Error;
    }

    public final void setTransactionManager(TransactionManager manager) {
        this.tm = manager;
    }

    public void setCoordinator(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public final void setTxMetaDataHelper(TxComponentMetaDataHelper transactionEnhancer) {
        this.metaDataHelper = transactionEnhancer;
    }
}

