/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.health;

import io.smallrye.health.ResponseProvider;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import org.apache.tomee.microprofile.health.MicroProfileHealthReporter;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;

@ApplicationScoped
public class MicroProfileHealthReporterProducer {
    @Produces
    @ApplicationScoped
    public MicroProfileHealthReporter reporter() {
        String emptyLivenessChecksStatus = "UP";
        String emptyReadinessChecksStatus = "UP";
        String emptyStartupChecksStatus = "UP";
        boolean defaultServerProceduresDisabled = ConfigProvider.getConfig().getOptionalValue("mp.health.disable-default-procedures", Boolean.class).orElse(false);
        String defaultReadinessEmptyResponse = ConfigProvider.getConfig().getOptionalValue("mp.health.default.readiness.empty.response", String.class).orElse("DOWN");
        String defaultStartupEmptyResponse = ConfigProvider.getConfig().getOptionalValue("mp.health.default.startup.empty.response", String.class).orElse("DOWN");
        MicroProfileHealthReporter healthReporter = new MicroProfileHealthReporter("UP", "UP", "UP", defaultServerProceduresDisabled, defaultReadinessEmptyResponse, defaultStartupEmptyResponse);
        if (!defaultServerProceduresDisabled) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        }
        HealthCheckResponse.setResponseProvider((HealthCheckResponseProvider)new ResponseProvider());
        return healthReporter;
    }

    @PreDestroy
    public void removeResponseProvider() {
        HealthCheckResponse.setResponseProvider(null);
    }
}

