/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceElement;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferencePath;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertexProperty;

public class ReferenceFactory {
    private ReferenceFactory() {
    }

    public static ReferenceVertex detach(Vertex vertex) {
        return vertex instanceof ReferenceVertex ? (ReferenceVertex)vertex : new ReferenceVertex(vertex);
    }

    public static ReferenceEdge detach(Edge edge) {
        return edge instanceof ReferenceEdge ? (ReferenceEdge)edge : new ReferenceEdge(edge);
    }

    public static <V> ReferenceVertexProperty detach(VertexProperty<V> vertexProperty) {
        return vertexProperty instanceof ReferenceVertexProperty ? (ReferenceVertexProperty)vertexProperty : new ReferenceVertexProperty<V>(vertexProperty);
    }

    public static <V> ReferenceProperty<V> detach(Property<V> property) {
        return property instanceof ReferenceProperty ? (ReferenceProperty)property : new ReferenceProperty<V>(property);
    }

    public static ReferencePath detach(Path path) {
        return path instanceof ReferencePath ? (ReferencePath)path : new ReferencePath(path);
    }

    public static ReferenceElement detach(Element element) {
        if (element instanceof Vertex) {
            return ReferenceFactory.detach((Vertex)element);
        }
        if (element instanceof Edge) {
            return ReferenceFactory.detach((Edge)element);
        }
        if (element instanceof VertexProperty) {
            return ReferenceFactory.detach((VertexProperty)element);
        }
        throw new IllegalArgumentException("The provided argument is an unknown element: " + element + ":" + element.getClass());
    }

    public static <D> D detach(Object object) {
        if (object instanceof Element) {
            return (D)ReferenceFactory.detach((Element)object);
        }
        if (object instanceof Property) {
            return (D)ReferenceFactory.detach((Property)object);
        }
        if (object instanceof Path) {
            return (D)ReferenceFactory.detach((Path)object);
        }
        if (object instanceof List) {
            ArrayList<D> list = new ArrayList<D>(((List)object).size());
            for (Object item : (List)object) {
                list.add(ReferenceFactory.detach(item));
            }
            return (D)list;
        }
        if (object instanceof BulkSet) {
            BulkSet<D> set = new BulkSet<D>();
            for (Map.Entry entry : ((BulkSet)object).asBulk().entrySet()) {
                set.add(ReferenceFactory.detach(entry.getKey()), entry.getValue());
            }
            return (D)set;
        }
        if (object instanceof Set) {
            HashSet set = object instanceof LinkedHashSet ? new LinkedHashSet(((Set)object).size()) : new HashSet(((Set)object).size());
            for (Object item : (Set)object) {
                set.add(ReferenceFactory.detach(item));
            }
            return (D)set;
        }
        if (object instanceof Map) {
            Tree map = object instanceof Tree ? new Tree() : (object instanceof LinkedHashMap ? new LinkedHashMap(((Map)object).size()) : new HashMap(((Map)object).size()));
            for (Map.Entry entry : ((Map)object).entrySet()) {
                map.put(ReferenceFactory.detach(entry.getKey()), ReferenceFactory.detach(entry.getValue()));
            }
            return (D)map;
        }
        return (D)object;
    }
}

