/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction;

public abstract class AbstractThreadLocalTransaction
extends AbstractTransaction {
    protected final ThreadLocal<Consumer<Transaction>> readWriteConsumerInternal = new ThreadLocal<Consumer<Transaction>>(){

        @Override
        protected Consumer<Transaction> initialValue() {
            return Transaction.READ_WRITE_BEHAVIOR.AUTO;
        }
    };
    protected final ThreadLocal<Consumer<Transaction>> closeConsumerInternal = new ThreadLocal<Consumer<Transaction>>(){

        @Override
        protected Consumer<Transaction> initialValue() {
            return Transaction.CLOSE_BEHAVIOR.ROLLBACK;
        }
    };
    protected final ThreadLocal<List<Consumer<Transaction.Status>>> transactionListeners = new ThreadLocal<List<Consumer<Transaction.Status>>>(){

        @Override
        protected List<Consumer<Transaction.Status>> initialValue() {
            return new ArrayList<Consumer<Transaction.Status>>();
        }
    };

    public AbstractThreadLocalTransaction(Graph g) {
        super(g);
    }

    @Override
    protected void fireOnCommit() {
        this.transactionListeners.get().forEach(c -> c.accept(Transaction.Status.COMMIT));
    }

    @Override
    protected void fireOnRollback() {
        this.transactionListeners.get().forEach(c -> c.accept(Transaction.Status.ROLLBACK));
    }

    @Override
    public void addTransactionListener(Consumer<Transaction.Status> listener) {
        this.transactionListeners.get().add(listener);
    }

    @Override
    public void removeTransactionListener(Consumer<Transaction.Status> listener) {
        this.transactionListeners.get().remove(listener);
    }

    @Override
    public void clearTransactionListeners() {
        this.transactionListeners.get().clear();
    }

    @Override
    protected void doReadWrite() {
        this.readWriteConsumerInternal.get().accept(this);
    }

    @Override
    protected void doClose() {
        this.closeConsumerInternal.get().accept(this);
        this.closeConsumerInternal.remove();
        this.readWriteConsumerInternal.remove();
    }

    @Override
    public Transaction onReadWrite(Consumer<Transaction> consumer) {
        this.readWriteConsumerInternal.set(Optional.ofNullable(consumer).orElseThrow(Transaction.Exceptions::onReadWriteBehaviorCannotBeNull));
        return this;
    }

    @Override
    public Transaction onClose(Consumer<Transaction> consumer) {
        this.closeConsumerInternal.set(Optional.ofNullable(consumer).orElseThrow(Transaction.Exceptions::onReadWriteBehaviorCannotBeNull));
        return this;
    }
}

