/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AddSchemaFileTask
extends Task {
    @NotNull
    static final String ADD_SCHEMA_FILE_TASK_CLASS = "com.unboundid.directory.server.tasks.AddSchemaFileTask";
    @NotNull
    private static final String ATTR_SCHEMA_FILE = "ds-task-schema-file-name";
    @NotNull
    private static final String OC_ADD_SCHEMA_FILE_TASK = "ds-task-add-schema-file";
    @NotNull
    private static final TaskProperty PROPERTY_SCHEMA_FILE = new TaskProperty("ds-task-schema-file-name", TaskMessages.INFO_DISPLAY_NAME_SCHEMA_FILE.get(), TaskMessages.INFO_DESCRIPTION_SCHEMA_FILE.get(), String.class, true, true, false);
    private static final long serialVersionUID = -5430392768265418966L;
    @NotNull
    private final List<String> schemaFileNames;

    public AddSchemaFileTask() {
        this.schemaFileNames = null;
    }

    public AddSchemaFileTask(@Nullable String taskID, @NotNull String schemaFileName) {
        this(taskID, Collections.singletonList(schemaFileName), null, null, null, null, null);
        Validator.ensureNotNull(schemaFileName);
    }

    public AddSchemaFileTask(@Nullable String taskID, @NotNull List<String> schemaFileNames) {
        this(taskID, schemaFileNames, null, null, null, null, null);
    }

    public AddSchemaFileTask(@Nullable String taskID, @NotNull List<String> schemaFileNames, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, schemaFileNames, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public AddSchemaFileTask(@Nullable String taskID, @NotNull List<String> schemaFileNames, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, ADD_SCHEMA_FILE_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(schemaFileNames);
        Validator.ensureFalse(schemaFileNames.isEmpty(), "AddSchemaFileTask.schemaFileNames must not be empty.");
        this.schemaFileNames = Collections.unmodifiableList(schemaFileNames);
    }

    public AddSchemaFileTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        String[] fileNames = entry.getAttributeValues(ATTR_SCHEMA_FILE);
        if (fileNames == null || fileNames.length == 0) {
            throw new TaskException(TaskMessages.ERR_ADD_SCHEMA_FILE_TASK_NO_FILES.get(this.getTaskEntryDN()));
        }
        this.schemaFileNames = Collections.unmodifiableList(Arrays.asList(fileNames));
    }

    public AddSchemaFileTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(ADD_SCHEMA_FILE_TASK_CLASS, properties);
        String[] names = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (!attrName.equalsIgnoreCase(ATTR_SCHEMA_FILE)) continue;
            names = AddSchemaFileTask.parseStrings(p, values, names);
        }
        if (names == null) {
            throw new TaskException(TaskMessages.ERR_ADD_SCHEMA_FILE_TASK_NO_FILES.get(this.getTaskEntryDN()));
        }
        this.schemaFileNames = Collections.unmodifiableList(Arrays.asList(names));
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_ADD_SCHEMA_FILE.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_ADD_SCHEMA_FILE.get();
    }

    @NotNull
    public List<String> getSchemaFileNames() {
        return this.schemaFileNames;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_ADD_SCHEMA_FILE_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        return Collections.singletonList(new Attribute(ATTR_SCHEMA_FILE, this.schemaFileNames));
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.singletonList(PROPERTY_SCHEMA_FILE);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(10));
        props.put(PROPERTY_SCHEMA_FILE, Collections.unmodifiableList(this.schemaFileNames));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

