/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.AttributeSyntaxDefinition;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.DITContentRuleDefinition;
import com.unboundid.ldap.sdk.schema.DITStructureRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleUseDefinition;
import com.unboundid.ldap.sdk.schema.NameFormDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Schema
implements Serializable {
    @NotNull
    public static final String ATTR_ATTRIBUTE_SYNTAX = "ldapSyntaxes";
    @NotNull
    public static final String ATTR_ATTRIBUTE_TYPE = "attributeTypes";
    @NotNull
    public static final String ATTR_DIT_CONTENT_RULE = "dITContentRules";
    @NotNull
    public static final String ATTR_DIT_STRUCTURE_RULE = "dITStructureRules";
    @NotNull
    public static final String ATTR_MATCHING_RULE = "matchingRules";
    @NotNull
    public static final String ATTR_MATCHING_RULE_USE = "matchingRuleUse";
    @NotNull
    public static final String ATTR_NAME_FORM = "nameForms";
    @NotNull
    public static final String ATTR_OBJECT_CLASS = "objectClasses";
    @NotNull
    public static final String ATTR_SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    @NotNull
    private static final AtomicReference<Schema> DEFAULT_STANDARD_SCHEMA = new AtomicReference();
    @NotNull
    private static final String[] SCHEMA_REQUEST_ATTRS = new String[]{"*", "ldapSyntaxes", "attributeTypes", "dITContentRules", "dITStructureRules", "matchingRules", "matchingRuleUse", "nameForms", "objectClasses"};
    @NotNull
    private static final String[] SUBSCHEMA_SUBENTRY_REQUEST_ATTRS = new String[]{"subschemaSubentry"};
    @NotNull
    private static final String DEFAULT_SCHEMA_RESOURCE_PATH = "com/unboundid/ldap/sdk/schema/standard-schema.ldif";
    private static final long serialVersionUID = 8081839633831517925L;
    @NotNull
    private final Map<AttributeTypeDefinition, List<AttributeTypeDefinition>> subordinateAttributeTypes;
    @NotNull
    private final Map<String, AttributeSyntaxDefinition> asMap;
    @NotNull
    private final Map<String, AttributeTypeDefinition> atMap;
    @NotNull
    private final Map<String, DITContentRuleDefinition> dcrMap;
    @NotNull
    private final Map<Integer, DITStructureRuleDefinition> dsrMapByID;
    @NotNull
    private final Map<String, DITStructureRuleDefinition> dsrMapByName;
    @NotNull
    private final Map<String, DITStructureRuleDefinition> dsrMapByNameForm;
    @NotNull
    private final Map<String, MatchingRuleDefinition> mrMap;
    @NotNull
    private final Map<String, MatchingRuleUseDefinition> mruMap;
    @NotNull
    private final Map<String, NameFormDefinition> nfMapByName;
    @NotNull
    private final Map<String, NameFormDefinition> nfMapByOC;
    @NotNull
    private final Map<String, ObjectClassDefinition> ocMap;
    @NotNull
    private final ReadOnlyEntry schemaEntry;
    @NotNull
    private final Set<AttributeSyntaxDefinition> asSet;
    @NotNull
    private final Set<AttributeTypeDefinition> atSet;
    @NotNull
    private final Set<AttributeTypeDefinition> operationalATSet;
    @NotNull
    private final Set<AttributeTypeDefinition> userATSet;
    @NotNull
    private final Set<DITContentRuleDefinition> dcrSet;
    @NotNull
    private final Set<DITStructureRuleDefinition> dsrSet;
    @NotNull
    private final Set<MatchingRuleDefinition> mrSet;
    @NotNull
    private final Set<MatchingRuleUseDefinition> mruSet;
    @NotNull
    private final Set<NameFormDefinition> nfSet;
    @NotNull
    private final Set<ObjectClassDefinition> ocSet;
    @NotNull
    private final Set<ObjectClassDefinition> abstractOCSet;
    @NotNull
    private final Set<ObjectClassDefinition> auxiliaryOCSet;
    @NotNull
    private final Set<ObjectClassDefinition> structuralOCSet;

    public Schema(@NotNull Entry schemaEntry) {
        this(schemaEntry, null, null, null, null, null, null, null, null);
    }

    public Schema(@NotNull Entry schemaEntry, @Nullable Map<String, LDAPException> unparsableAttributeSyntaxes, @Nullable Map<String, LDAPException> unparsableMatchingRules, @Nullable Map<String, LDAPException> unparsableAttributeTypes, @Nullable Map<String, LDAPException> unparsableObjectClasses, @Nullable Map<String, LDAPException> unparsableDITContentRules, @Nullable Map<String, LDAPException> unparsableDITStructureRules, @Nullable Map<String, LDAPException> unparsableNameForms, @Nullable Map<String, LDAPException> unparsableMatchingRuleUses) {
        LinkedHashSet<SchemaElement> s;
        LinkedHashMap<String, SchemaElement> m;
        this.schemaEntry = new ReadOnlyEntry(schemaEntry);
        String[] defs = schemaEntry.getAttributeValues(ATTR_ATTRIBUTE_SYNTAX);
        if (defs == null) {
            this.asMap = Collections.emptyMap();
            this.asSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap<String, SchemaElement>(StaticUtils.computeMapCapacity(defs.length));
            s = new LinkedHashSet<SchemaElement>(StaticUtils.computeMapCapacity(defs.length));
            for (String def : defs) {
                try {
                    AttributeSyntaxDefinition as = new AttributeSyntaxDefinition(def);
                    s.add(as);
                    m.put(StaticUtils.toLowerCase(as.getOID()), as);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (unparsableAttributeSyntaxes == null) continue;
                    unparsableAttributeSyntaxes.put(def, le);
                }
            }
            this.asMap = Collections.unmodifiableMap(m);
            this.asSet = Collections.unmodifiableSet(s);
        }
        defs = schemaEntry.getAttributeValues(ATTR_ATTRIBUTE_TYPE);
        if (defs == null) {
            this.atMap = Collections.emptyMap();
            this.atSet = Collections.emptySet();
            this.operationalATSet = Collections.emptySet();
            this.userATSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(StaticUtils.computeMapCapacity(2 * defs.length));
            s = new LinkedHashSet(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashSet<AttributeTypeDefinition> sUser = new LinkedHashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashSet<AttributeTypeDefinition> sOperational = new LinkedHashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(defs.length));
            for (String def : defs) {
                try {
                    AttributeTypeDefinition at = new AttributeTypeDefinition(def);
                    s.add(at);
                    m.put(StaticUtils.toLowerCase(at.getOID()), at);
                    String[] arr$ = at.getNames();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String name = arr$[i$];
                        m.put(StaticUtils.toLowerCase(name), at);
                    }
                    if (at.isOperational()) {
                        sOperational.add(at);
                        continue;
                    }
                    sUser.add(at);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (unparsableAttributeTypes == null) continue;
                    unparsableAttributeTypes.put(def, le);
                }
            }
            this.atMap = Collections.unmodifiableMap(m);
            this.atSet = Collections.unmodifiableSet(s);
            this.operationalATSet = Collections.unmodifiableSet(sOperational);
            this.userATSet = Collections.unmodifiableSet(sUser);
        }
        defs = schemaEntry.getAttributeValues(ATTR_DIT_CONTENT_RULE);
        if (defs == null) {
            this.dcrMap = Collections.emptyMap();
            this.dcrSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(2 * defs.length);
            s = new LinkedHashSet(StaticUtils.computeMapCapacity(defs.length));
            for (String def : defs) {
                try {
                    DITContentRuleDefinition dcr = new DITContentRuleDefinition(def);
                    s.add(dcr);
                    m.put(StaticUtils.toLowerCase(dcr.getOID()), dcr);
                    for (String name : dcr.getNames()) {
                        m.put(StaticUtils.toLowerCase(name), dcr);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (unparsableDITContentRules == null) continue;
                    unparsableDITContentRules.put(def, le);
                }
            }
            this.dcrMap = Collections.unmodifiableMap(m);
            this.dcrSet = Collections.unmodifiableSet(s);
        }
        defs = schemaEntry.getAttributeValues(ATTR_DIT_STRUCTURE_RULE);
        if (defs == null) {
            this.dsrMapByID = Collections.emptyMap();
            this.dsrMapByName = Collections.emptyMap();
            this.dsrMapByNameForm = Collections.emptyMap();
            this.dsrSet = Collections.emptySet();
        } else {
            LinkedHashMap<Integer, DITStructureRuleDefinition> mID = new LinkedHashMap<Integer, DITStructureRuleDefinition>(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashMap<String, DITStructureRuleDefinition> mN = new LinkedHashMap<String, DITStructureRuleDefinition>(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashMap<String, DITStructureRuleDefinition> mNF = new LinkedHashMap<String, DITStructureRuleDefinition>(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashSet<DITStructureRuleDefinition> s2 = new LinkedHashSet<DITStructureRuleDefinition>(StaticUtils.computeMapCapacity(defs.length));
            for (String def : defs) {
                try {
                    DITStructureRuleDefinition dsr = new DITStructureRuleDefinition(def);
                    s2.add(dsr);
                    mID.put(dsr.getRuleID(), dsr);
                    mNF.put(StaticUtils.toLowerCase(dsr.getNameFormID()), dsr);
                    for (String name : dsr.getNames()) {
                        mN.put(StaticUtils.toLowerCase(name), dsr);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (unparsableDITStructureRules == null) continue;
                    unparsableDITStructureRules.put(def, le);
                }
            }
            this.dsrMapByID = Collections.unmodifiableMap(mID);
            this.dsrMapByName = Collections.unmodifiableMap(mN);
            this.dsrMapByNameForm = Collections.unmodifiableMap(mNF);
            this.dsrSet = Collections.unmodifiableSet(s2);
        }
        defs = schemaEntry.getAttributeValues(ATTR_MATCHING_RULE);
        if (defs == null) {
            this.mrMap = Collections.emptyMap();
            this.mrSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(StaticUtils.computeMapCapacity(2 * defs.length));
            s = new LinkedHashSet(StaticUtils.computeMapCapacity(defs.length));
            for (String def : defs) {
                try {
                    MatchingRuleDefinition mr = new MatchingRuleDefinition(def);
                    s.add(mr);
                    m.put(StaticUtils.toLowerCase(mr.getOID()), mr);
                    for (String name : mr.getNames()) {
                        m.put(StaticUtils.toLowerCase(name), mr);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (unparsableMatchingRules == null) continue;
                    unparsableMatchingRules.put(def, le);
                }
            }
            this.mrMap = Collections.unmodifiableMap(m);
            this.mrSet = Collections.unmodifiableSet(s);
        }
        defs = schemaEntry.getAttributeValues(ATTR_MATCHING_RULE_USE);
        if (defs == null) {
            this.mruMap = Collections.emptyMap();
            this.mruSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(StaticUtils.computeMapCapacity(2 * defs.length));
            s = new LinkedHashSet(StaticUtils.computeMapCapacity(defs.length));
            for (String def : defs) {
                try {
                    MatchingRuleUseDefinition mru = new MatchingRuleUseDefinition(def);
                    s.add(mru);
                    m.put(StaticUtils.toLowerCase(mru.getOID()), mru);
                    for (String name : mru.getNames()) {
                        m.put(StaticUtils.toLowerCase(name), mru);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (unparsableMatchingRuleUses == null) continue;
                    unparsableMatchingRuleUses.put(def, le);
                }
            }
            this.mruMap = Collections.unmodifiableMap(m);
            this.mruSet = Collections.unmodifiableSet(s);
        }
        defs = schemaEntry.getAttributeValues(ATTR_NAME_FORM);
        if (defs == null) {
            this.nfMapByName = Collections.emptyMap();
            this.nfMapByOC = Collections.emptyMap();
            this.nfSet = Collections.emptySet();
        } else {
            LinkedHashMap<String, NameFormDefinition> mN = new LinkedHashMap<String, NameFormDefinition>(StaticUtils.computeMapCapacity(2 * defs.length));
            LinkedHashMap<String, NameFormDefinition> mOC = new LinkedHashMap<String, NameFormDefinition>(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashSet<NameFormDefinition> s3 = new LinkedHashSet<NameFormDefinition>(StaticUtils.computeMapCapacity(defs.length));
            for (String def : defs) {
                try {
                    NameFormDefinition nf = new NameFormDefinition(def);
                    s3.add(nf);
                    mOC.put(StaticUtils.toLowerCase(nf.getStructuralClass()), nf);
                    mN.put(StaticUtils.toLowerCase(nf.getOID()), nf);
                    for (String name : nf.getNames()) {
                        mN.put(StaticUtils.toLowerCase(name), nf);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (unparsableNameForms == null) continue;
                    unparsableNameForms.put(def, le);
                }
            }
            this.nfMapByName = Collections.unmodifiableMap(mN);
            this.nfMapByOC = Collections.unmodifiableMap(mOC);
            this.nfSet = Collections.unmodifiableSet(s3);
        }
        defs = schemaEntry.getAttributeValues(ATTR_OBJECT_CLASS);
        if (defs == null) {
            this.ocMap = Collections.emptyMap();
            this.ocSet = Collections.emptySet();
            this.abstractOCSet = Collections.emptySet();
            this.auxiliaryOCSet = Collections.emptySet();
            this.structuralOCSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(StaticUtils.computeMapCapacity(2 * defs.length));
            s = new LinkedHashSet(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashSet<ObjectClassDefinition> sAbstract = new LinkedHashSet<ObjectClassDefinition>(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashSet<ObjectClassDefinition> sAuxiliary = new LinkedHashSet<ObjectClassDefinition>(StaticUtils.computeMapCapacity(defs.length));
            LinkedHashSet<ObjectClassDefinition> sStructural = new LinkedHashSet<ObjectClassDefinition>(StaticUtils.computeMapCapacity(defs.length));
            for (String def : defs) {
                try {
                    ObjectClassDefinition oc = new ObjectClassDefinition(def);
                    s.add(oc);
                    m.put(StaticUtils.toLowerCase(oc.getOID()), oc);
                    for (String name : oc.getNames()) {
                        m.put(StaticUtils.toLowerCase(name), oc);
                    }
                    switch (oc.getObjectClassType(this)) {
                        case ABSTRACT: {
                            sAbstract.add(oc);
                            break;
                        }
                        case AUXILIARY: {
                            sAuxiliary.add(oc);
                            break;
                        }
                        case STRUCTURAL: {
                            sStructural.add(oc);
                        }
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (unparsableObjectClasses == null) continue;
                    unparsableObjectClasses.put(def, le);
                }
            }
            this.ocMap = Collections.unmodifiableMap(m);
            this.ocSet = Collections.unmodifiableSet(s);
            this.abstractOCSet = Collections.unmodifiableSet(sAbstract);
            this.auxiliaryOCSet = Collections.unmodifiableSet(sAuxiliary);
            this.structuralOCSet = Collections.unmodifiableSet(sStructural);
        }
        LinkedHashMap<AttributeTypeDefinition, ArrayList<AttributeTypeDefinition>> subAttrTypes = new LinkedHashMap<AttributeTypeDefinition, ArrayList<AttributeTypeDefinition>>(StaticUtils.computeMapCapacity(this.atSet.size()));
        for (AttributeTypeDefinition d : this.atSet) {
            for (AttributeTypeDefinition sup = d.getSuperiorType(this); sup != null; sup = sup.getSuperiorType(this)) {
                ArrayList<AttributeTypeDefinition> l = (ArrayList<AttributeTypeDefinition>)subAttrTypes.get(sup);
                if (l == null) {
                    l = new ArrayList<AttributeTypeDefinition>(1);
                    subAttrTypes.put(sup, l);
                }
                l.add(d);
            }
        }
        this.subordinateAttributeTypes = Collections.unmodifiableMap(subAttrTypes);
    }

    @NotNull
    public static Schema parseSchemaEntry(@NotNull Entry schemaEntry) throws LDAPException {
        LinkedHashMap<String, LDAPException> unparsableAttributeSyntaxes = new LinkedHashMap<String, LDAPException>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, LDAPException> unparsableMatchingRules = new LinkedHashMap<String, LDAPException>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, LDAPException> unparsableAttributeTypes = new LinkedHashMap<String, LDAPException>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, LDAPException> unparsableObjectClasses = new LinkedHashMap<String, LDAPException>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, LDAPException> unparsableDITContentRules = new LinkedHashMap<String, LDAPException>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, LDAPException> unparsableDITStructureRules = new LinkedHashMap<String, LDAPException>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, LDAPException> unparsableNameForms = new LinkedHashMap<String, LDAPException>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, LDAPException> unparsableMatchingRuleUses = new LinkedHashMap<String, LDAPException>(StaticUtils.computeMapCapacity(10));
        Schema schema = new Schema(schemaEntry, unparsableAttributeSyntaxes, unparsableMatchingRules, unparsableAttributeTypes, unparsableObjectClasses, unparsableDITContentRules, unparsableDITStructureRules, unparsableNameForms, unparsableMatchingRuleUses);
        if (unparsableAttributeSyntaxes.isEmpty() && unparsableMatchingRules.isEmpty() && unparsableAttributeTypes.isEmpty() && unparsableObjectClasses.isEmpty() && unparsableDITContentRules.isEmpty() && unparsableDITStructureRules.isEmpty() && unparsableNameForms.isEmpty() && unparsableMatchingRuleUses.isEmpty()) {
            return schema;
        }
        StringBuilder messageBuffer = new StringBuilder();
        for (Map.Entry e : unparsableAttributeSyntaxes.entrySet()) {
            Schema.appendErrorMessage(messageBuffer, SchemaMessages.ERR_SCHEMA_UNPARSABLE_AS.get(ATTR_ATTRIBUTE_SYNTAX, e.getKey(), StaticUtils.getExceptionMessage((Throwable)e.getValue())));
        }
        for (Map.Entry e : unparsableMatchingRules.entrySet()) {
            Schema.appendErrorMessage(messageBuffer, SchemaMessages.ERR_SCHEMA_UNPARSABLE_MR.get(ATTR_MATCHING_RULE, e.getKey(), StaticUtils.getExceptionMessage((Throwable)e.getValue())));
        }
        for (Map.Entry e : unparsableAttributeTypes.entrySet()) {
            Schema.appendErrorMessage(messageBuffer, SchemaMessages.ERR_SCHEMA_UNPARSABLE_AT.get(ATTR_ATTRIBUTE_TYPE, e.getKey(), StaticUtils.getExceptionMessage((Throwable)e.getValue())));
        }
        for (Map.Entry e : unparsableObjectClasses.entrySet()) {
            Schema.appendErrorMessage(messageBuffer, SchemaMessages.ERR_SCHEMA_UNPARSABLE_OC.get(ATTR_OBJECT_CLASS, e.getKey(), StaticUtils.getExceptionMessage((Throwable)e.getValue())));
        }
        for (Map.Entry e : unparsableDITContentRules.entrySet()) {
            Schema.appendErrorMessage(messageBuffer, SchemaMessages.ERR_SCHEMA_UNPARSABLE_DCR.get(ATTR_DIT_CONTENT_RULE, e.getKey(), StaticUtils.getExceptionMessage((Throwable)e.getValue())));
        }
        for (Map.Entry e : unparsableDITStructureRules.entrySet()) {
            Schema.appendErrorMessage(messageBuffer, SchemaMessages.ERR_SCHEMA_UNPARSABLE_DSR.get(ATTR_DIT_STRUCTURE_RULE, e.getKey(), StaticUtils.getExceptionMessage((Throwable)e.getValue())));
        }
        for (Map.Entry e : unparsableNameForms.entrySet()) {
            Schema.appendErrorMessage(messageBuffer, SchemaMessages.ERR_SCHEMA_UNPARSABLE_NF.get(ATTR_NAME_FORM, e.getKey(), StaticUtils.getExceptionMessage((Throwable)e.getValue())));
        }
        for (Map.Entry e : unparsableMatchingRuleUses.entrySet()) {
            Schema.appendErrorMessage(messageBuffer, SchemaMessages.ERR_SCHEMA_UNPARSABLE_MRU.get(ATTR_MATCHING_RULE_USE, e.getKey(), StaticUtils.getExceptionMessage((Throwable)e.getValue())));
        }
        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, messageBuffer.toString());
    }

    private static void appendErrorMessage(@NotNull StringBuilder buffer, @NotNull String message) {
        int length = buffer.length();
        if (length > 0) {
            if (buffer.charAt(length - 1) == '.') {
                buffer.append("  ");
            } else {
                buffer.append(".  ");
            }
        }
        buffer.append(message);
    }

    @Nullable
    public static Schema getSchema(@NotNull LDAPConnection connection) throws LDAPException {
        return Schema.getSchema(connection, "");
    }

    @Nullable
    public static Schema getSchema(@NotNull LDAPConnection connection, @Nullable String entryDN) throws LDAPException {
        return Schema.getSchema(connection, entryDN, false);
    }

    @Nullable
    public static Schema getSchema(@NotNull LDAPConnection connection, @Nullable String entryDN, boolean throwOnUnparsableElement) throws LDAPException {
        Validator.ensureNotNull(connection);
        String subschemaSubentryDN = entryDN == null ? Schema.getSubschemaSubentryDN(connection, "") : Schema.getSubschemaSubentryDN(connection, entryDN);
        if (subschemaSubentryDN == null) {
            return null;
        }
        SearchResultEntry schemaEntry = connection.searchForEntry(subschemaSubentryDN, SearchScope.BASE, Filter.createEqualityFilter("objectClass", "subschema"), SCHEMA_REQUEST_ATTRS);
        if (schemaEntry == null) {
            return null;
        }
        if (throwOnUnparsableElement) {
            return Schema.parseSchemaEntry(schemaEntry);
        }
        return new Schema(schemaEntry);
    }

    @Nullable
    public static Schema getSchema(String ... schemaFiles) throws IOException, LDIFException {
        Validator.ensureNotNull(schemaFiles);
        Validator.ensureFalse(schemaFiles.length == 0);
        ArrayList<File> files = new ArrayList<File>(schemaFiles.length);
        for (String s : schemaFiles) {
            files.add(new File(s));
        }
        return Schema.getSchema(files);
    }

    @Nullable
    public static Schema getSchema(File ... schemaFiles) throws IOException, LDIFException {
        Validator.ensureNotNull(schemaFiles);
        Validator.ensureFalse(schemaFiles.length == 0);
        return Schema.getSchema(Arrays.asList(schemaFiles));
    }

    @Nullable
    public static Schema getSchema(@NotNull List<File> schemaFiles) throws IOException, LDIFException {
        return Schema.getSchema(schemaFiles, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Schema getSchema(@NotNull List<File> schemaFiles, boolean throwOnUnparsableElement) throws IOException, LDIFException {
        Validator.ensureNotNull(schemaFiles);
        Validator.ensureFalse(schemaFiles.isEmpty());
        Entry schemaEntry = null;
        for (File f : schemaFiles) {
            try (LDIFReader ldifReader = new LDIFReader(f);){
                Entry e = ldifReader.readEntry();
                if (e == null) continue;
                e.addAttribute("objectClass", "top", "ldapSubentry", "subschema");
                if (schemaEntry == null) {
                    schemaEntry = e;
                    continue;
                }
                for (Attribute a : e.getAttributes()) {
                    schemaEntry.addAttribute(a);
                }
            }
        }
        if (schemaEntry == null) {
            return null;
        }
        if (throwOnUnparsableElement) {
            try {
                return Schema.parseSchemaEntry(schemaEntry);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new LDIFException(e.getMessage(), 0L, false, e);
            }
        }
        return new Schema(schemaEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Schema getSchema(@NotNull InputStream inputStream) throws IOException, LDIFException {
        Validator.ensureNotNull(inputStream);
        try (LDIFReader ldifReader = new LDIFReader(inputStream);){
            Entry e = ldifReader.readEntry();
            if (e == null) {
                Schema schema = null;
                return schema;
            }
            Schema schema = new Schema(e);
            return schema;
        }
    }

    @NotNull
    public static Schema getDefaultStandardSchema() throws LDAPException {
        Schema s = DEFAULT_STANDARD_SCHEMA.get();
        if (s != null) {
            return s;
        }
        AtomicReference<Schema> atomicReference = DEFAULT_STANDARD_SCHEMA;
        synchronized (atomicReference) {
            try {
                ClassLoader classLoader = Schema.class.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(DEFAULT_SCHEMA_RESOURCE_PATH);
                LDIFReader ldifReader = new LDIFReader(inputStream);
                Entry schemaEntry = ldifReader.readEntry();
                ldifReader.close();
                Schema schema = new Schema(schemaEntry);
                DEFAULT_STANDARD_SCHEMA.set(schema);
                return schema;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, SchemaMessages.ERR_SCHEMA_CANNOT_LOAD_DEFAULT_DEFINITIONS.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    @Nullable
    public static Schema mergeSchemas(Schema ... schemas) {
        if (schemas == null || schemas.length == 0) {
            return null;
        }
        if (schemas.length == 1) {
            return schemas[0];
        }
        LinkedHashMap<String, String> asMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(100));
        LinkedHashMap<String, String> atMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(100));
        LinkedHashMap<String, String> dcrMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<Integer, String> dsrMap = new LinkedHashMap<Integer, String>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, String> mrMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(100));
        LinkedHashMap<String, String> mruMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, String> nfMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(10));
        LinkedHashMap<String, String> ocMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(100));
        for (Schema s : schemas) {
            for (AttributeSyntaxDefinition as : s.asSet) {
                asMap.put(StaticUtils.toLowerCase(as.getOID()), as.toString());
            }
            for (AttributeTypeDefinition at : s.atSet) {
                atMap.put(StaticUtils.toLowerCase(at.getOID()), at.toString());
            }
            for (DITContentRuleDefinition dcr : s.dcrSet) {
                dcrMap.put(StaticUtils.toLowerCase(dcr.getOID()), dcr.toString());
            }
            for (DITStructureRuleDefinition dsr : s.dsrSet) {
                dsrMap.put(dsr.getRuleID(), dsr.toString());
            }
            for (MatchingRuleDefinition mr : s.mrSet) {
                mrMap.put(StaticUtils.toLowerCase(mr.getOID()), mr.toString());
            }
            for (MatchingRuleUseDefinition mru : s.mruSet) {
                mruMap.put(StaticUtils.toLowerCase(mru.getOID()), mru.toString());
            }
            for (NameFormDefinition nf : s.nfSet) {
                nfMap.put(StaticUtils.toLowerCase(nf.getOID()), nf.toString());
            }
            for (ObjectClassDefinition oc : s.ocSet) {
                ocMap.put(StaticUtils.toLowerCase(oc.getOID()), oc.toString());
            }
        }
        Entry e = new Entry(schemas[0].getSchemaEntry().getDN());
        Attribute ocAttr = schemas[0].getSchemaEntry().getObjectClassAttribute();
        if (ocAttr == null) {
            e.addAttribute("objectClass", "top", "ldapSubEntry", "subschema");
        } else {
            e.addAttribute(ocAttr);
        }
        if (!asMap.isEmpty()) {
            String[] values = new String[asMap.size()];
            e.addAttribute(ATTR_ATTRIBUTE_SYNTAX, asMap.values().toArray(values));
        }
        if (!mrMap.isEmpty()) {
            String[] values = new String[mrMap.size()];
            e.addAttribute(ATTR_MATCHING_RULE, mrMap.values().toArray(values));
        }
        if (!atMap.isEmpty()) {
            String[] values = new String[atMap.size()];
            e.addAttribute(ATTR_ATTRIBUTE_TYPE, atMap.values().toArray(values));
        }
        if (!ocMap.isEmpty()) {
            String[] values = new String[ocMap.size()];
            e.addAttribute(ATTR_OBJECT_CLASS, ocMap.values().toArray(values));
        }
        if (!dcrMap.isEmpty()) {
            String[] values = new String[dcrMap.size()];
            e.addAttribute(ATTR_DIT_CONTENT_RULE, dcrMap.values().toArray(values));
        }
        if (!dsrMap.isEmpty()) {
            String[] values = new String[dsrMap.size()];
            e.addAttribute(ATTR_DIT_STRUCTURE_RULE, dsrMap.values().toArray(values));
        }
        if (!nfMap.isEmpty()) {
            String[] values = new String[nfMap.size()];
            e.addAttribute(ATTR_NAME_FORM, nfMap.values().toArray(values));
        }
        if (!mruMap.isEmpty()) {
            String[] values = new String[mruMap.size()];
            e.addAttribute(ATTR_MATCHING_RULE_USE, mruMap.values().toArray(values));
        }
        return new Schema(e);
    }

    @NotNull
    public ReadOnlyEntry getSchemaEntry() {
        return this.schemaEntry;
    }

    @Nullable
    public static String getSubschemaSubentryDN(@NotNull LDAPConnection connection, @Nullable String entryDN) throws LDAPException {
        Validator.ensureNotNull(connection);
        SearchResultEntry e = entryDN == null ? connection.getEntry("", SUBSCHEMA_SUBENTRY_REQUEST_ATTRS) : connection.getEntry(entryDN, SUBSCHEMA_SUBENTRY_REQUEST_ATTRS);
        if (e == null) {
            return null;
        }
        return e.getAttributeValue(ATTR_SUBSCHEMA_SUBENTRY);
    }

    @NotNull
    public Set<AttributeSyntaxDefinition> getAttributeSyntaxes() {
        return this.asSet;
    }

    @Nullable
    public AttributeSyntaxDefinition getAttributeSyntax(@NotNull String oid) {
        Validator.ensureNotNull(oid);
        String lowerOID = StaticUtils.toLowerCase(oid);
        int curlyPos = lowerOID.indexOf(123);
        if (curlyPos > 0) {
            return this.asMap.get(lowerOID.substring(0, curlyPos));
        }
        return this.asMap.get(lowerOID);
    }

    @NotNull
    public Set<AttributeTypeDefinition> getAttributeTypes() {
        return this.atSet;
    }

    @NotNull
    public Set<AttributeTypeDefinition> getOperationalAttributeTypes() {
        return this.operationalATSet;
    }

    @NotNull
    public Set<AttributeTypeDefinition> getUserAttributeTypes() {
        return this.userATSet;
    }

    @Nullable
    public AttributeTypeDefinition getAttributeType(@NotNull String name) {
        Validator.ensureNotNull(name);
        return this.atMap.get(StaticUtils.toLowerCase(name));
    }

    @NotNull
    public List<AttributeTypeDefinition> getSubordinateAttributeTypes(@NotNull AttributeTypeDefinition d) {
        Validator.ensureNotNull(d);
        List<AttributeTypeDefinition> l = this.subordinateAttributeTypes.get(d);
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    @NotNull
    public Set<DITContentRuleDefinition> getDITContentRules() {
        return this.dcrSet;
    }

    @Nullable
    public DITContentRuleDefinition getDITContentRule(@NotNull String name) {
        Validator.ensureNotNull(name);
        return this.dcrMap.get(StaticUtils.toLowerCase(name));
    }

    @NotNull
    public Set<DITStructureRuleDefinition> getDITStructureRules() {
        return this.dsrSet;
    }

    @Nullable
    public DITStructureRuleDefinition getDITStructureRuleByID(int ruleID) {
        return this.dsrMapByID.get(ruleID);
    }

    @Nullable
    public DITStructureRuleDefinition getDITStructureRuleByName(@NotNull String ruleName) {
        Validator.ensureNotNull(ruleName);
        return this.dsrMapByName.get(StaticUtils.toLowerCase(ruleName));
    }

    @Nullable
    public DITStructureRuleDefinition getDITStructureRuleByNameForm(@NotNull String nameForm) {
        Validator.ensureNotNull(nameForm);
        return this.dsrMapByNameForm.get(StaticUtils.toLowerCase(nameForm));
    }

    @NotNull
    public Set<MatchingRuleDefinition> getMatchingRules() {
        return this.mrSet;
    }

    @Nullable
    public MatchingRuleDefinition getMatchingRule(@NotNull String name) {
        Validator.ensureNotNull(name);
        return this.mrMap.get(StaticUtils.toLowerCase(name));
    }

    @NotNull
    public Set<MatchingRuleUseDefinition> getMatchingRuleUses() {
        return this.mruSet;
    }

    @Nullable
    public MatchingRuleUseDefinition getMatchingRuleUse(@NotNull String name) {
        Validator.ensureNotNull(name);
        return this.mruMap.get(StaticUtils.toLowerCase(name));
    }

    @NotNull
    public Set<NameFormDefinition> getNameForms() {
        return this.nfSet;
    }

    @Nullable
    public NameFormDefinition getNameFormByName(@NotNull String name) {
        Validator.ensureNotNull(name);
        return this.nfMapByName.get(StaticUtils.toLowerCase(name));
    }

    @NotNull
    public NameFormDefinition getNameFormByObjectClass(@NotNull String objectClass) {
        Validator.ensureNotNull(objectClass);
        return this.nfMapByOC.get(StaticUtils.toLowerCase(objectClass));
    }

    @NotNull
    public Set<ObjectClassDefinition> getObjectClasses() {
        return this.ocSet;
    }

    @NotNull
    public Set<ObjectClassDefinition> getAbstractObjectClasses() {
        return this.abstractOCSet;
    }

    @NotNull
    public Set<ObjectClassDefinition> getAuxiliaryObjectClasses() {
        return this.auxiliaryOCSet;
    }

    @NotNull
    public Set<ObjectClassDefinition> getStructuralObjectClasses() {
        return this.structuralOCSet;
    }

    @Nullable
    public ObjectClassDefinition getObjectClass(@NotNull String name) {
        Validator.ensureNotNull(name);
        return this.ocMap.get(StaticUtils.toLowerCase(name));
    }

    public int hashCode() {
        int hc;
        try {
            hc = this.schemaEntry.getParsedDN().hashCode();
        }
        catch (Exception e) {
            Debug.debugException(e);
            hc = StaticUtils.toLowerCase(this.schemaEntry.getDN()).hashCode();
        }
        Attribute a = this.schemaEntry.getAttribute(ATTR_ATTRIBUTE_SYNTAX);
        if (a != null) {
            hc += a.hashCode();
        }
        if ((a = this.schemaEntry.getAttribute(ATTR_MATCHING_RULE)) != null) {
            hc += a.hashCode();
        }
        if ((a = this.schemaEntry.getAttribute(ATTR_ATTRIBUTE_TYPE)) != null) {
            hc += a.hashCode();
        }
        if ((a = this.schemaEntry.getAttribute(ATTR_OBJECT_CLASS)) != null) {
            hc += a.hashCode();
        }
        if ((a = this.schemaEntry.getAttribute(ATTR_NAME_FORM)) != null) {
            hc += a.hashCode();
        }
        if ((a = this.schemaEntry.getAttribute(ATTR_DIT_CONTENT_RULE)) != null) {
            hc += a.hashCode();
        }
        if ((a = this.schemaEntry.getAttribute(ATTR_DIT_STRUCTURE_RULE)) != null) {
            hc += a.hashCode();
        }
        if ((a = this.schemaEntry.getAttribute(ATTR_MATCHING_RULE_USE)) != null) {
            hc += a.hashCode();
        }
        return hc;
    }

    public boolean equals(@Nullable Object o) {
        Schema s;
        block6: {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Schema)) {
                return false;
            }
            s = (Schema)o;
            try {
                if (!this.schemaEntry.getParsedDN().equals(s.schemaEntry.getParsedDN())) {
                    return false;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (this.schemaEntry.getDN().equalsIgnoreCase(s.schemaEntry.getDN())) break block6;
                return false;
            }
        }
        return this.asSet.equals(s.asSet) && this.mrSet.equals(s.mrSet) && this.atSet.equals(s.atSet) && this.ocSet.equals(s.ocSet) && this.nfSet.equals(s.nfSet) && this.dcrSet.equals(s.dcrSet) && this.dsrSet.equals(s.dsrSet) && this.mruSet.equals(s.mruSet);
    }

    @NotNull
    public String toString() {
        return this.schemaEntry.toString();
    }
}

