/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.audit;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxEventBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonDiffPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuditHistoryDetails<T extends Serializable>
extends Panel
implements ModalPanel {
    private static final long serialVersionUID = -7400543686272100483L;
    protected static final Logger LOG = LoggerFactory.getLogger(AuditHistoryDetails.class);
    public static final List<String> DEFAULT_EVENTS = List.of("create", "update", "matchingrule_update", "unmatchingrule_assign", "unmatchingrule_provision");
    protected static final SortParam<String> REST_SORT = new SortParam((Object)"event_date", false);
    protected static final ObjectMapper MAPPER = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().nodeFactory((JsonNodeFactory)new SortingNodeFactory())).build()).registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new SortedSetJsonSerializer(AuditHistoryDetails.cast(Set.class)))).registerModule((Module)new JavaTimeModule());
    protected EntityTO currentEntity;
    protected AuditElements.EventCategoryType type;
    protected String category;
    protected final List<String> events;
    protected Class<T> reference;
    protected final List<AuditEntry> auditEntries = new ArrayList<AuditEntry>();
    protected AuditEntry latestAuditEntry;
    protected AuditEntry after;
    protected AjaxDropDownChoicePanel<AuditEntry> beforeVersionsPanel;
    protected AjaxDropDownChoicePanel<AuditEntry> afterVersionsPanel;
    protected final AjaxLink<Void> restore;
    protected final AuditRestClient restClient;

    protected static <T> Class<T> cast(Class<?> aClass) {
        return aClass;
    }

    public AuditHistoryDetails(String id, EntityTO currentEntity, AuditElements.EventCategoryType type, String category, List<String> events, String auditRestoreEntitlement, AuditRestClient restClient) {
        super(id);
        this.currentEntity = currentEntity;
        this.type = type;
        this.category = category;
        this.events = events;
        this.reference = currentEntity.getClass();
        this.restClient = restClient;
        this.setOutputMarkupId(true);
        IChoiceRenderer<AuditEntry> choiceRenderer = new IChoiceRenderer<AuditEntry>(){
            private static final long serialVersionUID = -3724971416312135885L;

            public String getDisplayValue(AuditEntry value) {
                return SyncopeConsoleSession.get().getDateFormat().format(value.getDate());
            }

            public String getIdValue(AuditEntry value, int i) {
                return Long.toString(value.getDate().toInstant().toEpochMilli());
            }

            public AuditEntry getObject(String id, IModel<? extends List<? extends AuditEntry>> choices) {
                return ((List)choices.getObject()).stream().filter(c -> StringUtils.isNotBlank((CharSequence)id) && Long.parseLong(id) == c.getDate().toInstant().toEpochMilli()).findFirst().orElse(null);
            }
        };
        this.beforeVersionsPanel = new AjaxDropDownChoicePanel("beforeVersions", this.getString("beforeVersions"), (IModel)new Model(), true);
        this.beforeVersionsPanel.setChoiceRenderer((IChoiceRenderer)choiceRenderer);
        this.beforeVersionsPanel.add(new Behavior[]{new IndicatorAjaxEventBehavior("change"){
            private static final long serialVersionUID = -6383712635009760397L;

            protected void onEvent(AjaxRequestTarget target) {
                AuditEntry beforeEntry = AuditHistoryDetails.this.beforeVersionsPanel.getModelObject() == null ? AuditHistoryDetails.this.latestAuditEntry : (AuditEntry)AuditHistoryDetails.this.beforeVersionsPanel.getModelObject();
                AuditEntry afterEntry = AuditHistoryDetails.this.afterVersionsPanel.getModelObject() == null ? AuditHistoryDetails.this.after : AuditHistoryDetails.this.buildAfterAuditEntry(beforeEntry);
                AuditHistoryDetails.this.addOrReplace(new Component[]{new JsonDiffPanel((IModel<String>)AuditHistoryDetails.this.toJSON(beforeEntry, AuditHistoryDetails.this.reference), (IModel<String>)AuditHistoryDetails.this.toJSON(afterEntry, AuditHistoryDetails.this.reference))});
                AuditHistoryDetails.this.afterVersionsPanel.setChoices(AuditHistoryDetails.this.auditEntries.stream().filter(ae -> ae.getDate().isAfter(beforeEntry.getDate()) || ae.getDate().isEqual(beforeEntry.getDate())).collect(Collectors.toList()));
                AuditHistoryDetails.this.afterVersionsPanel.setModelObject((Serializable)afterEntry);
                target.add(new Component[]{AuditHistoryDetails.this});
            }
        }});
        this.afterVersionsPanel = new AjaxDropDownChoicePanel("afterVersions", this.getString("afterVersions"), (IModel)new Model(), true);
        this.afterVersionsPanel.setChoiceRenderer((IChoiceRenderer)choiceRenderer);
        this.afterVersionsPanel.add(new Behavior[]{new IndicatorAjaxEventBehavior("change"){
            private static final long serialVersionUID = -6383712635009760397L;

            protected void onEvent(AjaxRequestTarget target) {
                AuditHistoryDetails.this.addOrReplace(new Component[]{new JsonDiffPanel((IModel<String>)AuditHistoryDetails.this.toJSON(AuditHistoryDetails.this.beforeVersionsPanel.getModelObject() == null ? AuditHistoryDetails.this.latestAuditEntry : (AuditEntry)AuditHistoryDetails.this.beforeVersionsPanel.getModelObject(), AuditHistoryDetails.this.reference), (IModel<String>)AuditHistoryDetails.this.toJSON(AuditHistoryDetails.this.afterVersionsPanel.getModelObject() == null ? AuditHistoryDetails.this.after : AuditHistoryDetails.this.buildAfterAuditEntry((AuditEntry)AuditHistoryDetails.this.afterVersionsPanel.getModelObject()), AuditHistoryDetails.this.reference))});
                target.add(new Component[]{AuditHistoryDetails.this});
            }
        }});
        this.add(new Component[]{this.beforeVersionsPanel.setOutputMarkupId(true)});
        this.add(new Component[]{this.afterVersionsPanel.setOutputMarkupId(true)});
        this.restore = new AjaxLink<Void>("restore"){
            private static final long serialVersionUID = -817438685948164787L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    AuditEntry before;
                    AuditEntry auditEntry = before = AuditHistoryDetails.this.beforeVersionsPanel.getModelObject() == null ? AuditHistoryDetails.this.latestAuditEntry : (AuditEntry)AuditHistoryDetails.this.beforeVersionsPanel.getModelObject();
                    String json = before.getBefore() == null ? (MAPPER.readTree(before.getOutput()).get("entity") == null ? MAPPER.readTree(before.getOutput()).toPrettyString() : MAPPER.readTree(before.getOutput()).get("entity").toPrettyString()) : before.getBefore();
                    AuditHistoryDetails.this.restore(json, target);
                }
                catch (JsonProcessingException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize(this.restore, (Action)ENABLE, (String)auditRestoreEntitlement);
        this.add(new Component[]{this.restore});
        this.initDiff();
    }

    protected abstract void restore(String var1, AjaxRequestTarget var2);

    protected void initDiff() {
        this.auditEntries.clear();
        this.auditEntries.addAll(this.restClient.search(this.currentEntity.getKey(), 1, 50, this.type, this.category, this.events, AuditElements.Result.SUCCESS, REST_SORT));
        this.latestAuditEntry = this.auditEntries.isEmpty() ? null : this.auditEntries.get(0);
        this.after = this.latestAuditEntry == null ? null : this.buildAfterAuditEntry(this.latestAuditEntry);
        this.addOrReplace(new Component[]{new JsonDiffPanel((IModel<String>)this.toJSON(this.latestAuditEntry, this.reference), (IModel<String>)this.toJSON(this.after, this.reference))});
        this.beforeVersionsPanel.setChoices(this.auditEntries);
        this.afterVersionsPanel.setChoices(this.auditEntries.stream().filter(ae -> ae.getDate().isAfter(this.after.getDate()) || ae.getDate().isEqual(this.after.getDate())).collect(Collectors.toList()));
        this.beforeVersionsPanel.setModelObject((Serializable)this.latestAuditEntry);
        this.afterVersionsPanel.setModelObject((Serializable)this.after);
        this.restore.setEnabled(!this.auditEntries.isEmpty());
    }

    protected AuditEntry buildAfterAuditEntry(AuditEntry input) {
        AuditEntry output = new AuditEntry();
        output.setWho(input.getWho());
        output.setDate(input.getDate());
        output.setOutput(input.getOutput());
        output.setThrowable(input.getThrowable());
        return output;
    }

    protected Model<String> toJSON(AuditEntry auditEntry, Class<T> reference) {
        if (auditEntry == null) {
            return Model.of();
        }
        try {
            JsonNode output;
            String content = auditEntry.getBefore() == null ? ((output = MAPPER.readTree(auditEntry.getOutput())).has("entity") ? output.get("entity").toPrettyString() : output.toPrettyString()) : auditEntry.getBefore();
            Serializable entity = (Serializable)MAPPER.reader().with(StreamReadFeature.STRICT_DUPLICATE_DETECTION).readValue(content, reference);
            if (entity instanceof UserTO) {
                UserTO userTO = (UserTO)entity;
                userTO.setPassword(null);
                userTO.setSecurityAnswer(null);
            }
            return Model.of((Serializable)((Object)MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)entity)));
        }
        catch (Exception e) {
            LOG.error("While (de)serializing entity {}", (Object)auditEntry, (Object)e);
            return Model.of();
        }
    }

    protected static class SortedSetJsonSerializer
    extends StdSerializer<Set<?>> {
        private static final long serialVersionUID = 3849059774309L;

        SortedSetJsonSerializer(Class<Set<?>> clazz) {
            super(clazz);
        }

        public void serialize(Set<?> set, JsonGenerator gen, SerializerProvider sp) throws IOException {
            if (set == null) {
                gen.writeNull();
                return;
            }
            gen.writeStartArray();
            if (!set.isEmpty()) {
                Set<?> sorted = set;
                if (!SortedSet.class.isAssignableFrom(set.getClass())) {
                    Object item = set.iterator().next();
                    if (Comparable.class.isAssignableFrom(item.getClass())) {
                        sorted = new TreeSet(set);
                    } else {
                        LOG.debug("Cannot sort items of type {}", item.getClass());
                    }
                }
                for (Object item : sorted) {
                    gen.writeObject(item);
                }
            }
            gen.writeEndArray();
        }
    }

    protected static class SortingNodeFactory
    extends JsonNodeFactory {
        private static final long serialVersionUID = 1870252010670L;

        protected SortingNodeFactory() {
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

