/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apereo.cas.logging.LoggingUtils;

@Plugin(name="CasAppender", category="Core", elementType="appender", printObject=true)
public class CasAppender
extends AbstractAppender {
    private final Configuration config;
    private final AppenderRef appenderRef;

    public CasAppender(String name, Configuration config, AppenderRef appenderRef) {
        super(name, null, (Layout)PatternLayout.createDefaultLayout(), false, Property.EMPTY_ARRAY);
        this.config = config;
        this.appenderRef = appenderRef;
    }

    public CasAppender(String name, Configuration config, AppenderRef appenderRef, Filter filter) {
        super(name, filter, (Layout)PatternLayout.createDefaultLayout(), false, Property.EMPTY_ARRAY);
        this.config = config;
        this.appenderRef = appenderRef;
    }

    @PluginFactory
    public static CasAppender build(@PluginAttribute(value="name") String name, @PluginElement(value="AppenderRef") AppenderRef appenderRef, @PluginElement(value="Filter") Filter filter, @PluginConfiguration Configuration config) {
        return new CasAppender(name, config, appenderRef, filter);
    }

    public void append(LogEvent logEvent) {
        String refName = this.appenderRef.getRef();
        if (StringUtils.isNotBlank((CharSequence)refName)) {
            Appender appender = this.config.getAppender(refName);
            if (appender != null) {
                LogEvent newLogEvent = LoggingUtils.prepareLogEvent(logEvent);
                appender.append(newLogEvent);
            } else {
                LOGGER.warn("No log appender could be found for [{}]", (Object)refName);
            }
        } else {
            LOGGER.warn("No log appender reference for [{}] could be located in logging configuration.", (Object)refName);
        }
    }
}

